/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.version;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionNumber
implements Comparable<VersionNumber>,
Serializable {
    public static final int MAX_PART = 99;
    public static final VersionNumber ZERO_VERSION = new VersionNumber(0, 0, 0);
    public static final VersionNumber LIMIT_VERSION = new VersionNumber(99, 99, 99);
    private static final String TAG_FORMATTER = "v%01d_%02d_%02d";
    private static final String BRANCH_FORMATTER = "v%01d_%02d";
    private static final String TXT_FORMATTER = "%d.%d.%d";
    private static final String DRX = "\\d+{1,2}";
    private static final String GDRX = "(\\d+{1,2})";
    private static final String TAG_REGEX = String.format("v%s_%s_%s", "(\\d+{1,2})", "(\\d+{1,2})", "(\\d+{1,2})");
    private static final String BRANCH_REGEX = String.format("v%s_%s", "(\\d+{1,2})", "(\\d+{1,2})");
    private static final String TXT_REGEX = String.format("%s\\.%s\\.%s", "(\\d+{1,2})", "(\\d+{1,2})", "(\\d+{1,2})");
    static final Pattern TAG_PATT = Pattern.compile(TAG_REGEX);
    static final Pattern BRANCH_PATT = Pattern.compile(BRANCH_REGEX);
    static final Pattern TXT_PATT = Pattern.compile(TXT_REGEX);
    private static final int INVALID = -9999;
    private boolean isFrozen = false;
    private int major;
    private int minor;
    private int patch;

    public VersionNumber(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.check();
    }

    public static VersionNumber fromString(String text) {
        int[] idxs = new int[]{1, 2, 3};
        return VersionNumber.fromStringAsPattern(TXT_PATT, text, idxs);
    }

    public static VersionNumber fromStringAsBranch(String text) {
        int[] idxs = new int[]{1, 2, 1};
        VersionNumber version = VersionNumber.fromStringAsPattern(BRANCH_PATT, text, idxs);
        version.setPatch(0);
        return version;
    }

    private static VersionNumber fromStringAsPattern(Pattern pattern, String text, int[] indexes) {
        Matcher matcher = pattern.matcher(text);
        if (!matcher.matches()) {
            return null;
        }
        String strMajor = matcher.group(indexes[0]);
        String strMinor = matcher.group(indexes[1]);
        String strPatch = matcher.group(indexes[2]);
        if (strMajor == null || strMinor == null || strPatch == null) {
            return null;
        }
        try {
            int mj = Integer.parseInt(strMajor);
            int mn = Integer.parseInt(strMinor);
            int pt = Integer.parseInt(strPatch);
            VersionNumber version = new VersionNumber(mj, mn, pt);
            return version;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static VersionNumber fromStringAsTag(String text) {
        int[] idxs = new int[]{1, 2, 3};
        return VersionNumber.fromStringAsPattern(TAG_PATT, text, idxs);
    }

    public static boolean isValidPart(int part) {
        return part >= 0 && part <= 99;
    }

    public void add() {
        ++this.patch;
        if (this.patch <= 99) {
            return;
        }
        this.patch = 0;
        ++this.minor;
        if (this.minor <= 99) {
            return;
        }
        this.patch = 0;
        this.minor = 0;
        ++this.major;
        if (this.major > 99) {
            this.invalidate();
        }
    }

    public void check() {
        this.checkPart(this.major);
        this.checkPart(this.minor);
        this.checkPart(this.patch);
    }

    private void checkFrozen() {
        if (this.isFrozen) {
            throw new IllegalStateException("version data is frozen.");
        }
    }

    private void checkPart(int part) {
        if (part > 99 || part < 0) {
            String err = String.format("bad part version number: %s", part);
            throw new IllegalStateException(err);
        }
    }

    protected VersionNumber clone() {
        return new VersionNumber(this.major, this.minor, this.patch);
    }

    @Override
    public int compareTo(VersionNumber version) {
        if (version == null) {
            throw new IllegalArgumentException("null version for comparison");
        }
        if (this.major != version.major) {
            return this.major > version.major ? 1 : -1;
        }
        if (this.minor != version.minor) {
            return this.minor > version.minor ? 1 : -1;
        }
        if (this.patch != version.patch) {
            return this.patch > version.patch ? 1 : -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VersionNumber other = (VersionNumber)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return this.patch == other.patch;
    }

    public void freeze() {
        this.isFrozen = true;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        return result;
    }

    public void increment(int deltaMajor, int deltaMinor, int deltaPatch) {
        this.checkFrozen();
        this.setMajor(this.getMajor() + deltaMajor);
        this.setMinor(this.getMinor() + deltaMinor);
        this.setPatch(this.getPatch() + deltaPatch);
    }

    public void invalidate() {
        this.checkFrozen();
        this.major = -9999;
        this.minor = -9999;
        this.patch = -9999;
    }

    public boolean isValid() {
        int mj = this.getMajor();
        int mn = this.getMinor();
        int pt = this.getPatch();
        boolean okMajor = VersionNumber.isValidPart(mj);
        boolean okMinor = VersionNumber.isValidPart(mn);
        boolean okPatch = VersionNumber.isValidPart(pt);
        return okMajor && okMinor && okPatch;
    }

    public void setMajor(int major) {
        this.checkFrozen();
        this.checkPart(major);
        this.major = major;
    }

    public void setMinor(int minor) {
        this.checkFrozen();
        this.checkPart(minor);
        this.minor = minor;
    }

    public void setPatch(int patch) {
        this.checkFrozen();
        this.checkPart(patch);
        this.patch = patch;
    }

    public String toString() {
        return String.format(TXT_FORMATTER, this.major, this.minor, this.patch);
    }

    public final String toStringAsBranch() {
        String text = String.format(BRANCH_FORMATTER, this.major, this.minor);
        return text;
    }

    public String toStringAsTag() {
        return String.format(TAG_FORMATTER, this.major, this.minor, this.patch);
    }
}

