/**
 * $Id: XMLBasicElementFactory.java 123860 2011-11-04 23:11:41Z costa $
 */
package tecgraf.javautils.xml;

import java.util.Map;

/**
 * Implementao de referncia de uma fbrica XML.
 * 
 * @author Tecgraf
 */
public class XMLBasicElementFactory extends XMLElementFactory {

  /**
   * Mapa relacionando tags a objetos XML. Usado na leitura de documentos XML.
   */
  private final Map<String, Class<? extends XMLElementInterface>> tagToObjMap;
  /**
   * Mapa relacionando objetos da aplicao a tags. Usado na escrita de
   * documentos XML.
   */
  private final Map<Class<?>, String> objToTagMap;
  /**
   * Contexto da aplicao (acessvel aos objetos durante o processamento do
   * documento).
   */
  private Object contextObject;

  /**
   * Cria uma fbrica capaz de criar tanto objetos XML a partir de tags quanto
   * tags a partir de objetos da aplicao, podendo portanto ser usada tanto na
   * leitura quanto na escrita de documentos XML.
   * 
   * @param tagToObjMap mapa relacionando tags a objetos XML. Pode ser
   *        <code>null</code> se a fbrica vai ser usada para <b>gravar</b> um
   *        documento XML.
   * @param objToTagMap mapa relacionando objetos da aplicao a tags. Pode ser
   *        <code>null</code> se a fbrica vai ser usada para <b>ler</b> um
   *        documento XML.
   */
  public XMLBasicElementFactory(
    Map<String, Class<? extends XMLElementInterface>> tagToObjMap,
    Map<Class<?>, String> objToTagMap) {
    this.tagToObjMap = tagToObjMap;
    this.objToTagMap = objToTagMap;
  }

  /**
   * Cria uma fbrica para <b>leitura</b> de documentos XML que mapeia todas as
   * tags para um nico tipo de objeto XML.
   * 
   * @param uniqueClass classe associada a todas as tags
   */
  public XMLBasicElementFactory(Class<? extends XMLElementInterface> uniqueClass) {
    this(new AllTagsToOneObjectMap(uniqueClass), null);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public void setAppContextObject(Object contextObject) {
    this.contextObject = contextObject;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Object getAppContextObject() {
    return contextObject;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void fillConversionTables() {
    // vazio -- os mapas j so recebidos prontos
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, Class<? extends XMLElementInterface>> getTagToXMLMap() {
    return tagToObjMap;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<Class<?>, String> getAppObjectToTagMap() {
    return objToTagMap;
  }
}
