/* $Id: XMLElementFactoryInterface.java 75314 2008-04-24 18:44:54Z costa $ */

package tecgraf.javautils.xml;

/**
 * Fbrica de elementos XML. Permite a criao de elementos a partir de tags ou
 * de objetos da aplicao.
 * 
 * @author Andre Oliveira da Costa
 */
public interface XMLElementFactoryInterface {

  /**
   * Define o contexto da aplicao, para que este possa ser recuperado durante
   * o processamento do XML.
   * 
   * @param contextObject objeto que representa o "contexto da aplicao". O que
   *        exatamente ele representa e como ele  usado depende exclusivamente
   *        da aplicao.
   */
  public void setAppContextObject(final Object contextObject);

  /**
   * Retorna o objeto associado ao contexto da aplicao.
   * 
   * @return objeto associado ao contexto da aplicao. Pode ser
   *         <code>null</code>.
   */
  public Object getAppContextObject();

  /**
   * Cria um elemento XML a partir do nome da tag. Este mtodo  executado
   * primariamente a partir do handler (callback startElement).
   * 
   * @param tagName nome da tag
   * 
   * @return elemento XML
   */
  public XMLElementInterface createXMLElementFromTag(final String tagName);

  /**
   * Cria um elemento XML a partir de um objeto da aplicao. Este mtodo 
   * executado por instncias de XMLWriter.
   * 
   * @param appObject objeto da aplicao
   * 
   * @return elemento XML
   */
  public XMLElementInterface createXMLElementFromApp(final Object appObject);
}
