/*
 * $Id: XMLListIteratorInterface.java 58823 2006-11-28 16:23:02Z costa $
 */
package tecgraf.javautils.xml;

/**
 * A interface <code>XMLListIteratorInterface</code> define as operaes
 * necessrias a iteradores de listas de elementos XML da forma como estes so
 * retornados pelo parser.
 */
public interface XMLListIteratorInterface {

  /** Tag usada para iterar sobre qualquer elemento */
  public static final String ANY = "*";

  /**
   * Reinicializa o iterador, redefinindo a tag de busca.
   * 
   * @param tag nova tag de busca
   */
  public abstract void reset(final String tag);

  /**
   * Reinicializa o iterador, usando a tag ANY como tag de busca.
   */
  public abstract void reset();

  /**
   * Retorna o prximo elemento com tipo igual ao que vnhamos buscando ou null
   * caso no haja mais elementos deste tipo.
   * 
   * @return o proximo elemento.
   */
  public abstract XMLElementInterface next();

  /**
   * Obtm o prximo elemento da lista que possui a tag desejada, ou null caso
   * no haja mais elementos com esta tag.<br>
   * 
   * Se a tag solicitada  a mesma que vnhamos buscando, simplesmente
   * continuamos a iterao. Neste caso, se no encontramos mais nenhum elemento
   * retornamos null mas mantemos o iterador no prximo elemento diferente do
   * solicitado, para que este possa ser reaproveitado em buscas subsequentes.
   * Isto permite que o percorrimento seja retomado caso a busca por um
   * determinado elemento j tenha sido esgotada.<br>
   * 
   * Se porm a tag solicitada for diferente da que vnhamos buscando, o
   * iterador buscar um elemento do tipo solicitado <b>at encontr-lo ou at
   * ter percorrido toda a lista de elementos</b>. Caso a lista tenha sido
   * "esgotada", qualquer tentativa posterior de busca por um elemento resultar
   * em null.
   * 
   * @param tag nova tag de busca
   * @return prximo elemento do tipo solicitado ou null caso este no exista.
   *         Mesmoq que o valor retornado seja null, ainda assim a lista pode
   *         ainda ter elementos a serem percorridos (ver observao acima)
   */
  public abstract XMLElementInterface next(final String tag);

  /**
   * Indica se existe mais algum elemento na lista cuja tag seja igual 
   * solicitada.
   * 
   * @return <code>true</code> se o elemento seguinte na lista possui tag
   *         igual  tag de busca, <code>false</code> caso contrrio.
   */
  public abstract boolean hasNext();

  /**
   * Retorna a tag de referncia para o iterador (o valor que ser usado na
   * comparao com os elementos da lista).
   * 
   * @return tag de referncia para o iterador
   */
  public abstract String getTag();

}
