/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.util.ArrayList;
import java.util.List;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLListIteratorInterface;

public class ImprovedXMLListIterator
implements XMLListIteratorInterface {
    private List<XMLElementInterface> list;
    private int index = 0;
    private String searchTag = "*";
    private boolean matchAny = true;

    public ImprovedXMLListIterator(List<XMLElementInterface> list) {
        this.list = list != null ? list : new ArrayList();
    }

    public ImprovedXMLListIterator(List<XMLElementInterface> list, String tag) {
        this(list);
        this.newTag(tag);
    }

    @Override
    public void reset(String tag) {
        this.index = 0;
        this.newTag(tag);
    }

    private void newTag(String tag) {
        this.searchTag = tag;
        this.matchAny = tag.equals("*");
    }

    @Override
    public void reset() {
        this.index = 0;
        this.newTag("*");
    }

    @Override
    public XMLElementInterface next() {
        for (int i = this.index; i < this.list.size(); ++i) {
            XMLElementInterface element = this.list.get(i);
            if (!this.tagMatches(element)) continue;
            this.index = i + 1;
            return element;
        }
        return null;
    }

    @Override
    public XMLElementInterface next(String tag) {
        this.newTag(tag);
        return this.next();
    }

    @Override
    public boolean hasNext() {
        if (this.index == this.list.size()) {
            return false;
        }
        return this.tagMatches(this.list.get(this.index));
    }

    private boolean tagMatches(XMLElementInterface element) {
        return this.matchAny || this.searchTag.equals(element.getTag());
    }

    private boolean tagMatches(XMLElementInterface element, String tag) {
        return tag.equals("*") || tag.equals(element.getTag());
    }

    @Override
    public String getTag() {
        return this.searchTag;
    }

    public boolean hasAny(String tag) {
        for (int i = this.index; i < this.list.size(); ++i) {
            if (!this.tagMatches(this.list.get(i), tag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAny(XMLElementInterface element) {
        return this.hasAny(element.getTag());
    }

    public int howManyLeft(XMLElementInterface element) {
        String tag = element.getTag();
        return this.howManyLeft(tag);
    }

    public int howManyLeft(String tag) {
        int count = 0;
        for (int i = this.index; i < this.list.size(); ++i) {
            if (!this.tagMatches(this.list.get(i), tag)) continue;
            ++count;
        }
        return count;
    }

    public boolean isNext(String tag) {
        if (this.index >= this.list.size()) {
            return false;
        }
        return tag.equalsIgnoreCase(this.list.get(this.index).getTag());
    }

    public boolean hasEnded() {
        return this.index >= this.list.size();
    }
}

