/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;
import tecgraf.javautils.xml.InternalHandler;
import tecgraf.javautils.xml.XMLAttribute;
import tecgraf.javautils.xml.XMLBasicElementFactory;
import tecgraf.javautils.xml.XMLElementFactoryInterface;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLHandlerInterface;
import tecgraf.javautils.xml.exception.XMLException;
import tecgraf.javautils.xml.exception.XMLInternalErrorException;

public class XMLBasicHandler
implements XMLHandlerInterface {
    private Stack<StackElement> stack;
    private Stack<XMLElementInterface> openedElements;
    private XMLElementInterface root;
    private InputSource inputSource;
    private XMLElementFactoryInterface xmlFactory;
    private String dtd;
    private final InternalHandler internalHandler = new InternalHandler(this);
    private int tagLevel;

    @Override
    public final XMLElementInterface getRootElement() {
        return this.root;
    }

    @Override
    public final DefaultHandler getSAXInternalHandler() {
        return this.internalHandler;
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws XMLException {
        XMLElementInterface element = this.openedElements.peek();
        element.newCharsEvent(ch, start, length);
    }

    @Override
    public final void startElement(String uri, String localName, String qName, List<XMLAttribute> attributes) throws XMLException {
        XMLElementInterface element = null;
        element = this.xmlFactory.createXMLElementFromTag(qName);
        if (element == null) {
            throw new XMLException("n\u00e3o existe elemento associado \u00e0 tag " + qName);
        }
        this.stack.push(new StackElement(element, this.tagLevel));
        this.openedElements.push(element);
        ++this.tagLevel;
        if (attributes != null && attributes.size() > 0) {
            element.newAttributeList(attributes);
        }
        if (this.stack.size() == 1) {
            this.root = element;
        }
        element.startTag();
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws XMLException {
        this.openedElements.pop();
        --this.tagLevel;
        StackElement stackTop = this.stack.peek();
        if (stackTop == null) {
            throw new XMLInternalErrorException(qName, "pilha vazia ao desempilhar a tag");
        }
        ArrayList<XMLElementInterface> tempChildrenList = new ArrayList<XMLElementInterface>();
        while (!stackTop.equals(qName, this.tagLevel)) {
            this.stack.pop();
            tempChildrenList.add(0, stackTop.element);
            stackTop = this.stack.peek();
        }
        stackTop.element.convertValueFromXML();
        stackTop.element.endTag(tempChildrenList);
    }

    @Override
    public final void setInputSource(Reader reader) {
        this.inputSource = new InputSource(reader);
    }

    @Override
    public final InputSource getInputSource() {
        return this.inputSource;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws XMLException {
        this.setDTD(systemId);
        return null;
    }

    @Override
    public final void setDTD(String dtd) {
        this.dtd = dtd;
    }

    @Override
    public final String getDTD() {
        return this.dtd;
    }

    @Override
    public final XMLElementFactoryInterface getXMLFactory() {
        return this.xmlFactory;
    }

    @Override
    public final void endDocument() throws XMLException {
        this.endDocument(this.root);
    }

    @Override
    public void endDocument(XMLElementInterface rootElement) {
    }

    @Override
    public void warning(XMLException e) throws XMLException {
        throw e;
    }

    @Override
    public void fatalError(XMLException e) throws XMLException {
        throw e;
    }

    @Override
    public void error(XMLException e) throws XMLException {
        throw e;
    }

    public XMLBasicHandler(XMLElementFactoryInterface xmlFactory) {
        this.xmlFactory = xmlFactory;
        this.stack = new Stack();
        this.openedElements = new Stack();
        this.root = null;
        this.tagLevel = 0;
    }

    public XMLBasicHandler(Map<String, Class<? extends XMLElementInterface>> tagToObjMap) {
        this(new XMLBasicElementFactory(tagToObjMap, null));
    }

    public XMLBasicHandler(Class<? extends XMLElementInterface> cls) {
        this(new XMLBasicElementFactory(cls));
    }

    private static class StackElement {
        XMLElementInterface element;
        int level;

        StackElement(XMLElementInterface element, int level) {
            this.element = element;
            this.level = level;
        }

        boolean equals(String tagName, int level) {
            return this.element.getTag().equalsIgnoreCase(tagName) && this.level == level;
        }
    }
}

