/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.XMLHandlerInterface;
import tecgraf.javautils.xml.exception.XMLParseException;

public class XMLParser {
    private SAXParser parser;
    private XMLHandlerInterface handler;

    public XMLParser(XMLHandlerInterface handler, boolean validate) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(validate);
        try {
            this.parser = factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            System.err.println(e.getMessage());
        }
        catch (SAXException e) {
            System.err.println(e.getMessage());
        }
        this.handler = handler;
    }

    public final XMLElementInterface parse(Reader reader) throws IOException {
        this.handler.setInputSource(reader);
        try {
            this.parser.parse(this.handler.getInputSource(), this.handler.getSAXInternalHandler());
        }
        catch (SAXException e) {
            Exception ee = e.getException();
            if (ee instanceof XMLParseException) {
                XMLParseException xpe = (XMLParseException)ee;
                throw xpe;
            }
            throw new XMLParseException(e.getMessage(), e);
        }
        return this.handler.getRootElement();
    }

    public final String getDTD() {
        return this.handler.getDTD();
    }
}

