/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml.conversion;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.validation.Schema;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import tecgraf.javautils.xml.conversion.ConversionBaseHandler;
import tecgraf.javautils.xml.conversion.ConversionErrorHandler;

public class ConversionDocumentBuilder
extends DocumentBuilder {
    private DocumentBuilder documentBuilder;
    private List<String> errors = new ArrayList<String>();

    public ConversionDocumentBuilder(boolean validate, String dtdPrefix) throws ParserConfigurationException {
        this(validate, dtdPrefix, false);
    }

    public ConversionDocumentBuilder(boolean validate, String dtdPrefix, boolean fromCodebase) throws ParserConfigurationException {
        this(validate, new ConversionBaseHandler(dtdPrefix, fromCodebase));
    }

    public ConversionDocumentBuilder(boolean validate, EntityResolver resolver) throws ParserConfigurationException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setValidating(validate);
        this.documentBuilder = docBuilderFactory.newDocumentBuilder();
        this.documentBuilder.setEntityResolver(resolver);
        this.documentBuilder.setErrorHandler(new ConversionErrorHandler(this.errors));
    }

    public List<String> getErrorList() {
        return this.errors;
    }

    public boolean hasErrors() {
        return this.errors.size() > 0;
    }

    public boolean equals(Object obj) {
        return this.documentBuilder.equals(obj);
    }

    @Override
    public DOMImplementation getDOMImplementation() {
        return this.documentBuilder.getDOMImplementation();
    }

    @Override
    public Schema getSchema() {
        return this.documentBuilder.getSchema();
    }

    public int hashCode() {
        return this.documentBuilder.hashCode();
    }

    @Override
    public boolean isNamespaceAware() {
        return this.documentBuilder.isNamespaceAware();
    }

    @Override
    public boolean isValidating() {
        return this.documentBuilder.isValidating();
    }

    @Override
    public boolean isXIncludeAware() {
        return this.documentBuilder.isXIncludeAware();
    }

    @Override
    public Document newDocument() {
        return this.documentBuilder.newDocument();
    }

    @Override
    public Document parse(File f) throws SAXException, IOException {
        return this.documentBuilder.parse(f);
    }

    @Override
    public Document parse(InputSource is) throws SAXException, IOException {
        return this.documentBuilder.parse(is);
    }

    @Override
    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        return this.documentBuilder.parse(is, systemId);
    }

    @Override
    public Document parse(InputStream is) throws SAXException, IOException {
        return this.documentBuilder.parse(is);
    }

    @Override
    public Document parse(String uri) throws SAXException, IOException {
        return this.documentBuilder.parse(uri);
    }

    @Override
    public void reset() {
        this.documentBuilder.reset();
    }

    @Override
    public void setEntityResolver(EntityResolver er) {
        this.documentBuilder.setEntityResolver(er);
    }

    @Override
    public void setErrorHandler(ErrorHandler eh) {
        this.documentBuilder.setErrorHandler(eh);
    }

    public String toString() {
        return this.documentBuilder.toString();
    }
}

