package tecgraf.javautils.xml;

import java.util.HashMap;

/**
 * Mapa que retorna um nico tipo de objeto XML para qualquer tag.
 */
class AllTagsToOneObjectMap extends
  HashMap<String, Class<? extends XMLElementInterface>> {

  /**
   * Tipo do objeto XML retornado para qualquer tag.
   */
  private final Class<? extends XMLElementInterface> uniqueClass;

  /**
   * Construtor.
   * 
   * @param uniqueClass tipo do objeto XML retornado para qualquer tag
   */
  public AllTagsToOneObjectMap(Class<? extends XMLElementInterface> uniqueClass) {
    this.uniqueClass = uniqueClass;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public Class<? extends XMLElementInterface> get(Object key) {
    return uniqueClass;
  }
}