/* $Id: XMLDataElement.java 86877 2008-12-22 22:48:07Z costa $ */

package tecgraf.javautils.xml;

import java.io.IOException;
import java.io.Writer;

/**
 * A classe <code>XMLDataElement</code> representa um elemento XML que no
 * possui filhos.
 * 
 * @author Andr Oliveira da Costa
 */
public abstract class XMLDataElement extends XMLElement {

  /**
   * Escreve o elemento em um stream de sada (tag de abertura + atributos,
   * valor e tag de fechamento).
   * 
   * @param stream stream de sada
   * @param ident identao
   * @throws IOException se houver problemas na escrita
   */
  public void write(final Writer stream, final String ident) throws IOException {
    writeStartTag(stream, ident);
    writeValue(stream);
    writeEndTag(stream);
  }

  /**
   * Escreve o elemento em um stream de sada (tag de abertura, valor e tag de
   * fechamento). O elemento no deve possuir atributos.
   * 
   * @param stream stream de sada
   * @param ident identao
   * @param tagName tag do elemento
   * @param value valor do elemento
   * 
   * @throws IOException se houve algum problema na escrita
   */
  public static void write(final Writer stream, final String ident,
    final String tagName, final String value) throws IOException {
    stream.write(ident + "<" + tagName + ">");
    //    stream.write(HtmlEncoder.encode(value));
    // FIXME no podemos chamar o HtmlEncoder porque ele est fazendo mais do que devia
    stream.write(XMLElement.xmlEncode(value));
    stream.write("</" + tagName + ">\n");
  }

  /**
   * Escreve o elemento em um stream de sada (tag de abertura, valor (double) e
   * tag de fechamento). O elemento no deve possuir atributos, e seu valor ser
   * convertido de <code>double</code> para <code>String</code>.
   * 
   * @param stream stream de sada
   * @param ident identao
   * @param tag tag
   * @param value valor (double)
   * @throws IOException se houve algum problema na escrita
   */
  public static void write(final Writer stream, final String ident,
    final String tag, final double value) throws IOException {
    write(stream, ident, tag, String.valueOf(value));
  }

  /**
   * Escreve o elemento em um stream de sada (tag de abertura, valor (
   * <code>int</code>) e tag de fechamento). O elemento no deve possuir
   * atributos, e seu valor ser convertido de <code>int</code> para
   * <code>String</code>.
   * 
   * @param stream stream de sada
   * @param ident identao
   * @param tag tag
   * @param value valor (int)
   * @throws IOException se houve algum problema na escrita
   */
  public static void write(final Writer stream, final String ident,
    final String tag, final int value) throws IOException {
    write(stream, ident, tag, String.valueOf(value));
  }

  /**
   * Escreve uma tag de fechamento arbitrria, sem identao.
   * 
   * @param tagName tag
   * @param stream stream de sada
   * 
   * @throws IOException se houve algum erro de I/O durante a escrita
   */
  public static void writeEndTag(final String tagName, final Writer stream)
    throws IOException {
    stream.write("</" + tagName + ">\n");
  }
}
