/* $Id: XMLException.java 2022 2006-02-10 16:50:07Z costa $ */

package tecgraf.javautils.xml.exception;

/**
 * A classe <code>XMLException</code> modela excees causadas no processamento
 * de arquivos XML. Ela  usada como base para tipos especficos de erros, e
 * tipicamente no  instanciada.
 *
 * @author Andre Oliveira da Costa
 */
public class XMLException extends RuntimeException {

  /** Tag da excecao */
  protected String tag;

  /**
   * Constri uma exceo recebendo a tag que causou o erro.
   *
   * @param tag que gerou o erro
   */
  public XMLException(final String tag) {
    super();
    this.tag = tag;
  }

  /**
   * Constri uma exceo recebendo a tag que causou o erro e a exceo
   * original que causou o erro.
   *
   * @param tag tag que causou o erro
   * @param e exceo original que causou o erro
   */
  public XMLException(final String tag, final Exception e) {
    super(e);
    this.tag = tag;
  }

  /**
   * Constri uma exceo recebendo a tag que causou o erro e uma mensagem
   * adicional.
   * @param tag Tag que causou o erro
   * @param message Mensagem com dados adicionais sobre o problema
   */
  public XMLException(final String tag, final String message) {
    super(message);
    this.tag = tag;
  }

  /**
   * Constri uma exceo recebendo a tag que causou o erro, a exceo original
   * e uma mensagem com dados adicionais sobre o erro.
   * @param tag Tag que causou o erro
   * @param e Exceo original
   * @param message Mensagem com dados adicionais sobre o problema
   */
  public XMLException(final String tag, final Exception e, 
  final String message) {
    super(message, e);
    this.tag = tag;
  }

  /**
   * Constri uma <code>XMLException</code> apenas para encapsular outra.
   * @param e Exceo original
   */
  public XMLException(final Exception e) {
    super(e);
  }

  /**
   * Retorno da tag associada.
   * @return a tag
   */
  final public String getTag() {
    return tag;
  }

  /**
   * Formata a mensagem associada  exceo, indicando a tag que gerou o 
   * problema e (eventualmente) a mensagem associada.
   * @return mensagem associada  exceo.
   */
  public String toString() {
    StringBuilder msg = new StringBuilder();
    if (tag != null) {
      msg.append("Tag: ");
      msg.append(tag);
    }
    String originalMsg = getMessage();
    if (originalMsg != null) {
      msg.append(", Erro: ");
      msg.append(originalMsg);
    }
    return msg.toString();
  }
}
