/* $Id: XMLInternalErrorException.java 1915 2005-08-23 20:47:34Z clinio $ */

package tecgraf.javautils.xml.exception;

/**
 * A classe <code>XMLInternalErrorException</code> implementa excees
 * ocorridas devido a erros internos (p.ex. mapeamento de tags para classes).
 * 
 * @author Andre Oliveira da Costa
 */
public class XMLInternalErrorException extends XMLException {

  /**
   * Construtor.
   * @param tag tag
   * @param message mensagem de erro.
   */
  public XMLInternalErrorException(final String tag, final String message) {
    super(tag, message);
  }

  /**
   * Construtor.
   * @param e exceo detectada.
   */
  public XMLInternalErrorException(final Exception e) {
    super(e);
  }

  /**
   * Construtor.
   * @param tag tag
   * @param e exceo detectada
   */
  public XMLInternalErrorException(final String tag, final Exception e) {
    super(tag, e);
  }

  /**
   * Construtor
   * @param tag tag
   * @param e exceo detectada
   * @param message mensagem de erro.
   */
  public XMLInternalErrorException(final String tag, final Exception e, 
  final String message) {
    super(tag, e, message);
  }

}
