/* $Id: XMLWriteException.java 1915 2005-08-23 20:47:34Z clinio $ */

package tecgraf.javautils.xml.exception;


/**
 * A classe <code>XMLWriteException</code> representa erros acontecidos durante 
 * a escrita de um arquivo XML. 
 * 
 * @author Andre Oliveira da Costa
 */
public class XMLWriteException extends XMLException {

  /**
   * Constri uma <code>XMLWriteException</code> recebendo apenas a tag que 
   * causou o erro.
   * 
   * @param tag tag que causou a exceo
   */
  public XMLWriteException(final String tag) {
    super(tag);
  }

  /**
   * Constri uma <code>XMLWriteException</code> recebendo a tag que causou o 
   * erro e a exceo original.
   * 
   * @param tag tag que causou o erro
   * @param exception exceo original
   */
  public XMLWriteException(final String tag, final Exception exception) {
    super(tag, exception);
  }

}
