/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.xml;

import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tecgraf.javautils.xml.XMLAttribute;
import tecgraf.javautils.xml.XMLElementInterface;
import tecgraf.javautils.xml.exception.XMLParseException;

public abstract class XMLElement
implements XMLElementInterface {
    private List<XMLAttribute> attributes;
    private StringBuffer valueBuffer;
    private String value;
    private BufferState bufferState;
    private String tag;
    private Object contextObject;
    private Object appObject;
    private Map<String, String> xmlConversionTable = new HashMap<String, String>();
    private String xmlToTextRegexp;

    @Override
    public void newCharsEvent(char[] charArray, int start, int length) {
        if (this.valueBuffer == null) {
            this.initBuffer(BufferState.OPENED_BY_PARSER);
        }
        this.valueBuffer.append(charArray, start, length);
    }

    private void initBuffer(BufferState state) {
        this.bufferState = state;
        this.valueBuffer = this.value != null ? new StringBuffer(this.value) : new StringBuffer();
    }

    private static int appendStringToValue(StringBuffer value, char[] charArray, String string, int refPos, int currPos) {
        int length = currPos - refPos;
        if (length > 0) {
            value.append(charArray, refPos, length);
        }
        value.append(string);
        return refPos + length + 1;
    }

    @Override
    public final void convertValueFromXML() {
        if (this.valueBuffer == null) {
            this.consolidateValue();
            return;
        }
        Pattern pattern = Pattern.compile(this.xmlToTextRegexp);
        Matcher matcher = pattern.matcher(this.valueBuffer);
        StringBuffer newValue = new StringBuffer(this.valueBuffer.length());
        while (matcher.find()) {
            String capture = matcher.group();
            String replacement = this.xmlConversionTable.get(capture);
            if (replacement == null) {
                System.err.println("sequencia nao tratada: &" + capture + ';');
                newValue.append('&').append(capture).append(';');
                continue;
            }
            matcher.appendReplacement(newValue, replacement);
        }
        matcher.appendTail(newValue);
        this.valueBuffer = newValue;
        this.consolidateValue();
    }

    private void consolidateValue() {
        this.value = this.valueBuffer == null ? null : this.valueBuffer.toString();
        this.valueBuffer = null;
        this.bufferState = BufferState.CLOSED;
    }

    @Override
    @Deprecated
    public String convertTextToXML(String text) {
        return XMLElement.xmlEncode(text);
    }

    @Deprecated
    public static String xmlEncode(String text) {
        char[] charArray = text.toCharArray();
        StringBuffer converted = new StringBuffer(text.length());
        int start = 0;
        block5: for (int i = 0; i < charArray.length; ++i) {
            char c = charArray[i];
            switch (c) {
                case '<': {
                    start = XMLElement.appendStringToValue(converted, charArray, "&lt;", start, i);
                    continue block5;
                }
                case '>': {
                    start = XMLElement.appendStringToValue(converted, charArray, "&gt;", start, i);
                    continue block5;
                }
                case '&': {
                    start = XMLElement.appendStringToValue(converted, charArray, "&amp;", start, i);
                }
            }
        }
        if (charArray.length > start) {
            converted.append(charArray, start, charArray.length - start);
        }
        return converted.toString();
    }

    @Override
    public final XMLElementInterface appendValue(String text, boolean newLine) {
        if (this.valueBuffer == null) {
            this.initBuffer(BufferState.OPENED_BY_USER);
        }
        if (text != null) {
            this.valueBuffer.append(text);
            if (newLine) {
                this.valueBuffer.append('\n');
            }
        }
        return this;
    }

    @Override
    public final XMLElementInterface resetValue() {
        this.valueBuffer = null;
        this.value = null;
        this.bufferState = BufferState.CLOSED;
        return this;
    }

    @Override
    public final XMLElementInterface setValue(String value) {
        if (value == null) {
            this.resetValue();
            return this;
        }
        this.value = value;
        this.bufferState = BufferState.CLOSED;
        return this;
    }

    @Override
    public final XMLElementInterface setValue(double value) {
        return this.setValue(String.valueOf(value));
    }

    @Override
    public final XMLElementInterface setTag(String tag) {
        this.tag = tag;
        return this;
    }

    @Override
    public final String getTag() {
        return this.tag;
    }

    public String getStrValue(boolean escapeChars) {
        if (escapeChars) {
            return XMLElement.xmlEncode(this.getStrValue());
        }
        return this.getStrValue();
    }

    @Override
    public String getStrValue() {
        this.checkBufferState();
        return this.value == null ? "" : this.value;
    }

    private void checkBufferState() {
        switch (this.bufferState) {
            case OPENED_BY_PARSER: {
                throw new IllegalStateException("elemento ainda est\u00e1 sendo processado");
            }
            case OPENED_BY_USER: {
                this.consolidateValue();
                break;
            }
        }
    }

    @Override
    public final float getFloatValue() {
        try {
            return Float.valueOf(this.getStrValue().trim()).floatValue();
        }
        catch (NumberFormatException e) {
            throw new XMLParseException(this.tag);
        }
    }

    @Override
    public final double getDoubleValue() {
        try {
            return Double.valueOf(this.getStrValue().trim());
        }
        catch (NumberFormatException e) {
            throw new XMLParseException(this.tag);
        }
    }

    @Override
    public final int getIntValue() {
        try {
            return Integer.valueOf(this.getStrValue().trim());
        }
        catch (NumberFormatException e) {
            throw new XMLParseException(this.tag);
        }
    }

    @Override
    public final long getLongValue() {
        try {
            return Long.valueOf(this.getStrValue().trim());
        }
        catch (NumberFormatException e) {
            throw new XMLParseException(this.tag);
        }
    }

    @Override
    public final XMLElementInterface newAttribute(String name, String strValue) {
        this.attributes.add(new XMLAttribute(name, strValue));
        return this;
    }

    @Override
    public XMLElementInterface newAttribute(String name, Enum<?> enumValue) {
        return this.newAttribute(name, enumValue.toString());
    }

    @Override
    public final XMLElementInterface newAttribute(String name, int intValue) {
        return this.newAttribute(name, String.valueOf(intValue));
    }

    @Override
    public final XMLElementInterface newAttribute(String name, long longValue) {
        return this.newAttribute(name, String.valueOf(longValue));
    }

    @Override
    public XMLElementInterface newAttribute(String name, boolean boolValue) {
        return this.newAttribute(name, boolValue ? "TRUE" : "FALSE");
    }

    @Override
    public final XMLElementInterface newAttribute(String name, double doubleValue) {
        return this.newAttribute(name, String.valueOf(doubleValue));
    }

    @Override
    public final XMLElementInterface newAttributeList(List<XMLAttribute> newAttrs) {
        this.attributes.clear();
        this.attributes.addAll(newAttrs);
        return this;
    }

    @Override
    public final void resetAttributeList() {
        this.attributes.clear();
    }

    @Override
    public final boolean hasAttribute(String name) {
        return this.getAttributeStrValue(name) != null;
    }

    @Override
    public final boolean hasValue() {
        this.checkBufferState();
        return this.value != null;
    }

    @Override
    public final boolean isEmpty() {
        return this.getStrValue().trim().isEmpty();
    }

    @Override
    public String getAttributeStrValue(String name) {
        for (XMLAttribute attr : this.attributes) {
            if (!name.equals(attr.getName())) continue;
            return attr.getValue();
        }
        return null;
    }

    @Override
    public boolean getAttributeBooleanValue(String name) {
        return Boolean.valueOf(this.getAttributeStrValue(name));
    }

    @Override
    public final int getAttributeIntValue(String name) {
        try {
            return Integer.valueOf(this.getAttributeStrValue(name));
        }
        catch (NumberFormatException e) {
            throw new XMLParseException(this.tag, name);
        }
    }

    @Override
    public double getAttributeDoubleValue(String name) {
        try {
            return Double.valueOf(this.getAttributeStrValue(name));
        }
        catch (NumberFormatException e) {
            throw new XMLParseException(this.tag, name);
        }
    }

    @Override
    public List<? extends XMLAttribute> getAttributes() {
        return Collections.unmodifiableList(this.attributes);
    }

    @Override
    public void writeStartTag(Writer stream, String ident) throws IOException {
        stream.write(ident + "<" + this.getTag());
        this.writeAttributes(stream);
        stream.write(">");
    }

    @Override
    public void writeStartTagln(Writer stream, String ident) throws IOException {
        this.writeStartTag(stream, ident);
        stream.write(10);
    }

    @Override
    public void writeAttributes(Writer stream) throws IOException {
        XMLElement.writeAttributes(stream, this.getAttributes());
    }

    public static void writeAttributes(Writer writer, List<? extends XMLAttribute> attributes) throws IOException {
        if (attributes != null && !attributes.isEmpty()) {
            for (XMLAttribute xMLAttribute : attributes) {
                if (xMLAttribute.getValue() == null) continue;
                writer.write(" " + xMLAttribute.getName() + "=\"" + xMLAttribute.getValue() + "\"");
            }
        }
    }

    @Override
    public void writeValue(Writer stream) throws IOException {
        stream.write(this.convertTextToXML(this.getStrValue()));
    }

    @Override
    public void writeEndTag(Writer stream, String ident) throws IOException {
        stream.write(ident + "</" + this.getTag() + ">\n");
    }

    @Override
    public final void writeEndTag(Writer stream) throws IOException {
        this.writeEndTag(stream, "");
    }

    @Override
    public void startTag() {
    }

    @Override
    public final XMLElementInterface setAppObject(Object appObject) {
        this.appObject = appObject;
        return this;
    }

    @Override
    public final Object getAppObject() {
        return this.appObject;
    }

    @Override
    public final XMLElementInterface setAppContextObject(Object contextObject) {
        this.contextObject = contextObject;
        return this;
    }

    @Override
    public final Object getAppContextObject() {
        return this.contextObject;
    }

    protected XMLElement() {
        this.xmlConversionTable.put("lt", "<");
        this.xmlConversionTable.put("gt", ">");
        this.xmlConversionTable.put("amp", "&");
        this.xmlToTextRegexp = "&(lt|gt|amp)&";
        this.attributes = new LinkedList<XMLAttribute>();
        this.bufferState = BufferState.CLOSED;
    }

    protected XMLElement(String tagName) {
        this();
        this.setTag(tagName);
    }

    private static enum BufferState {
        CLOSED,
        OPENED_BY_PARSER,
        OPENED_BY_USER;

    }
}

