/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.logins;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.logins.LoginWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class LoginRefreshAction
extends OpenBusAction<LoginWrapper> {
    public LoginRefreshAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get(LoginRefreshAction.class.getSimpleName() + ".name"));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REFRESH;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        BusExplorerTask<List<LoginWrapper>> task = new BusExplorerTask<List<LoginWrapper>>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            @Override
            protected void performTask() throws Exception {
                this.setResult(LoginWrapper.convertToInfo(LoginRefreshAction.this.admin.getLogins()));
            }

            @Override
            protected void afterTaskUI() {
                if (this.getStatus()) {
                    LoginRefreshAction.this.getTablePanelComponent().setElements((List)this.getResult());
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

