/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.Arrays;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.ORBSingleton;
import org.jacorb.orb.TypeCode;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.BAD_TYPECODE;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.ByteHolder;
import org.omg.CORBA.CharHolder;
import org.omg.CORBA.DoubleHolder;
import org.omg.CORBA.FixedHolder;
import org.omg.CORBA.FloatHolder;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.LongHolder;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.ShortHolder;
import org.omg.CORBA.StringHolder;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodeHolder;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.Streamable;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public final class Any
extends org.omg.CORBA.Any {
    private org.omg.CORBA.TypeCode typeCode;
    private java.lang.Object value;
    private final ORBSingleton orb;

    Any(ORBSingleton orb) {
        this.orb = orb;
        this.typeCode = orb.get_primitive_tc(TCKind.tk_null);
    }

    public TCKind kind() {
        return this.typeCode.kind();
    }

    @Override
    public org.omg.CORBA.TypeCode type() {
        return this.typeCode;
    }

    public org.omg.CORBA.TypeCode originalType() {
        return TypeCode.originalType(this.typeCode);
    }

    @Override
    public void type(org.omg.CORBA.TypeCode type) {
        this.typeCode = type;
        this.value = null;
    }

    public java.lang.Object value() {
        return this.value;
    }

    public int _get_TCKind() {
        return 11;
    }

    private void tc_error(String cause) {
        throw new BAD_OPERATION(cause);
    }

    private void checkNull() {
        if (this.value == null) {
            throw new BAD_OPERATION("No value has previously been inserted");
        }
    }

    private void checkExtract(int value, String cause) {
        if (this.originalType().kind().value() != value) {
            throw new BAD_OPERATION(cause);
        }
    }

    @Override
    public boolean equal(org.omg.CORBA.Any other) {
        if (other == null) {
            throw new BAD_PARAM("Null passed to Any equal operation");
        }
        if (!this.typeCode.equivalent(other.type())) {
            return false;
        }
        int kind = this.kind().value();
        switch (kind) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return this.extract_short() == other.extract_short();
            }
            case 3: {
                return this.extract_long() == other.extract_long();
            }
            case 4: {
                return this.extract_ushort() == other.extract_ushort();
            }
            case 5: {
                return this.extract_ulong() == other.extract_ulong();
            }
            case 6: {
                return this.extract_float() == other.extract_float();
            }
            case 7: {
                return this.extract_double() == other.extract_double();
            }
            case 8: {
                return this.extract_boolean() == other.extract_boolean();
            }
            case 9: {
                return this.extract_char() == other.extract_char();
            }
            case 10: {
                return this.extract_octet() == other.extract_octet();
            }
            case 11: {
                return this.extract_any().equal(other.extract_any());
            }
            case 12: {
                return this.extract_TypeCode().equal(other.extract_TypeCode());
            }
            case 13: {
                throw new NO_IMPLEMENT("Principal deprecated");
            }
            case 14: {
                Object myValue = this.extract_Object();
                Object otherValue = other.extract_Object();
                if (myValue == null && otherValue == null) {
                    return true;
                }
                if (myValue != null) {
                    return myValue.equals(otherValue);
                }
                return otherValue.equals(myValue);
            }
            case 15: 
            case 16: 
            case 17: {
                return this.compareComplexValue(other);
            }
            case 18: {
                return this.extract_string().equals(other.extract_string());
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                return this.compareComplexValue(other);
            }
            case 23: {
                return this.extract_longlong() == other.extract_longlong();
            }
            case 24: {
                return this.extract_ulonglong() == other.extract_ulonglong();
            }
            case 25: {
                throw new BAD_TYPECODE("type longdouble not supported in java");
            }
            case 26: {
                return this.extract_wchar() == other.extract_wchar();
            }
            case 27: {
                return this.extract_wstring().equals(other.extract_wstring());
            }
            case 28: {
                return this.extract_fixed().equals(other.extract_fixed());
            }
            case 29: 
            case 30: {
                return this.compareComplexValue(other);
            }
        }
        throw new BAD_TYPECODE("Cannot compare anys with TypeCode kind " + kind);
    }

    public boolean equals(java.lang.Object obj) {
        if (obj instanceof org.omg.CORBA.Any) {
            return this.equal((org.omg.CORBA.Any)obj);
        }
        return false;
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return "null";
    }

    @Override
    public void insert_short(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_short);
    }

    @Override
    public short extract_short() throws BAD_OPERATION {
        this.checkExtract(2, "Cannot extract short");
        this.checkNull();
        if (this.value instanceof Short) {
            return (Short)this.value;
        }
        if (this.value instanceof ShortHolder) {
            return ((ShortHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_short();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_ushort(short s) {
        this.value = new Short(s);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ushort);
    }

    @Override
    public short extract_ushort() {
        this.checkExtract(4, "Cannot extract ushort");
        this.checkNull();
        if (this.value instanceof Short) {
            return (Short)this.value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ushort();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_long(int i) {
        this.value = i;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_long);
    }

    @Override
    public int extract_long() {
        this.checkExtract(3, "Cannot extract long");
        this.checkNull();
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.value instanceof IntHolder) {
            return ((IntHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_long();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_ulong(int i) {
        this.value = i;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulong);
    }

    @Override
    public int extract_ulong() {
        this.checkExtract(5, "Cannot extract ulong");
        this.checkNull();
        if (this.value instanceof Integer) {
            return (Integer)this.value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ulong();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_longlong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_longlong);
    }

    @Override
    public long extract_longlong() {
        this.checkExtract(23, "Cannot extract longlong");
        this.checkNull();
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.value instanceof LongHolder) {
            return ((LongHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_longlong();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_ulonglong(long l) {
        this.value = new Long(l);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_ulonglong);
    }

    @Override
    public long extract_ulonglong() {
        this.checkExtract(24, "Cannot extract ulonglong");
        this.checkNull();
        if (this.value instanceof Long) {
            return (Long)this.value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_ulonglong();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_float(float f) {
        this.value = new Float(f);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_float);
    }

    @Override
    public float extract_float() {
        this.checkExtract(6, "Cannot extract float");
        this.checkNull();
        if (this.value instanceof Float) {
            return ((Float)this.value).floatValue();
        }
        if (this.value instanceof FloatHolder) {
            return ((FloatHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_float();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_double(double d) {
        this.value = new Double(d);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_double);
    }

    @Override
    public double extract_double() {
        this.checkExtract(7, "Cannot extract double");
        this.checkNull();
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        if (this.value instanceof DoubleHolder) {
            return ((DoubleHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_double();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_boolean(boolean bool) {
        this.value = bool;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_boolean);
    }

    @Override
    public boolean extract_boolean() {
        this.checkExtract(8, "Cannot extract boolean");
        this.checkNull();
        if (this.value instanceof Boolean) {
            return (Boolean)this.value;
        }
        if (this.value instanceof BooleanHolder) {
            return ((BooleanHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_boolean();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_char(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_char);
    }

    @Override
    public char extract_char() {
        this.checkExtract(9, "Cannot extract char");
        this.checkNull();
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        if (this.value instanceof CharHolder) {
            return ((CharHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_char();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_wchar(char c) {
        this.value = new Character(c);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_wchar);
    }

    @Override
    public char extract_wchar() {
        this.checkExtract(26, "Cannot extract wchar");
        this.checkNull();
        if (this.value instanceof Character) {
            return ((Character)this.value).charValue();
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_wchar();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_octet(byte b) {
        this.value = new Byte(b);
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_octet);
    }

    @Override
    public byte extract_octet() {
        this.checkExtract(10, "Cannot extract octet");
        this.checkNull();
        if (this.value instanceof Byte) {
            return (Byte)this.value;
        }
        if (this.value instanceof ByteHolder) {
            return ((ByteHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_octet();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_any(org.omg.CORBA.Any a) {
        this.value = a;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_any);
    }

    @Override
    public org.omg.CORBA.Any extract_any() {
        this.checkExtract(11, "Cannot extract any");
        this.checkNull();
        if (this.value instanceof Any) {
            return (Any)this.value;
        }
        if (this.value instanceof AnyHolder) {
            return ((AnyHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_any();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_TypeCode(org.omg.CORBA.TypeCode tc) {
        this.value = tc;
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_TypeCode);
    }

    @Override
    public org.omg.CORBA.TypeCode extract_TypeCode() {
        this.checkExtract(12, "Cannot extract TypeCode");
        this.checkNull();
        if (this.value instanceof TypeCode) {
            return (TypeCode)this.value;
        }
        if (this.value instanceof TypeCodeHolder) {
            return ((TypeCodeHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_TypeCode();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_string(String s) {
        this.value = s;
        this.typeCode = this.orb.create_string_tc(0);
    }

    @Override
    public String extract_string() {
        this.checkExtract(18, "Cannot extract string");
        this.checkNull();
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof StringHolder) {
            return ((StringHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_string();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_wstring(String s) {
        this.value = s;
        this.typeCode = this.orb.create_wstring_tc(0);
    }

    @Override
    public String extract_wstring() {
        this.checkExtract(27, "Cannot extract wstring");
        this.checkNull();
        if (this.value instanceof String) {
            return (String)this.value;
        }
        if (this.value instanceof StringHolder) {
            return ((StringHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_wstring();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_fixed(BigDecimal fixed, org.omg.CORBA.TypeCode type) {
        try {
            String val = fixed.toString();
            int extra = fixed.scale() - type.fixed_scale();
            if (extra > 0) {
                val = val.substring(0, val.length() - extra);
            } else if (extra < 0) {
                StringBuffer sb = new StringBuffer(val);
                if (val.indexOf(46) == -1) {
                    sb.append('.');
                }
                for (int i = extra; i < 0; ++i) {
                    sb.append('0');
                }
                val = sb.toString();
            }
            BigDecimal tmp = new BigDecimal(val);
            org.omg.CORBA.TypeCode tc = new FixedHolder(tmp)._type();
            if (tc.fixed_digits() > type.fixed_digits()) {
                throw new BAD_TYPECODE();
            }
            this.value = tmp;
            this.typeCode = type;
        }
        catch (BadKind bk) {
            throw new BAD_TYPECODE();
        }
    }

    @Override
    public BigDecimal extract_fixed() {
        this.checkExtract(28, "Cannot extract fixed");
        this.checkNull();
        if (this.value instanceof BigDecimal) {
            return (BigDecimal)this.value;
        }
        if (this.value instanceof FixedHolder) {
            return ((FixedHolder)this.value).value;
        }
        if (this.value instanceof CDROutputStream) {
            CDRInputStream inputStream = (CDRInputStream)this.create_input_stream();
            try {
                BigDecimal bigDecimal = inputStream.read_fixed(this.typeCode.fixed_digits(), this.typeCode.fixed_scale());
                return bigDecimal;
            }
            catch (BadKind e) {
                throw new INTERNAL("should not happen");
            }
            finally {
                inputStream.close();
            }
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_Object(Object obj) {
        String typeId = null;
        String name = "";
        if (obj == null) {
            typeId = "IDL:omg.org/CORBA/Object:1.0";
            name = "Object";
        } else {
            typeId = ((ObjectImpl)obj)._ids()[0];
            if (typeId.startsWith("IDL:")) {
                name = typeId.substring(4, typeId.lastIndexOf(58));
                name = name.substring(name.lastIndexOf(47) + 1);
            } else if (typeId.startsWith("RMI:")) {
                name = typeId.substring(4, typeId.lastIndexOf(58));
                name = name.substring(name.lastIndexOf(46) + 1);
            } else {
                throw new BAD_PARAM("Unknown repository id format");
            }
        }
        this.typeCode = this.orb.create_interface_tc(typeId, name);
        this.value = obj;
    }

    @Override
    public void insert_Object(Object obj, org.omg.CORBA.TypeCode type) {
        if (type.kind().value() != 14) {
            this.tc_error("Illegal, non-object TypeCode!");
        }
        this.value = obj;
        this.typeCode = type;
    }

    @Override
    public Object extract_Object() {
        this.checkExtract(14, "Cannot extract object");
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Object) {
            return (Object)this.value;
        }
        if (this.value instanceof Streamable) {
            Class<?> valueClass = this.value.getClass();
            try {
                Field field = valueClass.getDeclaredField("value");
                return (Object)field.get(this.value);
            }
            catch (Exception e) {
                throw new INTERNAL("Failed to retrieve value from Holder via reflection: " + e);
            }
        }
        if (this.value instanceof CDROutputStream) {
            return this.create_input_stream().read_Object();
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    public java.lang.Object extract_objref() {
        this.checkExtract(14, "Cannot extract object");
        return this.value;
    }

    @Override
    public void insert_Principal(Principal p) {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    @Override
    public Principal extract_Principal() {
        throw new NO_IMPLEMENT("Principal deprecated");
    }

    @Override
    public void insert_Streamable(Streamable s) {
        int kind = s._type().kind().value();
        if (kind == 29 || kind == 30 || kind == 32 || kind == 0) {
            throw new NO_IMPLEMENT("No support for valuetypes through streamable interface");
        }
        this.value = s;
        this.typeCode = s._type();
    }

    @Override
    public Streamable extract_Streamable() throws BAD_INV_ORDER {
        if (this.value instanceof Streamable) {
            return (Streamable)this.value;
        }
        if (this.value == null) {
            throw new BAD_OPERATION("No value has previously been inserted");
        }
        throw new BAD_INV_ORDER("Any value is not a Streamable, but a " + this.value.getClass());
    }

    @Override
    public Serializable extract_Value() throws BAD_OPERATION {
        int kind = this.typeCode.kind().value();
        if (kind != 29 && kind != 30 && kind != 32 && kind != 0) {
            this.tc_error("Cannot extract value!");
        }
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof Serializable) {
            return (Serializable)this.value;
        }
        if (this.value instanceof Streamable) {
            Class<?> valueClass = this.value.getClass();
            try {
                Field field = valueClass.getDeclaredField("value");
                return (Serializable)field.get(this.value);
            }
            catch (Exception e) {
                throw new INTERNAL("Failed to retrieve value from Holder via reflection: " + e);
            }
        }
        throw new INTERNAL("Encountered unexpected type of value: " + this.value.getClass());
    }

    @Override
    public void insert_Value(Serializable value) {
        if (value != null) {
            this.value = value;
            this.typeCode = TypeCode.create_tc(value.getClass());
        } else {
            this.value = null;
            this.typeCode = TypeCode.get_primitive_tc(0);
        }
    }

    @Override
    public void insert_Value(Serializable value, org.omg.CORBA.TypeCode type) throws MARSHAL {
        this.value = value;
        this.typeCode = type;
    }

    @Override
    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        this.value = new CDROutputStream(this.orb);
        return (CDROutputStream)this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.omg.CORBA.portable.InputStream create_input_stream() {
        if (this.value instanceof CDROutputStream) {
            return new CDRInputStream(this.orb, ((CDROutputStream)this.value).getBufferCopy());
        }
        CDROutputStream out = new CDROutputStream(this.orb);
        try {
            this.write_value(out);
            CDRInputStream cDRInputStream = new CDRInputStream(this.orb, out.getBufferCopy());
            return cDRInputStream;
        }
        finally {
            out.close();
        }
    }

    @Override
    public void read_value(org.omg.CORBA.portable.InputStream input, org.omg.CORBA.TypeCode type) throws MARSHAL {
        if (type == null) {
            throw new BAD_PARAM("TypeCode is null");
        }
        this.typeCode = type;
        int kind = type.kind().value();
        if (this.value instanceof Streamable && kind != 29 && kind != 30 && kind != 32) {
            ((Streamable)this.value)._read(input);
        } else {
            switch (kind) {
                case 0: 
                case 1: {
                    this.value = null;
                    break;
                }
                case 2: {
                    this.insert_short(input.read_short());
                    break;
                }
                case 3: {
                    this.insert_long(input.read_long());
                    break;
                }
                case 4: {
                    this.insert_ushort(input.read_ushort());
                    break;
                }
                case 5: {
                    this.insert_ulong(input.read_ulong());
                    break;
                }
                case 6: {
                    this.insert_float(input.read_float());
                    break;
                }
                case 7: {
                    this.insert_double(input.read_double());
                    break;
                }
                case 8: {
                    this.insert_boolean(input.read_boolean());
                    break;
                }
                case 9: {
                    this.insert_char(input.read_char());
                    break;
                }
                case 10: {
                    this.insert_octet(input.read_octet());
                    break;
                }
                case 11: {
                    this.insert_any(input.read_any());
                    break;
                }
                case 12: {
                    this.insert_TypeCode(input.read_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    this.insert_Object(input.read_Object(), type);
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    CDROutputStream out = new CDROutputStream(this.orb);
                    out.write_value(type, input);
                    this.value = out;
                    break;
                }
                case 18: {
                    this.insert_string(input.read_string());
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    CDROutputStream out = new CDROutputStream(this.orb);
                    out.write_value(type, input);
                    this.value = out;
                    break;
                }
                case 23: {
                    this.insert_longlong(input.read_longlong());
                    break;
                }
                case 24: {
                    this.insert_ulonglong(input.read_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    this.insert_wchar(input.read_wchar());
                    break;
                }
                case 27: {
                    this.insert_wstring(input.read_wstring());
                    break;
                }
                case 28: {
                    try {
                        BigDecimal fixed = ((CDRInputStream)input).read_fixed(type.fixed_digits(), type.fixed_scale());
                        this.insert_fixed(fixed, type);
                        break;
                    }
                    catch (BadKind bk) {
                        throw new INTERNAL("should never happen");
                    }
                }
                case 29: 
                case 30: {
                    this.insert_Value(((InputStream)input).read_value(), type);
                    break;
                }
                case 31: {
                    throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + kind);
                }
                case 32: {
                    java.lang.Object obj = ((InputStream)input).read_abstract_interface();
                    if (obj instanceof Object) {
                        this.insert(type, obj);
                        break;
                    }
                    this.insert_Value((Serializable)obj, type);
                    break;
                }
                default: {
                    throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
    }

    @Override
    public void write_value(org.omg.CORBA.portable.OutputStream output) {
        int kind = this.typeCode.kind().value();
        if (this.value instanceof Streamable && kind != 29 && kind != 30 && kind != 32) {
            ((Streamable)this.value)._write(output);
        } else {
            switch (kind) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    output.write_short(this.extract_short());
                    break;
                }
                case 3: {
                    output.write_long(this.extract_long());
                    break;
                }
                case 4: {
                    output.write_ushort(this.extract_ushort());
                    break;
                }
                case 5: {
                    output.write_ulong(this.extract_ulong());
                    break;
                }
                case 6: {
                    output.write_float(this.extract_float());
                    break;
                }
                case 7: {
                    output.write_double(this.extract_double());
                    break;
                }
                case 8: {
                    output.write_boolean(this.extract_boolean());
                    break;
                }
                case 9: {
                    output.write_char(this.extract_char());
                    break;
                }
                case 10: {
                    output.write_octet(this.extract_octet());
                    break;
                }
                case 11: {
                    output.write_any(this.extract_any());
                    break;
                }
                case 12: {
                    output.write_TypeCode(this.extract_TypeCode());
                    break;
                }
                case 13: {
                    throw new NO_IMPLEMENT("Principal deprecated");
                }
                case 14: {
                    output.write_Object(this.extract_Object());
                    break;
                }
                case 15: 
                case 16: 
                case 17: {
                    this.writeComplexValue(output);
                    break;
                }
                case 18: {
                    output.write_string(this.extract_string());
                    break;
                }
                case 19: 
                case 20: 
                case 21: 
                case 22: {
                    this.writeComplexValue(output);
                    break;
                }
                case 23: {
                    output.write_longlong(this.extract_longlong());
                    break;
                }
                case 24: {
                    output.write_ulonglong(this.extract_ulonglong());
                    break;
                }
                case 25: {
                    throw new BAD_TYPECODE("type longdouble not supported in java");
                }
                case 26: {
                    output.write_wchar(this.extract_wchar());
                    break;
                }
                case 27: {
                    output.write_wstring(this.extract_wstring());
                    break;
                }
                case 28: {
                    if (output instanceof CDROutputStream) {
                        try {
                            ((CDROutputStream)output).write_fixed(this.extract_fixed(), this.typeCode.fixed_digits(), this.typeCode.fixed_scale());
                            break;
                        }
                        catch (BadKind e) {
                            throw new RuntimeException("should never happen", e);
                        }
                    }
                    output.write_fixed(this.extract_fixed());
                    break;
                }
                case 29: 
                case 30: {
                    OutputStream outputStream = (OutputStream)output;
                    Serializable serializable = (Serializable)this.value;
                    outputStream.write_value(serializable);
                    break;
                }
                case 31: {
                    throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + kind);
                }
                case 32: {
                    ((OutputStream)output).write_abstract_interface(this.value);
                    break;
                }
                default: {
                    throw new BAD_TYPECODE("Cannot handle TypeCode with kind " + kind);
                }
            }
        }
    }

    public void insert_void() {
        this.typeCode = this.orb.get_primitive_tc(TCKind.tk_void);
        this.value = null;
    }

    public void insert(org.omg.CORBA.TypeCode typeCode, java.lang.Object object) {
        this.typeCode = typeCode;
        this.value = object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeComplexValue(org.omg.CORBA.portable.OutputStream output) {
        if (this.value instanceof Streamable) {
            Streamable streamable = (Streamable)this.value;
            streamable._write(output);
        } else if (this.value instanceof org.omg.CORBA.portable.OutputStream) {
            org.omg.CORBA.ORB toUse = this.orb;
            if (!(toUse instanceof ORB)) {
                this.checkStreamClass(output);
                toUse = ((CDROutputStream)output).orb();
            }
            this.checkStreamClass((org.omg.CORBA.portable.OutputStream)this.value);
            CDROutputStream out = (CDROutputStream)this.value;
            CDRInputStream in = new CDRInputStream(toUse, out.getBufferCopy());
            try {
                in.read_value(this.typeCode, output);
            }
            finally {
                in.close();
            }
        } else {
            throw new INTERNAL("Encountered unexpected type for any value: " + this.value.getClass());
        }
    }

    private void checkStreamClass(org.omg.CORBA.portable.OutputStream stream) {
        if (!(stream instanceof CDROutputStream)) {
            throw new INTERNAL("Output class not CDROutputStream " + stream.getClass().getName());
        }
    }

    private boolean compareComplexValue(org.omg.CORBA.Any other) {
        CDROutputStream otherStream;
        CDROutputStream thisStream;
        if (this.value instanceof CDROutputStream) {
            thisStream = (CDROutputStream)this.value;
        } else {
            thisStream = new CDROutputStream(this.orb);
            this.write_value(thisStream);
        }
        if (other instanceof Any && ((Any)other).value instanceof CDROutputStream) {
            otherStream = (CDROutputStream)((Any)other).value;
        } else {
            otherStream = new CDROutputStream(this.orb);
            other.write_value(otherStream);
        }
        return Arrays.equals(thisStream.getBufferCopy(), otherStream.getBufferCopy());
    }
}

