/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.io.Externalizable;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.ir.RepositoryID;
import org.jacorb.orb.Any;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.IDLEntity;

public class TypeCode
extends org.omg.CORBA.TypeCode {
    private final int kind;
    private TCKind tcKind;
    private final String id;
    private final String name;
    private String[] member_name = null;
    private org.omg.CORBA.TypeCode[] member_type = null;
    private short[] member_visibility = null;
    private Any[] member_label = null;
    private short value_modifier = 0;
    private org.omg.CORBA.TypeCode discriminator_type = null;
    private int default_index = -1;
    private int length = -1;
    private org.omg.CORBA.TypeCode content_type = null;
    private short scale;
    private short digits;
    private final boolean recursive;
    private TypeCode actualTypecode = null;
    private boolean secondIteration = false;
    private static final org.omg.CORBA.TypeCode[] primitive_tcs;
    private static final Map primitive_tcs_map;

    private static void put_primitive_tcs(Class clz, int kind) {
        primitive_tcs_map.put(clz, primitive_tcs[kind]);
    }

    static org.omg.CORBA.TypeCode get_primitive_tc(int _kind) {
        if (primitive_tcs[_kind] == null) {
            throw new BAD_PARAM("No primitive TypeCode for kind " + _kind);
        }
        return primitive_tcs[_kind];
    }

    public boolean is_primitive() {
        return !this.is_recursive() && primitive_tcs[this.kind] != null;
    }

    private TypeCode(int kind, String id, String name, boolean recursive) {
        this.kind = kind;
        this.recursive = recursive;
        this.id = id;
        this.name = name != null ? name.replace('.', '_') : "";
    }

    public TypeCode(int kind) {
        this(kind, null, null, false);
    }

    public TypeCode(String id) {
        this(-1, id, null, true);
    }

    public TypeCode(int kind, String id, String name, StructMember[] members) {
        this(kind, id, name, false);
        this.member_name = new String[members.length];
        this.member_type = new org.omg.CORBA.TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            this.member_name[i] = members[i].name;
            this.member_type[i] = members[i].type;
        }
        if (kind == 15) {
            this.resolveRecursion(this);
        }
    }

    public TypeCode(String id, String name, org.omg.CORBA.TypeCode _discriminator_type, UnionMember[] members) {
        this(16, id, name, false);
        this.discriminator_type = _discriminator_type;
        this.member_name = new String[members.length];
        this.member_label = new Any[members.length];
        this.member_type = new org.omg.CORBA.TypeCode[members.length];
        for (int i = 0; i < members.length; ++i) {
            this.member_name[i] = members[i].name;
            this.member_label[i] = (Any)members[i].label;
            if (this.member_label[i].kind().equals(TCKind.tk_octet) && (Byte)this.member_label[i].value() == 0) {
                this.default_index = i;
            }
            this.member_type[i] = members[i].type;
        }
        this.resolveRecursion(this);
    }

    public TypeCode(String id, String name, String[] members) {
        this(17, id, name, false);
        this.member_name = new String[members.length];
        System.arraycopy(members, 0, this.member_name, 0, members.length);
    }

    public TypeCode(int kind, String id, String name, org.omg.CORBA.TypeCode original_type) {
        this(kind, id, name, false);
        this.content_type = original_type;
    }

    public TypeCode(int kind, String id, String name) {
        this(kind, id, name, false);
    }

    public TypeCode(int kind, int bound) {
        this(kind);
        this.length = bound;
    }

    public TypeCode(int kind, int bound, org.omg.CORBA.TypeCode element_type) {
        this(kind);
        this.length = bound;
        this.content_type = element_type;
        if (this.content_type == null) {
            throw new BAD_PARAM("TypeCode.ctor, content_type null");
        }
    }

    public TypeCode(short _digits, short _scale) {
        this(28);
        this.digits = _digits;
        this.scale = _scale;
    }

    public TypeCode(String id, String name, short type_modifier, org.omg.CORBA.TypeCode concrete_base, ValueMember[] members) {
        this(29, id, name, false);
        this.value_modifier = type_modifier;
        this.content_type = concrete_base;
        this.setValueMembers(members);
        this.resolveRecursion(this);
    }

    private void setValueMembers(ValueMember[] members) {
        int member_count = members != null ? members.length : 0;
        this.member_name = new String[member_count];
        this.member_type = new org.omg.CORBA.TypeCode[member_count];
        this.member_visibility = new short[member_count];
        for (int i = 0; i < member_count; ++i) {
            this.member_name[i] = members[i].name;
            this.member_type[i] = members[i].type;
            this.member_visibility[i] = members[i].access;
        }
    }

    @Override
    public boolean equal(org.omg.CORBA.TypeCode tc) {
        try {
            if (this.is_recursive()) {
                this.checkActualTC();
                if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                    TypeCode jtc = (TypeCode)tc;
                    jtc.checkActualTC();
                    if (this.secondIteration) {
                        return true;
                    }
                    this.secondIteration = true;
                    boolean result = this.actualTypecode.equal(jtc.actualTypecode);
                    this.secondIteration = false;
                    return result;
                }
                return tc.equal(this.actualTypecode);
            }
            if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                TypeCode jtc = (TypeCode)tc;
                jtc.checkActualTC();
                return this.equal(jtc.actualTypecode);
            }
            if (this.kind().value() != tc.kind().value()) {
                return false;
            }
            if (!(this.kind != 14 && this.kind != 15 && this.kind != 16 && this.kind != 17 && this.kind != 21 && this.kind != 22 && this.kind != 29 && this.kind != 30 && this.kind != 31 && this.kind != 32 && this.kind != 33 || this.id().equals(tc.id()) && this.name().equals(tc.name()))) {
                return false;
            }
            if (this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 29 || this.kind == 22) {
                if (this.member_count() != tc.member_count()) {
                    return false;
                }
                for (int i = 0; i < this.member_count(); ++i) {
                    if (!this.member_name(i).equals(tc.member_name(i))) {
                        return false;
                    }
                    if (this.kind != 17 && !this.member_type(i).equal(tc.member_type(i))) {
                        return false;
                    }
                    if (this.kind == 16 && !this.member_label(i).equal(tc.member_label(i))) {
                        return false;
                    }
                    if (this.kind != 29 || this.member_visibility(i) == tc.member_visibility(i)) continue;
                    return false;
                }
            }
            if (!(this.kind != 16 || this.discriminator_type().equal(tc.discriminator_type()) && this.default_index() == tc.default_index())) {
                return false;
            }
            if ((this.kind == 18 || this.kind == 27 || this.kind == 20 || this.kind == 19) && this.length() != tc.length()) {
                return false;
            }
            if (!(this.kind != 20 && this.kind != 19 && this.kind != 21 && this.kind != 30 || this.content_type().equal(tc.content_type()))) {
                return false;
            }
            if (this.kind == 28 && (this.fixed_digits() != tc.fixed_digits() || this.fixed_scale() != tc.fixed_scale())) {
                return false;
            }
            if (this.kind == 29) {
                if (this.type_modifier() != tc.type_modifier()) {
                    return false;
                }
                if (this.concrete_base_type() != null || tc.concrete_base_type() != null) {
                    if (this.concrete_base_type() == null || tc.concrete_base_type() == null) {
                        return false;
                    }
                    if (!this.concrete_base_type().equal(tc.concrete_base_type())) {
                        return false;
                    }
                }
            }
        }
        catch (Bounds b) {
            return false;
        }
        catch (BadKind bk) {
            return false;
        }
        return true;
    }

    @Override
    public TCKind kind() {
        if (this.tcKind == null) {
            if (this.is_recursive()) {
                this.checkActualTC();
                this.tcKind = this.actualTypecode.kind();
            } else {
                this.tcKind = TCKind.from_int(this.kind);
            }
        }
        return this.tcKind;
    }

    @Override
    public String id() throws BadKind {
        if (this.is_recursive()) {
            return this.id;
        }
        switch (this.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                return this.id;
            }
            case 18: 
            case 19: 
            case 20: {
                throw new BadKind();
            }
            case 21: 
            case 22: {
                return this.id;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                throw new BadKind();
            }
            case 29: 
            case 30: {
                return this.id;
            }
            case 31: {
                throw new BadKind();
            }
            case 32: 
            case 33: {
                return this.id;
            }
        }
        throw new BadKind();
    }

    @Override
    public String name() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.name();
        }
        switch (this.kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                return this.name;
            }
        }
        throw new BadKind();
    }

    @Override
    public int member_count() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_count();
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                return this.member_name.length;
            }
        }
        throw new BadKind();
    }

    @Override
    public String member_name(int index) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_name(index);
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: 
            case 29: {
                if (index >= 0 && index < this.member_name.length) {
                    return this.member_name[index];
                }
                throw new Bounds();
            }
        }
        throw new BadKind();
    }

    @Override
    public org.omg.CORBA.TypeCode member_type(int index) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_type(index);
        }
        switch (this.kind) {
            case 15: 
            case 16: 
            case 22: 
            case 29: {
                if (index >= 0 && index < this.member_name.length) {
                    return this.member_type[index];
                }
                throw new Bounds();
            }
        }
        throw new BadKind();
    }

    @Override
    public org.omg.CORBA.Any member_label(int index) throws BadKind, Bounds {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.member_label(index);
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        if (index < 0 || index >= this.member_name.length) {
            throw new Bounds();
        }
        return this.member_label[index];
    }

    @Override
    public org.omg.CORBA.TypeCode discriminator_type() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.discriminator_type();
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        return this.discriminator_type;
    }

    @Override
    public int default_index() throws BadKind {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.default_index();
        }
        if (this.kind != 16) {
            throw new BadKind();
        }
        return this.default_index;
    }

    @Override
    public int length() throws BadKind {
        switch (this.kind) {
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this.length;
            }
        }
        throw new BadKind();
    }

    @Override
    public org.omg.CORBA.TypeCode content_type() throws BadKind {
        switch (this.kind) {
            case 19: 
            case 20: 
            case 21: 
            case 30: {
                return this.content_type;
            }
        }
        throw new BadKind();
    }

    @Override
    public short fixed_digits() throws BadKind {
        if (this.kind != 28) {
            throw new BadKind();
        }
        return this.digits;
    }

    @Override
    public short fixed_scale() throws BadKind {
        if (this.kind != 28) {
            throw new BadKind();
        }
        return this.scale;
    }

    @Override
    public org.omg.CORBA.TypeCode get_compact_typecode() {
        int i;
        TypeCode result = new TypeCode(this.kind, this.id, "", this.recursive);
        if (this.member_name != null) {
            result.member_name = new String[this.member_name.length];
            for (i = 0; i < result.member_name.length; ++i) {
                result.member_name[i] = "";
            }
        }
        if (this.member_type != null) {
            result.member_type = new TypeCode[this.member_type.length];
            for (i = 0; i < result.member_type.length; ++i) {
                result.member_type[i] = this.member_type[i].get_compact_typecode();
            }
        }
        result.member_visibility = this.member_visibility;
        result.member_label = this.member_label;
        result.value_modifier = this.value_modifier;
        result.discriminator_type = this.discriminator_type;
        result.default_index = this.default_index;
        result.length = this.length;
        if (this.content_type != null) {
            result.content_type = this.content_type.get_compact_typecode();
        }
        result.scale = this.scale;
        result.digits = this.digits;
        result.secondIteration = this.secondIteration;
        result.resolveRecursion(result);
        return result;
    }

    @Override
    public short member_visibility(int index) throws BadKind, Bounds {
        if (this.kind != 29) {
            throw new BadKind();
        }
        if (index < 0 || index >= this.member_name.length) {
            throw new Bounds();
        }
        return this.member_visibility[index];
    }

    @Override
    public short type_modifier() throws BadKind {
        if (this.kind != 29) {
            throw new BadKind();
        }
        return this.value_modifier;
    }

    @Override
    public org.omg.CORBA.TypeCode concrete_base_type() throws BadKind {
        if (this.kind != 29) {
            throw new BadKind();
        }
        return this.content_type;
    }

    @Override
    public boolean equivalent(org.omg.CORBA.TypeCode tc) {
        try {
            if (this.is_recursive()) {
                this.checkActualTC();
                if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                    TypeCode jtc = (TypeCode)tc;
                    jtc.checkActualTC();
                    if (this.secondIteration) {
                        return true;
                    }
                    this.secondIteration = true;
                    boolean result = this.actualTypecode.equivalent(jtc.actualTypecode);
                    this.secondIteration = false;
                    return result;
                }
                return tc.equivalent(this.actualTypecode);
            }
            if (tc instanceof TypeCode && ((TypeCode)tc).is_recursive()) {
                TypeCode jtc = (TypeCode)tc;
                jtc.checkActualTC();
                return this.equivalent(jtc.actualTypecode);
            }
            if (this.kind().value() == 21) {
                return this.content_type().equivalent(tc);
            }
            if (tc.kind().value() == 21) {
                return this.equivalent(tc.content_type());
            }
            if (this.kind().value() != tc.kind().value()) {
                return false;
            }
            if ((this.kind == 14 || this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 21 || this.kind == 22 || this.kind == 29 || this.kind == 30 || this.kind == 31 || this.kind == 32 || this.kind == 33) && this.id().length() > 0 && tc.id().length() > 0) {
                return this.id().equals(tc.id());
            }
            if (this.kind == 15 || this.kind == 16 || this.kind == 17 || this.kind == 29 || this.kind == 22) {
                if (this.member_count() != tc.member_count()) {
                    return false;
                }
                for (int i = 0; i < this.member_count(); ++i) {
                    if (this.kind != 17 && !this.member_type(i).equivalent(tc.member_type(i))) {
                        return false;
                    }
                    if (this.kind == 16 && !this.member_label(i).equal(tc.member_label(i))) {
                        return false;
                    }
                    if (this.kind != 29 || this.member_visibility(i) == tc.member_visibility(i)) continue;
                    return false;
                }
            }
            if (!(this.kind != 16 || this.discriminator_type().equivalent(tc.discriminator_type()) && this.default_index() == tc.default_index())) {
                return false;
            }
            if ((this.kind == 18 || this.kind == 27 || this.kind == 20 || this.kind == 19) && this.length() != tc.length()) {
                return false;
            }
            if (!(this.kind != 20 && this.kind != 19 && this.kind != 21 && this.kind != 30 || this.content_type().equivalent(tc.content_type()))) {
                return false;
            }
            if (this.kind == 28 && (this.fixed_digits() != tc.fixed_digits() || this.fixed_scale() != tc.fixed_scale())) {
                return false;
            }
            if (!(this.kind != 29 || this.type_modifier() == tc.type_modifier() && this.concrete_base_type().equivalent(tc.concrete_base_type()))) {
                return false;
            }
        }
        catch (Bounds b) {
            return false;
        }
        catch (BadKind bk) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "{TypeCode: Kind=" + this.kind + " (" + this.kindToString(this.kind) + "), ID=" + this.id + ", recursive=" + this.recursive + "}";
    }

    private boolean is_recursive() {
        return this.recursive;
    }

    public static boolean isRecursive(org.omg.CORBA.TypeCode typeCode) {
        return typeCode instanceof TypeCode ? ((TypeCode)typeCode).is_recursive() : false;
    }

    private String kindToString(int kind) {
        switch (kind) {
            case -1: {
                return "recursive";
            }
            case 0: {
                return "tk_null";
            }
            case 1: {
                return "tk_void";
            }
            case 2: {
                return "tk_short";
            }
            case 3: {
                return "tk_long";
            }
            case 4: {
                return "tk_ushort";
            }
            case 5: {
                return "tk_ulong";
            }
            case 6: {
                return "tk_float";
            }
            case 7: {
                return "tk_double";
            }
            case 8: {
                return "tk_boolean";
            }
            case 9: {
                return "tk_char";
            }
            case 10: {
                return "tk_octet";
            }
            case 11: {
                return "tk_any";
            }
            case 12: {
                return "tk_TypeCode";
            }
            case 13: {
                return "tk_Principal";
            }
            case 14: {
                return "tk_objref";
            }
            case 15: {
                return "tk_struct";
            }
            case 16: {
                return "tk_union";
            }
            case 17: {
                return "tk_enum";
            }
            case 18: {
                return "tk_string";
            }
            case 19: {
                return "tk_sequence";
            }
            case 20: {
                return "tk_array";
            }
            case 21: {
                return "tk_alias";
            }
            case 22: {
                return "tk_except";
            }
            case 23: {
                return "tk_longlong";
            }
            case 24: {
                return "tk_ulonglong";
            }
            case 25: {
                return "tk_longdouble";
            }
            case 26: {
                return "tk_wchar";
            }
            case 27: {
                return "tk_wstring";
            }
            case 28: {
                return "tk_fixed";
            }
            case 29: {
                return "tk_value";
            }
            case 30: {
                return "tk_value_box";
            }
            case 31: {
                return "tk_native";
            }
            case 32: {
                return "tk_abstract_interface";
            }
            case 33: {
                return "tk_local_interface";
            }
        }
        throw new BAD_PARAM();
    }

    public static String idlTypeName(org.omg.CORBA.TypeCode typeCode) {
        return typeCode instanceof TypeCode ? ((TypeCode)typeCode).idlTypeName() : "(foreign typecode)";
    }

    public String idlTypeName() {
        if (this.is_recursive()) {
            this.checkActualTC();
            return this.actualTypecode.idlTypeName();
        }
        switch (this.kind().value()) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 31: 
            case 32: 
            case 33: {
                try {
                    return TypeCode.idToIDL(this.id());
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 1: {
                return "void";
            }
            case 18: {
                return "string";
            }
            case 27: {
                return "wstring";
            }
            case 20: {
                try {
                    return TypeCode.idlTypeName(this.content_type()) + "[]";
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 3: {
                return "long";
            }
            case 5: {
                return "ulong";
            }
            case 23: {
                return "long long";
            }
            case 24: {
                return "ulong long";
            }
            case 4: {
                return "ushort";
            }
            case 2: {
                return "short";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "double";
            }
            case 28: {
                try {
                    return "fixed <" + this.fixed_digits() + "," + this.fixed_scale() + ">";
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
            case 8: {
                return "boolean";
            }
            case 10: {
                return "octet";
            }
            case 9: {
                return "char";
            }
            case 26: {
                return "wchar";
            }
            case 11: {
                return "any";
            }
            case 19: {
                try {
                    return "sequence <" + TypeCode.idlTypeName(this.content_type()) + ">";
                }
                catch (BadKind bk) {
                    throw new INTERNAL("should never happen");
                }
            }
        }
        return "* no typeName for TK " + this.kind().value() + " *";
    }

    private static String idToIDL(String id) {
        if (id.length() > 4) {
            id = id.startsWith("IDL:") ? id.substring(4, id.lastIndexOf(":")) : id.replace('.', '/') + ":1.0";
        }
        StringBuffer sb = new StringBuffer(id);
        for (int i = 0; i < sb.length(); ++i) {
            if (sb.charAt(i) != '/') continue;
            sb.setCharAt(i, ':');
            sb.insert(i, ':');
        }
        return sb.toString();
    }

    public static final org.omg.CORBA.TypeCode originalType(org.omg.CORBA.TypeCode typeCode) {
        if (TypeCode.isRecursive(typeCode)) {
            return typeCode;
        }
        try {
            while (typeCode.kind() == TCKind.tk_alias || typeCode.kind() == TCKind.tk_value_box) {
                typeCode = typeCode.content_type();
            }
        }
        catch (BadKind bk) {
            throw new INTERNAL("should never happen");
        }
        return typeCode;
    }

    public static TypeCode create_tc(Class clazz) {
        return TypeCode.create_tc(clazz, new HashMap());
    }

    private static TypeCode create_tc(Class clazz, Map knownTypes) {
        if (clazz.isPrimitive()) {
            return (TypeCode)primitive_tcs_map.get(clazz);
        }
        if (knownTypes.containsKey(clazz)) {
            TypeCode newTypeCode = new TypeCode(RepositoryID.repId(clazz));
            newTypeCode.setActualTC((TypeCode)knownTypes.get(clazz));
            return newTypeCode;
        }
        if (clazz.isArray()) {
            TypeCode newTypeCode = new TypeCode(30, RepositoryID.repId(clazz), "Java_array", new TypeCode(19, 0, TypeCode.create_tc(clazz.getComponentType(), knownTypes)));
            return newTypeCode;
        }
        if (Remote.class.isAssignableFrom(clazz)) {
            return new TypeCode(14, RepositoryID.repId(clazz), clazz.getName());
        }
        if (IDLEntity.class.isAssignableFrom(clazz)) {
            String helperClassName = clazz.getName() + "Helper";
            try {
                ClassLoader classLoader = clazz.getClassLoader();
                Class<?> helperClass = classLoader == null ? ObjectUtil.classForName(helperClassName) : classLoader.loadClass(helperClassName);
                Method typeMethod = helperClass.getMethod("type", null);
                TypeCode newTypeCode = (TypeCode)typeMethod.invoke(null, (Object[])null);
                return newTypeCode;
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Cannot create TypeCode for class " + clazz + "\nReason: Error loading helper class " + helperClassName + "\n" + e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("Cannot create TypeCode for class: " + clazz + "\nReason: no type() method in helper class " + helperClassName + "\n" + e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot create TypeCode for class: " + clazz + "\n" + e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException("Cannot create TypeCode for class: " + clazz + "\nReason: exception in type() method\n " + e.getTargetException());
            }
        }
        if (clazz == Serializable.class || clazz == Externalizable.class || clazz == Object.class) {
            return (TypeCode)TypeCode.get_primitive_tc(11);
        }
        if (TypeCode.isMappedToAnAbstractInterface(clazz)) {
            TypeCode newTypeCode = new TypeCode(32, RepositoryID.repId(clazz), clazz.getName());
            return newTypeCode;
        }
        Class superClass = clazz.getSuperclass();
        TypeCode superTypeCode = null;
        if (superClass != null && superClass != Object.class) {
            superTypeCode = TypeCode.create_tc(superClass, knownTypes);
        }
        TypeCode newTypeCode = new TypeCode(RepositoryID.repId(clazz), clazz.getName(), 0, superTypeCode, new ValueMember[0]);
        knownTypes.put(clazz, newTypeCode);
        newTypeCode.setValueMembers(TypeCode.getValueMembers(clazz, knownTypes));
        knownTypes.remove(clazz);
        return newTypeCode;
    }

    private static boolean isMappedToAnAbstractInterface(Class clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        Method[] methods = clazz.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            int j;
            Class<?>[] exceps = methods[i].getExceptionTypes();
            for (j = 0; j < exceps.length && !exceps[j].isAssignableFrom(RemoteException.class); ++j) {
            }
            if (j != exceps.length) continue;
            return false;
        }
        return true;
    }

    private static ValueMember[] getValueMembers(Class clazz, Map knownTypes) {
        ArrayList<ValueMember> result = new ArrayList<ValueMember>();
        Field[] fields = clazz.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            if ((fields[i].getModifiers() & 0x98) != 0) continue;
            result.add(TypeCode.createValueMember(fields[i], knownTypes));
        }
        return result.toArray(new ValueMember[result.size()]);
    }

    private static ValueMember createValueMember(Field field, Map knownTypes) {
        Class<?> type = field.getType();
        String id = RepositoryID.repId(type);
        TypeCode tc = TypeCode.create_tc(type, knownTypes);
        short access = (field.getModifiers() & 1) != 0 ? (short)1 : 0;
        return new ValueMember(field.getName(), id, "", "1.0", tc, null, access);
    }

    private void resolveRecursion(TypeCode actual) {
        if (this.member_type == null) {
            return;
        }
        block5: for (int i = 0; i < this.member_type.length; ++i) {
            org.omg.CORBA.TypeCode typeCode = TypeCode.originalType(this.member_type[i]);
            if (!(typeCode instanceof TypeCode)) continue;
            TypeCode tc = (TypeCode)typeCode;
            switch (tc.kind) {
                case 15: 
                case 16: 
                case 29: {
                    tc.resolveRecursion(actual);
                    continue block5;
                }
                case 19: {
                    typeCode = TypeCode.originalType(tc.content_type);
                    if (!(typeCode instanceof TypeCode)) continue block5;
                    tc = (TypeCode)typeCode;
                    if (tc.is_recursive() && tc.id.equals(actual.id)) {
                        tc.setActualTC(actual);
                        continue block5;
                    }
                    tc.resolveRecursion(actual);
                    continue block5;
                }
                case -1: {
                    if (!tc.id.equals(actual.id)) continue block5;
                    tc.setActualTC(actual);
                }
            }
        }
    }

    private void setActualTC(TypeCode typeCode) {
        if (this.is_recursive()) {
            this.actualTypecode = typeCode;
        }
    }

    private void checkActualTC() {
        if (this.is_recursive() && this.actualTypecode == null) {
            throw new BAD_INV_ORDER();
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof org.omg.CORBA.TypeCode)) {
            return false;
        }
        return this.equal((org.omg.CORBA.TypeCode)obj);
    }

    public int hashCode() {
        int result = this.id == null ? super.hashCode() : this.id.hashCode();
        return result;
    }

    static {
        int i;
        primitive_tcs = new TypeCode[34];
        primitive_tcs_map = new HashMap();
        for (i = 0; i <= 13; ++i) {
            TypeCode.primitive_tcs[i] = new TypeCode(i);
        }
        for (i = 23; i <= 26; ++i) {
            TypeCode.primitive_tcs[i] = new TypeCode(i);
        }
        TypeCode.primitive_tcs[18] = new TypeCode(18, 0);
        TypeCode.primitive_tcs[27] = new TypeCode(27, 0);
        TypeCode.primitive_tcs[28] = new TypeCode(1, 0);
        TypeCode.primitive_tcs[14] = new TypeCode(14, "IDL:omg.org/CORBA/Object:1.0", "Object");
        TypeCode.primitive_tcs[29] = new TypeCode("IDL:omg.org/CORBA/portable/ValueBase:1.0", "ValueBase", 0, null, new ValueMember[0]);
        TypeCode.put_primitive_tcs(Boolean.TYPE, 8);
        TypeCode.put_primitive_tcs(Character.TYPE, 26);
        TypeCode.put_primitive_tcs(Byte.TYPE, 10);
        TypeCode.put_primitive_tcs(Short.TYPE, 2);
        TypeCode.put_primitive_tcs(Integer.TYPE, 3);
        TypeCode.put_primitive_tcs(Long.TYPE, 23);
        TypeCode.put_primitive_tcs(Float.TYPE, 6);
        TypeCode.put_primitive_tcs(Double.TYPE, 7);
    }
}

