/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.diagnostic.core.engine;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import tecgraf.diagnostic.commom.InvalidResource;
import tecgraf.diagnostic.commom.Status;
import tecgraf.diagnostic.commom.StatusCode;
import tecgraf.diagnostic.core.engine.UpdateHandler;
import tecgraf.diagnostic.core.monitor.Monitor;
import tecgraf.diagnostic.core.monitor.ProactiveMonitor;

public class Engine {
    private long pollingInterval = 10000L;
    private List<Monitor> monitors = new Vector<Monitor>();
    private Map<String, Status> monitorStatus = new Hashtable<String, Status>();

    public Engine() {
        this(10000L);
    }

    public Engine(long l) {
        this.pollingInterval = l;
        MonitorThread monitorThread = new MonitorThread();
        monitorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMonitor(Monitor monitor) throws InvalidResource {
        Map<String, Status> map = this.monitorStatus;
        synchronized (map) {
            if (ProactiveMonitor.class.isInstance(monitor)) {
                ((ProactiveMonitor)ProactiveMonitor.class.cast(monitor)).registerEngine(new UpdateHandlerImpl(monitor.getResourceName()));
            }
            if (this.monitorStatus.containsKey(monitor.getResourceName())) {
                String string = MessageFormat.format("J\u00e1 exite um recurso com o nome sendo {0} monitorado", monitor.getResourceName());
                throw new InvalidResource(string);
            }
            this.monitorStatus.put(monitor.getResourceName(), new Status(monitor.getResourceName(), StatusCode.INITIATING, "Monitor iniciando"));
            this.monitors.add(monitor);
        }
    }

    public Status getStatus(String string) throws InvalidResource {
        Status status = this.monitorStatus.get(string);
        if (status == null) {
            String string2 = MessageFormat.format("Recurso {0} n\u00e3o est\u00e1 sendo monitorado", string);
            throw new InvalidResource(string2);
        }
        return status;
    }

    public Status updateAndGetStatus(String string) throws InvalidResource {
        for (Monitor monitor : this.monitors) {
            if (!monitor.getResourceName().equals(string)) continue;
            this.monitorStatus.put(monitor.getResourceName(), monitor.checkResource());
            return this.getStatus(string);
        }
        String string2 = MessageFormat.format("Recurso {0} n\u00e3o est\u00e1 sendo monitorado", string);
        throw new InvalidResource(string2);
    }

    private class MonitorThread
    extends Thread {
        private MonitorThread() {
        }

        @Override
        public void run() {
            block4: while (true) {
                try {
                    Thread.sleep(Engine.this.pollingInterval);
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                try {
                    Iterator iterator = Engine.this.monitors.iterator();
                    while (true) {
                        if (!iterator.hasNext()) continue block4;
                        Monitor monitor = (Monitor)iterator.next();
                        Engine.this.monitorStatus.put(monitor.getResourceName(), monitor.checkResource());
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private class UpdateHandlerImpl
    implements UpdateHandler {
        private String resourceName;

        private UpdateHandlerImpl(String string) {
            this.resourceName = string;
        }

        @Override
        public void updateStatus(Status status) {
            Engine.this.monitorStatus.put(this.resourceName, status);
        }
    }
}

