/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.categories;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.categories.CategoryWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.EntityCategory;

public class CategoryInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel categoryIDLabel;
    private JTextField categoryIDField;
    private JLabel categoryNameLabel;
    private JTextField categoryNameField;
    private TablePanelComponent<CategoryWrapper> panel;
    private CategoryWrapper editingCategory = null;

    public CategoryInputDialog(Window parentWindow, TablePanelComponent<CategoryWrapper> panel, BusAdmin admin) {
        super(parentWindow, LNG.get((String)(CategoryInputDialog.class.getSimpleName() + ".title")), admin);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){
            EntityCategory category;

            protected void performTask() throws Exception {
                if (CategoryInputDialog.this.editingCategory == null) {
                    this.category = CategoryInputDialog.this.admin.createCategory(CategoryInputDialog.this.getCategoryID(), CategoryInputDialog.this.getCategoryName());
                } else {
                    this.category = ((CategoryInputDialog)CategoryInputDialog.this).editingCategory.getDescriptor().ref;
                    this.category.setName(CategoryInputDialog.this.getCategoryName());
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CategoryInputDialog.this.panel.refresh(null);
                    CategoryInputDialog.this.panel.selectElement(new CategoryWrapper(this.category.describe()), true);
                }
            }
        };
        task.execute(this, Utils.getString(this.getClass(), "waiting.title"), Utils.getString(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC baseGBC = new GBC().gridx(0).insets(5).west();
        this.categoryIDLabel = new JLabel(LNG.get((String)"CategoryInputDialog.categoryID.label"));
        panel.add((Component)this.categoryIDLabel, new GBC(baseGBC).gridy(0).none());
        this.categoryIDField = new JTextField(30);
        panel.add((Component)this.categoryIDField, new GBC(baseGBC).gridy(1).horizontal());
        this.categoryNameLabel = new JLabel(LNG.get((String)"CategoryInputDialog.categoryName.label"));
        panel.add((Component)this.categoryNameLabel, new GBC(baseGBC).gridy(2).none());
        this.categoryNameField = new JTextField(30);
        panel.add((Component)this.categoryNameField, new GBC(baseGBC).gridy(3).horizontal());
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        String categoryID = this.categoryIDField.getText();
        if (categoryID.equals("")) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyID"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(CategoryWrapper info) {
        this.editingCategory = info;
        this.categoryIDField.setText(info.getId());
        this.categoryIDField.setEnabled(false);
        this.categoryNameField.setText(info.getName());
    }

    private String getCategoryID() {
        return this.categoryIDField.getText();
    }

    private String getCategoryName() {
        return this.categoryNameField.getText();
    }
}

