/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.certificates;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.certificates.CertificateWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Utils;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.io.FileUtils;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.openbus.admin.BusAdmin;

public class CertificateInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel identifierLabel;
    private JTextField identifierField;
    private JLabel certificateLabel;
    private JTextField certificateField;
    private JButton certificateButton;
    private TablePanelComponent<CertificateWrapper> panel;

    public CertificateInputDialog(Window parentWindow, TablePanelComponent<CertificateWrapper> panel, BusAdmin admin) {
        super(parentWindow, LNG.get((String)(CertificateInputDialog.class.getSimpleName() + ".title")), admin);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                File certificateFile = new File(CertificateInputDialog.this.getCertificatePath());
                byte[] certificate = FileUtils.readFileToByteArray((File)certificateFile);
                CertificateInputDialog.this.admin.registerCertificate(CertificateInputDialog.this.getIdentifier(), certificate);
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CertificateInputDialog.this.panel.refresh(null);
                    CertificateInputDialog.this.panel.selectElement(new CertificateWrapper(CertificateInputDialog.this.getIdentifier()), true);
                }
            }
        };
        task.execute(this, Utils.getString(this.getClass(), "waiting.title"), Utils.getString(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    protected JPanel buildFields() {
        JPanel panel = new JPanel(new GridBagLayout());
        GBC baseGBC = new GBC().gridx(0).insets(5).west();
        this.identifierLabel = new JLabel(LNG.get((String)"CertificateInputDialog.identifier.label"));
        panel.add((Component)this.identifierLabel, new GBC(baseGBC).gridy(0).none());
        this.identifierField = new JTextField(30);
        panel.add((Component)this.identifierField, new GBC(baseGBC).gridy(1).horizontal());
        this.certificateLabel = new JLabel(LNG.get((String)"CertificateInputDialog.certificate.label"));
        panel.add((Component)this.certificateLabel, new GBC(baseGBC).gridy(2).none());
        JPanel certificatePane = new JPanel(new GridBagLayout());
        this.certificateField = new JTextField();
        this.certificateField.setEditable(false);
        certificatePane.add((Component)this.certificateField, new GBC(0, 0).right(5).horizontal());
        this.certificateButton = new JButton(LNG.get((String)"CertificateInputDialog.certificate.search"));
        this.certificateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CertificateInputDialog.this.chooseCertificateFile();
            }
        });
        certificatePane.add((Component)this.certificateButton, new GBC(1, 0).east());
        panel.add((Component)certificatePane, new GBC(baseGBC).gridy(3).horizontal());
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.getIdentifier().equals("")) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyID"));
            return false;
        }
        if (this.getCertificatePath().equals("")) {
            this.setErrorMessage(Utils.getString(this.getClass(), "error.validation.emptyPath"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(CertificateWrapper info) {
        this.identifierField.setText(info.getEntity());
        this.identifierField.setEnabled(false);
    }

    public void chooseCertificateFile() {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(0);
        int status = chooser.showOpenDialog(this);
        if (status == 0) {
            String certificatePath = chooser.getSelectedFile().getAbsolutePath();
            this.certificateField.setText(certificatePath);
        }
    }

    private String getIdentifier() {
        return this.identifierField.getText();
    }

    private String getCertificatePath() {
        return this.certificateField.getText();
    }
}

