/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.offers;

import busexplorer.utils.Utils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import tecgraf.openbus.core.v2_0.services.offer_registry.ServiceOfferDesc;

public class OfferWrapper {
    private ServiceOfferDesc desc;
    private final String entity;
    private final Vector<String> interfaces;
    private final Date date;
    private final String name;
    private final String version;

    public OfferWrapper(ServiceOfferDesc desc) {
        this.desc = desc;
        this.entity = Utils.getProperty(desc, "openbus.offer.entity");
        this.interfaces = Utils.getProperties(desc, "openbus.component.interface");
        int year = Integer.parseInt(Utils.getProperty(desc, "openbus.offer.year"));
        int month = Integer.parseInt(Utils.getProperty(desc, "openbus.offer.month")) - 1;
        int day = Integer.parseInt(Utils.getProperty(desc, "openbus.offer.day"));
        int hour = Integer.parseInt(Utils.getProperty(desc, "openbus.offer.hour"));
        int min = Integer.parseInt(Utils.getProperty(desc, "openbus.offer.minute"));
        int sec = Integer.parseInt(Utils.getProperty(desc, "openbus.offer.second"));
        Calendar calendar = Calendar.getInstance();
        calendar.set(year, month, day, hour, min, sec);
        this.date = calendar.getTime();
        this.name = Utils.getProperty(desc, "openbus.component.name");
        String version = Utils.getProperty(desc, "openbus.component.version.major");
        version = version + "." + Utils.getProperty(desc, "openbus.component.version.minor");
        this.version = version = version + "." + Utils.getProperty(desc, "openbus.component.version.patch");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OfferWrapper)) {
            return false;
        }
        OfferWrapper other = (OfferWrapper)o;
        return this.entity.equals(other.entity) && this.interfaces.equals(other.interfaces) && this.date.equals(other.date);
    }

    public int hashCode() {
        return this.entity.hashCode() ^ this.interfaces.hashCode() ^ this.date.hashCode();
    }

    public String getEntityId() {
        return this.entity;
    }

    public Vector<String> getInterfaces() {
        return this.interfaces;
    }

    public Date getDate() {
        return this.date;
    }

    public ServiceOfferDesc getDescriptor() {
        return this.desc;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public static List<OfferWrapper> convertToInfo(List<ServiceOfferDesc> offers) {
        ArrayList<OfferWrapper> list = new ArrayList<OfferWrapper>();
        for (ServiceOfferDesc offer : offers) {
            list.add(new OfferWrapper(offer));
        }
        return list;
    }
}

