/*
 * Decompiled with CFR 0.152.
 */
package busexplorer;

import busexplorer.BusExplorerLogin;
import busexplorer.desktop.dialog.LoginDialog;
import busexplorer.desktop.dialog.MainDialog;
import busexplorer.exception.BusExplorerExceptionHandler;
import busexplorer.utils.Utils;
import java.awt.EventQueue;
import java.awt.Window;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.admin.BusAdminImpl;

public class Application {
    private static BusExplorerExceptionHandler handler = new BusExplorerExceptionHandler();
    private static BusExplorerLogin login;
    private static PropertyChangeSupport loginPcs;
    private static BusAdmin admin;

    public static void main(String[] args) {
        LNG.load("busadminlib.resources.language.idiom", new Locale("pt", "BR"));
        LNG.load("busexplorer.resources.language.idiom", new Locale("pt", "BR"));
        LNG.load("reuse.modified.logistic.client.resources.language.idiom", new Locale("pt", "BR"));
        final Properties properties = new Properties();
        try {
            InputStream in = MainDialog.class.getResourceAsStream("/busexplorer/resources/client.properties");
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Utils.getString(MainDialog.class, "error.properties.file"), Utils.getString(MainDialog.class, "error.properties.title"), 0);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainDialog mainDialog = new MainDialog(properties, admin);
                mainDialog.show();
                loginPcs = new PropertyChangeSupport(this);
                loginPcs.addPropertyChangeListener(mainDialog);
                Application.loginProcess(mainDialog);
            }
        });
    }

    public static void loginProcess(MainDialog mainDialog) {
        login = null;
        LoginDialog loginDialog = new LoginDialog((Window)mainDialog, admin);
        loginDialog.show();
        login = loginDialog.getLogin();
        loginPcs.firePropertyChange("Application.login", null, login);
    }

    public static BusExplorerExceptionHandler exceptionHandler() {
        return handler;
    }

    public static BusExplorerLogin login() {
        return login;
    }

    static {
        admin = new BusAdminImpl();
    }
}

