/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.diagnostic.addons.openbus.v15;

import java.util.LinkedList;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import tecgraf.diagnostic.commom.Status;
import tecgraf.diagnostic.commom.StatusCode;
import tecgraf.diagnostic.commom.StatusEntry;
import tecgraf.diagnostic.core.monitor.AbstractMonitor;
import tecgraf.diagnostic.core.monitor.InvalidMonitorParameter;
import tecgraf.openbus.Openbus;

public class OpenBusMonitor
extends AbstractMonitor {
    private Openbus bus;

    public OpenBusMonitor(String string, Openbus openbus) throws InvalidMonitorParameter {
        super(string);
        if (openbus == null) {
            throw new InvalidMonitorParameter("A refer\u00eancia do barramento informada est\u00e1 nula");
        }
        this.bus = openbus;
    }

    @Override
    public Status checkResource() {
        LinkedList<StatusEntry> linkedList = new LinkedList<StatusEntry>();
        try {
            StatusEntry statusEntry = this.checkConnection();
            linkedList.add(statusEntry);
            if (statusEntry.code != StatusCode.OK) {
                return new Status(this.resourceName, statusEntry.code, statusEntry.message, linkedList.toArray(new StatusEntry[0]), null);
            }
            statusEntry = this.checkCredential();
            linkedList.add(statusEntry);
            if (statusEntry.code != StatusCode.OK) {
                return new Status(this.resourceName, statusEntry.code, statusEntry.message, linkedList.toArray(new StatusEntry[0]), null);
            }
            statusEntry = this.checkBusServices();
            linkedList.add(statusEntry);
            if (statusEntry.code != StatusCode.OK) {
                return new Status(this.resourceName, statusEntry.code, statusEntry.message, linkedList.toArray(new StatusEntry[0]), null);
            }
            return new Status(this.resourceName, StatusCode.OK, "A conex\u00e3o com o barramento foi iniciada e autenticada com sucesso", linkedList.toArray(new StatusEntry[0]), null);
        }
        catch (TRANSIENT tRANSIENT) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha moment\u00e2nea de acesso ao barramento", linkedList.toArray(new StatusEntry[0]), null);
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha na comunica\u00e7\u00e3o com o barramento", linkedList.toArray(new StatusEntry[0]), null);
        }
        catch (NO_PERMISSION nO_PERMISSION) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha de permiss\u00e3o ao acessar o barramento", linkedList.toArray(new StatusEntry[0]), null);
        }
        catch (SystemException systemException) {
            return new Status(this.resourceName, StatusCode.UNAVAILABLE, "Falha no barramento", linkedList.toArray(new StatusEntry[0]), null);
        }
    }

    private StatusEntry checkConnection() {
        if (this.bus.getORB() == null) {
            return new StatusEntry(StatusCode.UNAVAILABLE, "N\u00e3o h\u00e1 conex\u00e3o com o barramento");
        }
        return new StatusEntry(StatusCode.OK, "Conex\u00e3o com o barramento estabelecida");
    }

    private StatusEntry checkCredential() {
        if (!this.bus.isConnected()) {
            return new StatusEntry(StatusCode.ERROR, "A conex\u00e3o n\u00e3o foi autenticada com sucesso");
        }
        return new StatusEntry(StatusCode.OK, "A conex\u00e3o com o barramento foi autenticada com sucesso");
    }

    private StatusEntry checkBusServices() {
        if (this.bus.getRegistryService() == null) {
            return new StatusEntry(StatusCode.ERROR, "Servi\u00e7o de registro do barramento indispon\u00edvel");
        }
        return new StatusEntry(StatusCode.OK, "Servi\u00e7o de registro do barramento dispon\u00edvel");
    }
}

