/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JTextPane;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.GUIUtils;
import tecgraf.javautils.gui.StandardDialogs;
import tecgraf.javautils.gui.SwingThreadDispatcher;

public abstract class Task<R>
implements Runnable {
    private static final String LNG_KEY_PREFIX = Task.class.getName() + ".";
    private static ThreadLocal<List<Task<?>>> threadLocal = new ThreadLocal();
    private List<Task<?>> taskList = null;
    private int taskIndex = 0;
    private boolean isNested = false;
    private Thread worker = null;
    private long startTime = 0L;
    private volatile boolean uiShowing = false;
    private volatile boolean finished = false;
    private volatile boolean cancelled = false;
    private volatile boolean status = false;
    private R result = null;
    private Exception error = null;
    private int progressDialogDelay = 2;
    public static final int DEFAULT_CANCEL_DELAY = 30;
    public static final int CANCEL_BUTTON = 0;
    public static final int CLOSE_BUTTON = 1;
    private static final int MIN_WIDTH = 300;
    private static final int MIN_HEIGHT = 100;
    private static final String NA = " ---";
    private int cancelDelay = 30;
    private int cancelButtonType = 1;
    private boolean showProgress = false;
    private boolean showSteps = false;
    private ImageIcon image = null;
    protected Window parentWindow = null;
    protected JDialog progressDialog = null;
    private JLabel imageLabel = null;
    protected JTextPane textPane = null;
    protected JProgressBar progressBar = null;
    private JButton cancelButton = null;
    private static DecimalFormat integerTimeFormatter = new DecimalFormat("00");
    protected String taskTitle = null;
    private String message = null;
    private String step = null;
    private String elapsedTime = null;
    private String estimatedTime = null;
    private int percentage = 0;
    private boolean statusUnknown = false;
    private boolean progressDialogEnabled = true;
    private static SimpleAttributeSet[] attrs = null;
    private Dialog.ModalityType modality;

    protected Task() {
        this(Dialog.ModalityType.APPLICATION_MODAL);
    }

    protected Task(Dialog.ModalityType modality) {
        this.setModality(modality);
    }

    private void setModality(Dialog.ModalityType modality) {
        this.modality = modality;
    }

    protected void beforeTaskUI() {
    }

    protected abstract void performTask() throws Exception;

    protected void afterTaskUI() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void run() {
        try {
            if (!this.isNested) {
                this.taskList = new ArrayList();
                threadLocal.set(this.taskList);
                this.taskList.add(this);
            }
            this.startTime = System.currentTimeMillis();
            this.performTask();
            this.status = true;
            this.error = null;
            List<Task<?>> list = this.taskList;
            synchronized (list) {
                this.taskList.remove(this);
            }
        }
        catch (Exception exception) {
            this.status = false;
            this.error = exception;
            List<Task<?>> list = this.taskList;
            synchronized (list) {
                this.taskList.remove(this);
            }
        }
        finally {
            if (!this.isNested) {
                threadLocal.remove();
            } else {
                Thread.interrupted();
            }
        }
        this.finished = true;
    }

    protected final void setResult(R result) {
        this.result = result;
    }

    public final R getResult() {
        return this.result;
    }

    public final boolean getStatus() {
        return this.status;
    }

    public final Exception getError() {
        return this.error;
    }

    public boolean wasCancelled() {
        return this.cancelled;
    }

    protected void cancelTask() {
        this.cancelled = true;
        this.status = false;
    }

    protected void handleError(Exception exception) {
        if (exception != null) {
            StandardDialogs.showErrorDialog(this.parentWindow, this.taskTitle, exception.getMessage());
        }
    }

    private void pack(JDialog dialog) {
        dialog.pack();
        int width = Math.max(dialog.getWidth(), 300);
        dialog.setMinimumSize(new Dimension(width, 100));
    }

    public final void executeNonBlocking(Window window, String title, String description) {
        int cancelDelaySecs = this.getCancelDelaySecs();
        this.preExcecute(window, title, description, cancelDelaySecs, 1, true, false, null);
        this.invokePerformTask(false);
    }

    public final boolean execute(Window window, String title, String description, int cancelDelayInSecs, int cancelButtonType, boolean showProgress, boolean showSteps, ImageIcon icon) {
        this.preExcecute(window, title, description, cancelDelayInSecs, cancelButtonType, showProgress, showSteps, icon);
        this.invokePerformTask(true);
        this.invokeAfterTaskUI();
        if (!this.getStatus()) {
            this.setResult(null);
        }
        return this.getStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preExcecute(Window window, String title, String description, int cancelDelayInSecs, int cancelButtonType, boolean showProgress, boolean showSteps, ImageIcon icon) {
        this.parentWindow = window != null ? window : this.getDefaultParentWindow();
        this.taskTitle = title;
        this.message = description;
        this.cancelDelay = cancelDelayInSecs;
        this.cancelButtonType = cancelButtonType;
        this.showProgress = showProgress;
        this.showSteps = showSteps;
        this.image = icon;
        boolean bl = this.isNested = threadLocal.get() != null;
        if (this.isNested) {
            List<Task<?>> list = this.taskList = threadLocal.get();
            synchronized (list) {
                this.taskIndex = this.taskList.size();
                this.taskList.add(this);
                for (Task<?> task : this.taskList) {
                    if (!task.wasCancelled()) continue;
                    this.cancelTask();
                }
            }
        }
        this.invokeBeforeTaskUI();
    }

    protected Window getDefaultParentWindow() {
        return null;
    }

    private void invokeBeforeTaskUI() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (!Task.this.isNested && Task.this.parentWindow != null) {
                    Task.this.parentWindow.setCursor(Cursor.getPredefinedCursor(3));
                }
                Task.this.beforeTaskUI();
            }
        };
        this.invokeUI(code);
    }

    private void invokePerformTask(boolean block) {
        if (this.isNested) {
            this.invokeNestedPerformTask();
        } else {
            this.invokeThreadPerformTask(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<?> getRoot() {
        if (this.taskList == null) {
            return null;
        }
        List<Task<?>> list = this.taskList;
        synchronized (list) {
            if (this.taskList.size() == 0) {
                return null;
            }
            return this.taskList.get(0);
        }
    }

    private void invokeNestedPerformTask() {
        this.worker = this.getRoot().worker;
        this.run();
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (!Task.this.uiShowing) {
                    return;
                }
                Task root = Task.this.getRoot();
                if (root != null) {
                    Task.this.removeComponents(root.progressDialog.getContentPane());
                    Task.this.pack(root.progressDialog);
                }
                Task.this.uiShowing = false;
            }
        };
        this.invokeUI(code);
    }

    private void invokeThreadPerformTask(final boolean block) {
        if (this.progressDialogEnabled) {
            Runnable code = new Runnable(){

                @Override
                public void run() {
                    Task.this.createProgressDialog(block);
                }
            };
            this.invokeUI(code);
        }
        this.worker = new Thread(this);
        String className = this.worker.getClass().getSimpleName();
        String myName = this.worker.toString();
        this.worker.setName("TASK::" + className + "::" + myName);
        this.worker.start();
        try {
            if (this.progressDialogEnabled) {
                if (this.progressDialogDelay > 0) {
                    this.worker.join(this.progressDialogDelay * 1000);
                }
            } else if (block) {
                this.worker.join();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (this.progressDialogEnabled) {
            Runnable code = new Runnable(){

                @Override
                public void run() {
                    if (!Task.this.worker.isAlive()) {
                        Task.this.progressDialog.dispose();
                        return;
                    }
                    final Timer timer = new Timer(1000, null);
                    timer.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            Task.this.progress(timer);
                        }
                    });
                    timer.start();
                    Task.this.pack(Task.this.progressDialog);
                    Task.this.uiShowing = true;
                    Task.this.progressDialog.setVisible(true);
                    if (block) {
                        Task.this.progressDialog.dispose();
                        Task.this.uiShowing = false;
                    }
                }
            };
            this.invokeUI(code);
        }
    }

    private void invokeAfterTaskUI() {
        Runnable code = new Runnable(){

            @Override
            public void run() {
                if (!Task.this.isNested && Task.this.parentWindow != null) {
                    Task.this.parentWindow.setCursor(Cursor.getPredefinedCursor(0));
                }
                Task.this.afterTaskUI();
                if (!Task.this.getStatus() && !Task.this.cancelled) {
                    Task.this.handleError(Task.this.error);
                }
            }
        };
        this.invokeUI(code);
    }

    private void invokeUI(Runnable code) {
        try {
            if (SwingThreadDispatcher.isEventDispatchThread()) {
                code.run();
            } else {
                SwingThreadDispatcher.invokeAndWait(code);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void progress(Timer timer) {
        if (this.finished || this.cancelled) {
            timer.stop();
            this.progressDialog.setVisible(false);
            this.progressDialog.dispose();
            return;
        }
        boolean newButton = false;
        if (this.taskList == null) {
            this.updateTime();
            newButton = this.checkShowCancelButton();
        } else {
            List<Task<?>> list = this.taskList;
            synchronized (list) {
                for (Task<?> task : this.taskList) {
                    if (task.finished || task.cancelled) break;
                    if (!task.uiShowing) {
                        super.addComponents(this.progressDialog.getContentPane());
                        super.adjustSizes();
                        super.pack(this.progressDialog);
                        task.uiShowing = true;
                    }
                    super.updateTime();
                    newButton = newButton || super.checkShowCancelButton();
                }
            }
        }
        if (newButton) {
            this.adjustSizes();
        }
        this.pack(this.progressDialog);
    }

    private void updateTime() {
        if (this.startTime == 0L) {
            return;
        }
        long elapsed = (System.currentTimeMillis() - this.startTime) / 1000L;
        this.elapsedTime = Task.secToString(elapsed);
        if (this.showProgress) {
            double perc = this.progressBar.getValue();
            double p = perc < 0.0 ? 0.0 : perc;
            double d = p = perc > 100.0 ? 100.0 : perc;
            if (p != 0.0) {
                long tsec = (long)((double)elapsed * 100.0 / p);
                this.estimatedTime = Task.secToString(tsec - elapsed);
            } else {
                this.estimatedTime = NA;
            }
        }
        this.updateTextPane();
    }

    private boolean checkShowCancelButton() {
        if (this.cancelButton != null) {
            return false;
        }
        long now = System.currentTimeMillis();
        if (now - this.startTime < (long)(this.cancelDelay * 1000)) {
            return false;
        }
        this.cancelButton = new JButton();
        String msg = this.cancelButtonType == 0 ? LNG.get("javautils.cancel") : LNG.get("javautils.close");
        this.cancelButton.setText(msg);
        this.cancelButton.addActionListener(new CancelListener());
        int i = this.taskIndex;
        int NL = 2;
        Task<?> root = this.getRoot();
        if (root != null) {
            Container cp = root.progressDialog.getContentPane();
            cp.add((Component)this.cancelButton, new GBC(2, i * NL, new Insets(5, 0, 5, 5)));
            cp.invalidate();
        }
        return true;
    }

    private void createProgressDialog(boolean block) {
        if (block) {
            if (this.modality == Dialog.ModalityType.MODELESS) {
                this.setModality(Dialog.ModalityType.DOCUMENT_MODAL);
            }
        } else {
            this.setModality(Dialog.ModalityType.MODELESS);
        }
        this.progressDialog = new JDialog(this.parentWindow, this.taskTitle, this.modality);
        Container cp = this.progressDialog.getContentPane();
        cp.setLayout(new GridBagLayout());
        this.addComponents(cp);
        this.addCloseCallback(block);
        this.progressDialog.setMinimumSize(new Dimension(300, 100));
        this.progressDialog.setResizable(false);
        this.pack(this.progressDialog);
        GUIUtils.centerWindow(this.progressDialog, this.parentWindow);
    }

    private void addCloseCallback(boolean block) {
        this.progressDialog.setDefaultCloseOperation(0);
        if (!block) {
            this.progressDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosed(WindowEvent e) {
                    Task.this.invokeAfterTaskUI();
                    if (!Task.this.getStatus()) {
                        Task.this.setResult(null);
                    }
                    Task.this.uiShowing = false;
                }
            });
        }
    }

    private void addComponents(Container c) {
        int i = this.taskIndex;
        int NL = 2;
        int NR = 3;
        this.imageLabel = this.image != null ? new JLabel(this.image) : new JLabel();
        c.add((Component)this.imageLabel, new GBC(0, i * NL, new Insets(5, 5, 5, 0)));
        this.textPane = new JTextPane(new DefaultStyledDocument());
        this.textPane.setEditable(false);
        this.textPane.setBackground(this.imageLabel.getBackground());
        this.updateTextPane();
        c.add((Component)this.textPane, new GBC(1, i * NL, new Insets(5, 5, 5, 5)).horizontal());
        this.progressBar = new JProgressBar();
        if (!this.showProgress || this.statusUnknown) {
            this.progressBar.setIndeterminate(true);
            this.progressBar.setStringPainted(false);
            this.statusUnknown = false;
        } else {
            this.progressBar.setIndeterminate(false);
            this.progressBar.setMinimum(0);
            this.progressBar.setMaximum(100);
            this.progressBar.setValue(this.percentage);
            this.progressBar.setStringPainted(true);
        }
        c.add((Component)this.progressBar, new GBC(0, i * NL + 1, new Insets(0, 5, 5, 5)).width(NR).horizontal());
        c.invalidate();
    }

    private void updateTextPane() {
        StyledDocument doc = this.textPane.getStyledDocument();
        try {
            doc.remove(0, doc.getLength());
            int i = 0;
            String text = this.message;
            doc.insertString(doc.getLength(), text, attrs[i]);
            ++i;
            if (this.showSteps) {
                doc.insertString(doc.getLength(), "\n", null);
                text = LNG.get(LNG_KEY_PREFIX + "stepText") + " ";
                text = this.step != null ? text + this.step : text + NA;
                doc.insertString(doc.getLength(), text, attrs[i]);
            }
            doc.insertString(doc.getLength(), "\n", null);
            text = LNG.get(LNG_KEY_PREFIX + "elapsedTime");
            text = this.elapsedTime != null ? text + this.elapsedTime : text + NA;
            doc.insertString(doc.getLength(), text, attrs[++i]);
            ++i;
            if (this.showProgress) {
                doc.insertString(doc.getLength(), "\n", null);
                text = LNG.get(LNG_KEY_PREFIX + "totalTime");
                text = this.estimatedTime != null ? text + this.estimatedTime : text + NA;
                doc.insertString(doc.getLength(), text, attrs[i]);
            }
            ++i;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        Task<?> root = this.getRoot();
        if (root != null) {
            Container cp = root.progressDialog.getContentPane();
            cp.invalidate();
        }
    }

    private void removeComponents(Container c) {
        if (this.imageLabel != null) {
            c.remove(this.imageLabel);
        }
        if (this.textPane != null) {
            c.remove(this.textPane);
        }
        if (this.progressBar != null) {
            c.remove(this.progressBar);
        }
        if (this.cancelButton != null) {
            c.remove(this.cancelButton);
        }
        c.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void adjustSizes() {
        List<Task<?>> list = this.taskList;
        synchronized (list) {
            ArrayList<JComponent> widgets = new ArrayList<JComponent>();
            for (Task<?> task : this.taskList) {
                if (task.imageLabel == null) continue;
                widgets.add(task.imageLabel);
            }
            this.adjustSizes(widgets);
            widgets.clear();
            for (Task<?> task : this.taskList) {
                if (task.cancelButton == null) continue;
                widgets.add(task.cancelButton);
            }
            this.adjustSizes(widgets);
        }
    }

    private void adjustSizes(List<JComponent> widgets) {
        double w = 0.0;
        double h = 0.0;
        for (JComponent widget : widgets) {
            widget.setPreferredSize(null);
            Dimension wdim = widget.getPreferredSize();
            w = Math.max(w, wdim.getWidth());
            h = Math.max(h, wdim.getHeight());
        }
        Dimension dim = new Dimension();
        dim.setSize(w, h);
        for (JComponent widget : widgets) {
            widget.setPreferredSize(dim);
        }
    }

    public void setStepText(String step) {
        this.step = step;
        if (this.showSteps) {
            SwingThreadDispatcher.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Task.this.finished || Task.this.cancelled || !Task.this.uiShowing) {
                        return;
                    }
                    Task.this.updateTextPane();
                    Task root = Task.this.getRoot();
                    if (root != null) {
                        Task.this.pack(root.progressDialog);
                    }
                }
            });
        }
    }

    public void setProgressStatus(final int percentage) {
        this.percentage = percentage;
        if (this.showProgress) {
            SwingThreadDispatcher.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Task.this.finished || Task.this.cancelled || !Task.this.uiShowing) {
                        return;
                    }
                    int p = percentage < 0 ? 0 : percentage;
                    p = percentage > 100 ? 100 : percentage;
                    Task.this.progressBar.setIndeterminate(false);
                    Task.this.progressBar.setStringPainted(true);
                    Task.this.progressBar.setValue(p);
                    int c = 200 - (int)(200.0 * (double)p / 100.0);
                    int b = 255 - (int)(150.0 * (double)p / 100.0);
                    Task.this.progressBar.setForeground(new Color(c, c, b));
                }
            });
        }
    }

    public void setUnknownStatus() {
        this.statusUnknown = true;
        if (this.showProgress) {
            SwingThreadDispatcher.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (Task.this.finished || Task.this.cancelled || !Task.this.uiShowing) {
                        return;
                    }
                    Task.this.progressBar.setIndeterminate(true);
                    Task.this.progressBar.setStringPainted(false);
                }
            });
        }
    }

    private static String timeFormat(long v) {
        return integerTimeFormatter.format(v);
    }

    private static String secToString(long seconds) {
        if (seconds < 0L) {
            return "-";
        }
        long s = seconds;
        long m = 0L;
        long h = 0L;
        if (s >= 60L) {
            m = (int)s / 60;
            s -= m * 60L;
        }
        if (m < 60L) {
            return " " + Task.timeFormat(m) + ":" + Task.timeFormat(s);
        }
        h = (int)m / 60;
        return " " + Task.timeFormat(h) + ":" + Task.timeFormat(m -= h * 60L) + ":" + Task.timeFormat(s);
    }

    protected int getCancelDelaySecs() {
        return 30;
    }

    public final boolean execute(Window window, String title, String description, int cancelDelayInSecs, int cancelButtonType, boolean showProgress, boolean showSteps) {
        return this.execute(window, title, description, cancelDelayInSecs, cancelButtonType, showProgress, showSteps, null);
    }

    public final boolean execute(Window window, String title, String description) {
        int delay = this.getCancelDelaySecs();
        return this.execute(window, title, description, delay, 1, false, false, null);
    }

    public final boolean execute(Window window, String title, String description, ImageIcon icon) {
        int delay = this.getCancelDelaySecs();
        return this.execute(window, title, description, delay, 1, false, false, icon);
    }

    public final boolean execute(Window window, String title, String description, boolean showProgress, boolean showSteps) {
        int delay = this.getCancelDelaySecs();
        return this.execute(window, title, description, delay, 1, showProgress, showSteps);
    }

    public final boolean execute(Window window, String title, String description, int cancelDelayInSecs, int cancelButtonType) {
        return this.execute(window, title, description, cancelDelayInSecs, cancelButtonType, false, false);
    }

    public final int getProgressDialogDelay() {
        return this.progressDialogDelay;
    }

    public final void setProgressDialogDelay(int progressDialogDelay) {
        this.progressDialogDelay = progressDialogDelay;
    }

    public final void setProgressDialogEnabled(boolean b) {
        this.progressDialogEnabled = b;
    }

    public String getTaskMessage() {
        return this.message;
    }

    protected String[] getAdditionalInfo() {
        return null;
    }

    static {
        attrs = new SimpleAttributeSet[4];
        int i = 0;
        Task.attrs[i] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs[i], "SansSerif");
        StyleConstants.setFontSize(attrs[i], 14);
        Task.attrs[++i] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs[i], "SansSerif");
        StyleConstants.setFontSize(attrs[i], 12);
        Task.attrs[++i] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs[i], "Monospaced");
        StyleConstants.setFontSize(attrs[i], 10);
        Task.attrs[++i] = new SimpleAttributeSet();
        StyleConstants.setFontFamily(attrs[i], "Monospaced");
        StyleConstants.setFontSize(attrs[i], 10);
        ++i;
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ev) {
            List list = Task.this.taskList;
            synchronized (list) {
                Task root = Task.this.getRoot();
                if (root == null) {
                    return;
                }
                boolean cancellingRoot = Task.this == root;
                for (int i = Task.this.taskIndex; i < Task.this.taskList.size(); ++i) {
                    Task task = (Task)Task.this.taskList.get(i);
                    task.cancelTask();
                    try {
                        task.worker.interrupt();
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    if (cancellingRoot || i <= 0) continue;
                    task.removeComponents(root.progressDialog.getContentPane());
                }
                if (cancellingRoot) {
                    root.progressDialog.setVisible(false);
                    root.progressDialog.dispose();
                } else {
                    Task.this.pack(root.progressDialog);
                }
            }
        }
    }
}

