package busexplorer.panel;

import javax.swing.Action;

/**
 * Interface que define aes associadas ao componente {@link TablePanelComponent}.
 * 
 * @author Tecgraf
 * @param <T> Tipo de dado associado ao {@link TablePanelComponent} relacionado a
 *        esta ao.
 */
public interface TablePanelActionInterface<T> extends Action {

  /**
   * Retorna qual o tipo da ao que ser usada no CRUD
   * 
   * @return ADD para aes de adio; EDIT para aes de edio; REMOVE para
   *         aes de remoo; OTHER para outros tipos de aes que no as 3
   *         acima;
   */
  public ActionType getActionType();

  /**
   * Recupera o componente {@link TablePanelComponent}
   * 
   * @return o componente associado a ao.
   */
  public TablePanelComponent<T> getTablePanelComponent();

  /**
   * Recupera o painel associado  ao.
   * 
   * @param panel o componente.
   */
  public void setTablePanelComponent(TablePanelComponent<T> panel);

  /**
   * Indica condies de habilitao da ao.
   *
   * @return condies de habilitao da ao. 
   */
  public boolean abilityConditions();
}
