package busexplorer.panel.logins;

import tecgraf.openbus.core.v2_0.services.access_control.LoginInfo;

import java.util.ArrayList;
import java.util.List;

/**
 * Classe que detm as informaes locais de login para apresentao em tabelas.
 * 
 * @author Tecgraf
 */
public class LoginWrapper {
  /** Informaes do login */
  private LoginInfo info;

  /** Identificador do login */
  private final String id;
  /** Entidade */
  private final String entity;

  /**
   * Construtor.
   * 
   * @param info informaes de login
   */
  public LoginWrapper(LoginInfo info) {
    this.info = info;
    this.id = info.id;
    this.entity = info.entity;
  }

  /**
   * Compara um objeto  instncia de {@link LoginWrapper}.
   *
   * O mtodo no leva em considerao o objeto que contm as informaes de
   * login.
   * 
   * @param o Objeto a ser comparado.
   */
  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof LoginWrapper)) {
      return false;
    }
    LoginWrapper other = (LoginWrapper) o;
    return id.equals(other.id) && entity.equals(other.entity);
  }

  /**
   * Cdigo hash do objeto.
   *
   * @return Cdigo hash do objeto.
   */
  @Override
  public int hashCode() {
    return id.hashCode() ^ entity.hashCode();
  }

  /**
   * Recupera o identificador do login.
   * 
   * @return o nome.
   */
  public String getId() {
    return id;
  }

  /**
   * Recupera o identificador da entidade.
   * 
   * @return o identificador.
   */
  public String getEntityId() {
    return entity;
  }

  /**
   * Recupera a prpria informao de login.
   * 
   * @return a informao de login.
   */
  public LoginInfo getInfo() {
    return info;
  }

  /**
   * Mtodo utilitrio para converter lista de {@link LoginInfo} para
   * {@link LoginWrapper}
   * 
   * @param logins a lista de {@link LoginInfo}
   * @return a lista de {@link LoginWrapper}
   */
  public static List<LoginWrapper> convertToInfo(List<LoginInfo> logins) {
    List<LoginWrapper> list = new ArrayList<LoginWrapper>();
    for (LoginInfo login : logins) {
      list.add(new LoginWrapper(login));
    }
    return list;
  }

}
