/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.entities;

import java.util.ArrayList;
import java.util.List;
import tecgraf.openbus.core.v2_0.services.offer_registry.admin.v1_0.RegisteredEntityDesc;

public class EntityWrapper {
    private RegisteredEntityDesc desc;
    private final String id;
    private String name;
    private final String category;

    public EntityWrapper(RegisteredEntityDesc desc) {
        this.desc = desc;
        this.id = desc.id;
        this.name = desc.name;
        this.category = desc.category.id();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntityWrapper)) {
            return false;
        }
        EntityWrapper other = (EntityWrapper)o;
        return this.id.equals(other.id) && this.name.equals(other.name) && this.category.equals(other.category);
    }

    public int hashCode() {
        return this.id.hashCode() ^ this.name.hashCode() ^ this.category.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public RegisteredEntityDesc getDescriptor() {
        return this.desc;
    }

    public static List<EntityWrapper> convertToInfo(List<RegisteredEntityDesc> entities) {
        ArrayList<EntityWrapper> list = new ArrayList<EntityWrapper>();
        for (RegisteredEntityDesc entity : entities) {
            list.add(new EntityWrapper(entity));
        }
        return list;
    }
}

