/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.categories;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.categories.CategoryWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.EntityCategory;

public class CategoryDeleteAction
extends OpenBusAction<CategoryWrapper> {
    public CategoryDeleteAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(CategoryDeleteAction.class.getSimpleName() + ".name")));
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights() && this.getTablePanelComponent().getSelectedElements().size() == 1;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title"), 0, 3);
        if (option != 0) {
            return;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                CategoryWrapper category = (CategoryWrapper)CategoryDeleteAction.this.getTablePanelComponent().getSelectedElement();
                EntityCategory ref = category.getDescriptor().ref;
                ref.remove();
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    CategoryDeleteAction.this.getTablePanelComponent().removeSelectedElements();
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

