/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.configuration.validators;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.exception.handling.ExceptionHandler;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.configuration.validators.ValidatorWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.admin.BusAdmin;

public class ValidatorRestartAction
extends OpenBusAction<ValidatorWrapper> {
    public ValidatorRestartAction(JFrame parentWindow, BusAdmin admin) {
        super(parentWindow, admin, LNG.get((String)(ValidatorRestartAction.class.getSimpleName() + ".name")));
        this.putValue("ShortDescription", LNG.get((String)(ValidatorRestartAction.class.getSimpleName() + ".tooltip")));
        this.putValue("SmallIcon", ApplicationIcons.ICON_RESTART_16);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.OTHER_SINGLE_SELECTION;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int option = JOptionPane.showConfirmDialog(this.parentWindow, this.getString("confirm.explanation") + "\n" + this.getString("confirm.msg"), this.getString("confirm.title"), 0, 3);
        if (option != 0) {
            return;
        }
        BusExplorerTask<Object> task = new BusExplorerTask<Object>((ExceptionHandler)Application.exceptionHandler(), ExceptionContext.BusCore){

            protected void performTask() throws Exception {
                String validator = ((ValidatorWrapper)ValidatorRestartAction.this.getTablePanelComponent().getSelectedElement()).getValidator();
                ValidatorRestartAction.this.admin.delPasswordValidator(validator);
                ValidatorRestartAction.this.admin.addPasswordValidator(validator);
            }

            protected void afterTaskUI() {
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"));
    }
}

