/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.desktop.dialog.MainDialog;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationTableProvider;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.contracts.ContractTableProvider;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.entities.EntityTableProvider;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.panel.integrations.IntegrationTableProvider;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.logins.LoginTableProvider;
import busexplorer.panel.logins.LoginWrapper;
import busexplorer.panel.offers.OfferTableProvider;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.panel.providers.ProviderTableProvider;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.ConsistencyValidationResult;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.gui.table.ObjectTableModel;

public class ConsistencyValidationDialog
extends BusExplorerAbstractInputDialog {
    private final ConsistencyValidationResult consistencyValidationResult;
    private final DeleteOptions removeFlags;
    private final Runnable delegate;
    private final Class languageEntryClass;
    private JPanel panel;

    public ConsistencyValidationDialog(Window parentWindow, String title, Class languageEntryClass, ConsistencyValidationResult consistencyValidationResult, DeleteOptions removeFlags, Runnable removalDelegate) {
        super(parentWindow, title);
        if (removalDelegate == null) {
            throw new IllegalArgumentException("Removal delegate must be not null");
        }
        this.languageEntryClass = languageEntryClass;
        this.consistencyValidationResult = consistencyValidationResult;
        this.removeFlags = removeFlags;
        this.delegate = removalDelegate;
    }

    private void addCheckListPanel(String title, ObjectTableModel<?> tableModel) {
        if (!tableModel.getRows().isEmpty()) {
            this.panel.add((Component)new JLabel(title), "grow");
            TablePanelComponent pane = new TablePanelComponent(tableModel, new ArrayList(), false);
            pane.setPreferredSize(new Dimension(100, 150));
            this.panel.add(pane, "grow, push, pad 0 10 0 -10");
        }
    }

    private void addAllGovernanceCheckList() {
        ConsistencyValidationResult result = this.consistencyValidationResult;
        this.addCheckListPanel(Language.get(MainDialog.class, "offer.title"), new ObjectTableModel<OfferWrapper>(result.getInconsistentOffers().stream().collect(Collectors.toList()), new OfferTableProvider()));
        this.addCheckListPanel(Language.get(MainDialog.class, "login.title"), new ObjectTableModel<LoginWrapper>(result.getInconsistentLogins().stream().collect(Collectors.toList()), new LoginTableProvider()));
        this.addCheckListPanel(Language.get(MainDialog.class, "entity.title"), new ObjectTableModel<EntityWrapper>(result.getInconsistentEntities().stream().collect(Collectors.toList()), new EntityTableProvider()));
        this.addCheckListPanel(Language.get(MainDialog.class, "authorization.title"), new ObjectTableModel<AuthorizationWrapper>(result.getInconsistentAuthorizations().stream().collect(Collectors.toList()), new AuthorizationTableProvider()));
    }

    private void addAllExtensionCheckList() {
        ConsistencyValidationResult result = this.consistencyValidationResult;
        this.addCheckListPanel(Language.get(MainDialog.class, "integration.title"), new ObjectTableModel<IntegrationWrapper>(new ArrayList<IntegrationWrapper>(result.getInconsistentIntegrations().values()), new IntegrationTableProvider()));
        this.addCheckListPanel(Language.get(MainDialog.class, "extension.provider.title"), new ObjectTableModel<ProviderWrapper>(new ArrayList<ProviderWrapper>(result.getInconsistentProviders().values()), new ProviderTableProvider()));
        this.addCheckListPanel(Language.get(MainDialog.class, "extension.contract.title"), new ObjectTableModel<ContractWrapper>(new ArrayList<ContractWrapper>(result.getInconsistentContracts().values()), new ContractTableProvider()));
    }

    @Override
    protected JScrollPane buildErrorMessagePane() {
        return null;
    }

    @Override
    protected JPanel buildFields() {
        this.setMinimumSize(new Dimension(500, 700));
        this.setPreferredSize(new Dimension(750, 700));
        this.panel = new JPanel(new MigLayout("fill, flowy"));
        this.panel.add((Component)new JLabel(this.getString("consistency.message")), "grow");
        this.panel.add((Component)new JSeparator(0), "grow");
        this.addAllExtensionCheckList();
        this.addAllGovernanceCheckList();
        this.panel.add((Component)new JSeparator(0), "grow");
        this.panel.add((Component)new JLabel(this.getString("options.label")), "grow");
        JRadioButton removeDependenciesOption = new JRadioButton(Language.get(this.languageEntryClass, "consistency.remove.dependencies"));
        removeDependenciesOption.setSelected(false);
        removeDependenciesOption.addItemListener(this.removeFlags.fullyGovernanceRemovalChangeListener);
        JRadioButton removeIndexesOnlyOption = new JRadioButton(Language.get(this.languageEntryClass, "consistency.remove.indexesonly"));
        removeIndexesOnlyOption.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(removeDependenciesOption);
        group.add(removeIndexesOnlyOption);
        this.panel.add((Component)removeDependenciesOption, "grow");
        this.panel.add((Component)removeIndexesOnlyOption, "grow");
        return this.panel;
    }

    @Override
    protected boolean accept() {
        this.delegate.run();
        return true;
    }

    @Override
    protected boolean hasValidFields() {
        return true;
    }

    public static class DeleteOptions {
        private boolean fullyGovernanceRemoval = false;
        public final ItemListener fullyGovernanceRemovalChangeListener = itemEvent -> {
            if (itemEvent.getStateChange() == 1) {
                this.setFullyGovernanceRemoval(true);
            } else {
                this.setFullyGovernanceRemoval(false);
            }
        };

        public boolean isFullyGovernanceRemoval() {
            return this.fullyGovernanceRemoval;
        }

        private void setFullyGovernanceRemoval(boolean fullyGovernanceRemoval) {
            this.fullyGovernanceRemoval = fullyGovernanceRemoval;
        }
    }
}

