/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.japura.gui.Gradient;
import org.japura.gui.TitleBar;

public class TitlePanel
extends JComponent {
    private static final long serialVersionUID = 4L;
    private TitleBar titleBar;
    private JPanel innerPanel;
    private JPanel contentContainer;
    private int separatorThickness = 1;
    private JLabel titleIcon;
    private Component contentView;
    private Color separatorColor = new Color(0, 0, 0, 80);

    public TitlePanel(String title) {
        this(null, title, null);
    }

    public TitlePanel(Icon icon, String title) {
        this(icon, title, null);
    }

    public TitlePanel(String title, JComponent[] titleComponents) {
        this(null, title, titleComponents);
    }

    public TitlePanel(Icon icon, String title, JComponent[] titleComponents) {
        if (icon != null) {
            this.titleIcon = new JLabel(icon);
        }
        this.titleBar = new TitleBar(icon, title, titleComponents);
        this.contentContainer = new JPanel();
        this.contentContainer.setLayout(new BorderLayout());
        this.contentContainer.setBackground(Color.WHITE);
        this.innerPanel = new JPanel();
        this.innerPanel.setBorder(BorderFactory.createLineBorder(this.separatorColor));
        this.innerPanel.setLayout(new MigLayout("ins 0 0 0 0, wrap 1", "grow", "[]0[grow]"));
        this.innerPanel.add((Component)this.titleBar, "grow x");
        this.innerPanel.add((Component)this.contentContainer, "grow");
        super.add(this.innerPanel);
        if (this.titleIcon != null) {
            super.add(this.titleIcon);
        }
        this.setOpaque(false);
        this.updateZOrders();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dim = this.innerPanel.getPreferredSize();
        if (this.titleIcon != null) {
            int iconHeight = this.titleIcon.getPreferredSize().height;
            Insets insets = this.innerPanel.getInsets();
            int yBase = this.getTitleBar().getIconBase().getY();
            int yBaseToTop = yBase + insets.top;
            dim.height += Math.max(0, iconHeight - yBaseToTop);
        }
        return dim;
    }

    public TitleBar getTitleBar() {
        return this.titleBar;
    }

    @Override
    public void doLayout() {
        if (this.titleIcon != null) {
            int outsideIconHeight;
            Insets insets = this.innerPanel.getInsets();
            Dimension titleBarDim = this.getTitleBar().getPreferredSize();
            int iconHeight = this.titleIcon.getPreferredSize().height;
            int yBase = titleBarDim.height - this.getTitleBar().getTitleMargin().bottom;
            int yBaseToTop = yBase + insets.top;
            int y = outsideIconHeight = Math.max(0, iconHeight - yBaseToTop);
            int availableHeight = this.getHeight() - y;
            this.innerPanel.setSize(this.getWidth(), availableHeight);
            this.innerPanel.setLocation(0, y);
            y = y + insets.top + (titleBarDim.height - this.getTitleBar().getTitleMargin().bottom) - iconHeight;
            this.titleIcon.setSize(this.titleIcon.getPreferredSize());
            int x = insets.left + this.titleBar.getTitleMargin().left;
            this.titleIcon.setLocation(x, y);
        } else {
            this.innerPanel.setSize(this.getWidth(), this.getHeight());
            this.innerPanel.setLocation(0, 0);
        }
    }

    @Override
    public final void setBorder(Border border) {
        this.innerPanel.setBorder(border);
    }

    private void updateZOrders() {
        int z = 0;
        if (this.titleIcon != null) {
            this.setComponentZOrder(this.titleIcon, z++);
        }
        this.setComponentZOrder(this.innerPanel, z++);
    }

    public void setSeparatorThickness(int separatorThickness) {
        this.separatorThickness = Math.max(0, separatorThickness);
        this.updateContentContainer();
    }

    public int getSeparatorThickness() {
        return this.separatorThickness;
    }

    @Override
    public void remove(Component comp) {
        if (this.contentView.equals(comp)) {
            this.removeContentView();
        }
    }

    @Override
    public void remove(int index) {
    }

    @Override
    public void removeAll() {
        this.removeContentView();
    }

    private void updateContentContainer() {
        this.contentContainer.removeAll();
        if (this.contentView != null) {
            this.contentContainer.add(this.contentView);
            if (this.getSeparatorThickness() > 0) {
                this.contentContainer.setBorder(BorderFactory.createMatteBorder(this.getSeparatorThickness(), 0, 0, 0, this.getSeparatorColor()));
            } else {
                this.contentContainer.setBorder(null);
            }
        } else {
            this.contentContainer.setBorder(null);
        }
        this.contentContainer.revalidate();
    }

    public void removeContentView() {
        if (this.contentView != null) {
            this.contentView = null;
            this.updateContentContainer();
        }
    }

    public void setContentView(Component component) {
        if (component != null) {
            this.contentView = component;
            this.updateContentContainer();
        }
    }

    @Override
    public Component add(Component comp, int index) {
        this.setContentView(comp);
        return comp;
    }

    @Override
    public void add(Component comp, Object constraints, int index) {
        this.setContentView(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        this.setContentView(comp);
    }

    @Override
    public Component add(Component comp) {
        this.setContentView(comp);
        return comp;
    }

    @Override
    public Component add(String name, Component comp) {
        this.setContentView(comp);
        return comp;
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        if (separatorColor != null) {
            this.separatorColor = separatorColor;
            this.updateContentContainer();
        }
    }

    @Override
    public Font getFont() {
        return this.getTitleBar().getTitleLabel().getFont();
    }

    @Override
    public void setFont(Font font) {
        this.getTitleBar().getTitleLabel().setFont(font);
    }

    public void setTitle(String title) {
        this.getTitleBar().setTitle(title);
    }

    public String getTitle() {
        return this.getTitleBar().getTitle();
    }

    public void setTitleForeground(Color color) {
        this.getTitleBar().setForeground(color);
    }

    public Color getTitleForeground() {
        return this.getTitleBar().getForeground();
    }

    public void setTitleBackground(Color color) {
        this.getTitleBar().setTitleBackground(color);
    }

    public void setTitleBackground(Gradient gradient) {
        this.getTitleBar().setTitleBackground(gradient);
    }

    public Object getTitleBackground() {
        return this.getTitleBar().getTitleBackground();
    }
}

