/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.javautils.gui.crud.demo.descriptor;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import tecgraf.javautils.gui.crud.IRegistrationDescriptor;
import tecgraf.javautils.gui.crud.demo.actions.PlaneDeleteAction;
import tecgraf.javautils.gui.crud.demo.actions.PlaneEditAction;
import tecgraf.javautils.gui.crud.demo.logic.Plane;
import tecgraf.javautils.gui.crud.demo.proxy.PlanesProxy;
import tecgraf.javautils.gui.crud.demo.view.PlaneEditPanel;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationAction;
import tecgraf.javautils.gui.crud.gui.actions.RegistrationAddAction;
import tecgraf.javautils.gui.crud.gui.edition.RegistrationEditionPanel;
import tecgraf.javautils.gui.crud.gui.main.RegistrationMainPanel;

public class PlanesDescriptor
implements IRegistrationDescriptor<Plane, Plane> {
    @Override
    public int getColumnWidth(int i) {
        return i == 0 ? 50 : 150;
    }

    @Override
    public int getNumColumns() {
        return 2;
    }

    @Override
    public int getNumObjects() {
        int num = PlanesProxy.PLANES.size();
        return num;
    }

    @Override
    public Plane getObject(int row) {
        Plane plane = PlanesProxy.PLANES.get(row);
        return plane;
    }

    @Override
    public String getColumnName(int i) {
        return i == 0 ? "Nome" : "Compr.";
    }

    @Override
    public void renderColumn(JLabel label, Plane plane, int column, boolean isSelected) {
        if (column == 0) {
            label.setText(plane.name);
        } else {
            label.setText(plane.lengthMeters + "m");
        }
    }

    @Override
    public boolean delCallback(Plane object) {
        PlanesProxy.PLANES.remove(object);
        return true;
    }

    @Override
    public boolean addCallback(Plane object) {
        PlanesProxy.PLANES.add(object);
        return true;
    }

    @Override
    public Plane toIHCObject(Plane object) {
        return object;
    }

    @Override
    public RegistrationEditionPanel<Plane, Plane> getRegistrationEditPanel(RegistrationMainPanel<Plane, Plane> mainPanel) {
        return new PlaneEditPanel(mainPanel);
    }

    @Override
    public boolean editCallback(Plane oldObject, Plane newObject) {
        oldObject.name = newObject.name;
        oldObject.lengthMeters = newObject.lengthMeters;
        return true;
    }

    @Override
    public List<RegistrationAction<Plane, Plane>> getPopupMenuActions(RegistrationMainPanel<Plane, Plane> mainPanel) {
        ArrayList<RegistrationAction<Plane, Plane>> actions = new ArrayList<RegistrationAction<Plane, Plane>>();
        actions.add(new PlaneDeleteAction(mainPanel));
        actions.add(new PlaneEditAction(mainPanel));
        return actions;
    }

    @Override
    public List<RegistrationAction<Plane, Plane>> getOthersMenuActions(RegistrationMainPanel<Plane, Plane> mainPanel) {
        ArrayList<RegistrationAction<Plane, Plane>> actions = new ArrayList<RegistrationAction<Plane, Plane>>();
        actions.add(new PlaneEditAction(mainPanel));
        return actions;
    }

    @Override
    public Class<?> getColumnClass() {
        return Object.class;
    }

    @Override
    public List<RegistrationAction<Plane, Plane>> getToolbarActions(RegistrationMainPanel<Plane, Plane> mainPanel) {
        ArrayList<RegistrationAction<Plane, Plane>> actions = new ArrayList<RegistrationAction<Plane, Plane>>();
        actions.add(new RegistrationAddAction<Plane, Plane>(mainPanel));
        actions.add(new PlaneEditAction(mainPanel));
        actions.add(new PlaneDeleteAction(mainPanel));
        return actions;
    }
}

