/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.security;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import tecgraf.openbus.exception.CryptographyException;

public final class Cryptography {
    private static final String CERT_FACTORY = "X.509";
    private static final String HASH_ALGORITHM = "SHA-256";
    private static final String KEY_FACTORY = "RSA";
    public static final String CIPHER_ALGORITHM = "RSA/ECB/PKCS1PADDING";
    private static final int ENCRIPTION_KEY_SIZE = 256;
    private static final int MAX_BLOCK_ENCRIPTION_SIZE = 245;
    public static final Charset CHARSET = Charset.forName("US-ASCII");
    private static Cryptography instance;

    private Cryptography() {
    }

    public static synchronized Cryptography getInstance() {
        if (instance == null) {
            instance = new Cryptography();
        }
        return instance;
    }

    public byte[] encrypt(byte[] data, X509Certificate certificate) throws CryptographyException {
        return this.encrypt(data, (RSAPublicKey)certificate.getPublicKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] encrypt(byte[] data, RSAPublicKey publicKey) throws CryptographyException {
        try {
            Cipher cipher;
            Cipher cipher2 = cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            synchronized (cipher2) {
                cipher.init(1, publicKey);
                int blocks = (int)Math.ceil((double)data.length / 245.0);
                int lenght = 245;
                ByteBuffer buffer = ByteBuffer.allocate(256 * blocks);
                for (int offset = 0; offset < data.length; offset += lenght) {
                    if (offset + lenght > data.length) {
                        lenght = data.length - offset;
                    }
                    buffer.put(cipher.doFinal(data, offset, lenght));
                }
                return buffer.array();
            }
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] decrypt(byte[] data, RSAPrivateKey privateKey) throws CryptographyException {
        try {
            Cipher cipher;
            Cipher cipher2 = cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            synchronized (cipher2) {
                cipher.init(2, privateKey);
                return cipher.doFinal(data);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPublicKey generateRSAPublicKeyFromX509EncodedKey(byte[] encodedKey) throws CryptographyException {
        X509EncodedKeySpec encodedKeySpec = new X509EncodedKeySpec(encodedKey);
        try {
            KeyFactory keyFactory;
            KeyFactory keyFactory2 = keyFactory = KeyFactory.getInstance(KEY_FACTORY);
            synchronized (keyFactory2) {
                return (RSAPublicKey)keyFactory.generatePublic(encodedKeySpec);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair generateRSAKeyPair() throws CryptographyException {
        try {
            KeyPairGenerator keyPairGenerator;
            KeyPairGenerator keyPairGenerator2 = keyPairGenerator = KeyPairGenerator.getInstance(KEY_FACTORY);
            synchronized (keyPairGenerator2) {
                keyPairGenerator.initialize(2048, new SecureRandom());
                return keyPairGenerator.genKeyPair();
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] generateHash(byte[] data) throws CryptographyException {
        try {
            MessageDigest digest;
            MessageDigest messageDigest = digest = MessageDigest.getInstance(HASH_ALGORITHM);
            synchronized (messageDigest) {
                return digest.digest(data);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    public MessageDigest getHashAlgorithm() throws CryptographyException {
        try {
            return MessageDigest.getInstance(HASH_ALGORITHM);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    public RSAPrivateKey readKeyFromFile(String privateKeyFileName) throws IOException, InvalidKeySpecException, CryptographyException {
        try (FileInputStream fis = new FileInputStream(privateKeyFileName);){
            FileChannel channel = fis.getChannel();
            ByteBuffer buffer = ByteBuffer.allocate((int)channel.size());
            int size = channel.read(buffer);
            if (size != (int)channel.size()) {
                throw new IOException("N\u00e3o foi poss\u00edvel ler todo o arquivo.");
            }
            RSAPrivateKey rSAPrivateKey = this.readKeyFromBytes(buffer.array());
            return rSAPrivateKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RSAPrivateKey readKeyFromBytes(byte[] privateKeyBytes) throws InvalidKeySpecException, CryptographyException {
        PKCS8EncodedKeySpec encodedKey = new PKCS8EncodedKeySpec(privateKeyBytes);
        try {
            KeyFactory kf;
            KeyFactory keyFactory = kf = KeyFactory.getInstance(KEY_FACTORY);
            synchronized (keyFactory) {
                return (RSAPrivateKey)kf.generatePrivate(encodedKey);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KeyPair readKeyPairFromFile(String path) throws InvalidKeySpecException, CryptographyException, IOException {
        try {
            KeyFactory kf;
            RSAPrivateCrtKey privKey = (RSAPrivateCrtKey)this.readKeyFromFile(path);
            KeyFactory keyFactory = kf = KeyFactory.getInstance(KEY_FACTORY);
            synchronized (keyFactory) {
                RSAPublicKey pubKey = (RSAPublicKey)kf.generatePublic(new RSAPublicKeySpec(privKey.getModulus(), privKey.getPublicExponent()));
                return new KeyPair(pubKey, privKey);
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean verifySignature(RSAPublicKey publicKey, byte[] rawData, byte[] signedData) throws CryptographyException {
        try {
            Signature sign;
            Signature signature = sign = Signature.getInstance("NONEwithRSA");
            synchronized (signature) {
                sign.initVerify(publicKey);
                byte[] hashData = this.generateHash(rawData);
                sign.update(hashData);
                return sign.verify(signedData);
            }
        }
        catch (GeneralSecurityException e) {
            throw new CryptographyException(e);
        }
    }

    public X509Certificate readX509Certificate(String certificateFile) throws CryptographyException, IOException {
        return this.readX509Certificate(new FileInputStream(certificateFile));
    }

    public X509Certificate readX509Certificate(InputStream inputStream) throws CryptographyException, IOException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance(CERT_FACTORY);
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (CertificateException e) {
            throw new CryptographyException(e);
        }
        finally {
            inputStream.close();
        }
    }

    public X509Certificate readX509Certificate(byte[] encoded) throws CryptographyException, IOException {
        ByteArrayInputStream stream = new ByteArrayInputStream(encoded);
        return this.readX509Certificate(stream);
    }
}

