/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.configuration.admins;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.configuration.admins.AdminWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.admin.BusAdminFacade;

public class AdminInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel adminNameLabel;
    private JTextField adminNameField;
    private TablePanelComponent<AdminWrapper> panel;
    private AdminWrapper editingAdministrator = null;

    public AdminInputDialog(Window parentWindow, TablePanelComponent<AdminWrapper> panel) {
        super(parentWindow);
        this.panel = panel;
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        final ArrayList<String> grantTo = new ArrayList<String>();
        grantTo.add(this.adminNameField.getText());
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                BusAdminFacade admin = Application.login().admin;
                if (AdminInputDialog.this.editingAdministrator == null) {
                    admin.grantAdminTo(grantTo);
                } else {
                    ArrayList<String> revokeFrom = new ArrayList<String>();
                    revokeFrom.add(AdminInputDialog.this.editingAdministrator.getAdmin());
                    admin.grantAdminTo(grantTo);
                    admin.revokeAdminFrom(revokeFrom);
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    AdminInputDialog.this.panel.refresh(null);
                    AdminInputDialog.this.panel.selectElement(new AdminWrapper(AdminInputDialog.this.adminNameField.getText()), true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(330, 180));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.adminNameLabel = new JLabel(Language.get(this.getClass(), "adminName.label"));
        panel.add((Component)this.adminNameLabel, "grow");
        this.adminNameField = new JTextField(30);
        this.adminNameField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (AdminInputDialog.this.adminNameField.getText().trim().isEmpty()) {
                    AdminInputDialog.this.setErrorMessage(Language.get(AdminInputDialog.class, "error.validation.emptyID"));
                } else {
                    AdminInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.adminNameField, "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.adminNameField.getText().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.emptyID"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(AdminWrapper info) {
        this.editingAdministrator = info;
        this.adminNameField.setText(info.getAdmin());
    }
}

