/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.consumers;

import busexplorer.Application;
import busexplorer.desktop.dialog.ConsistencyValidationDialog;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.consumers.ConsumerWrapper;
import busexplorer.panel.entities.EntityWrapper;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.logins.LoginWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import busexplorer.utils.ConsistencyValidationResult;
import busexplorer.utils.Language;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;
import tecgraf.openbus.services.governance.v1_0.Consumer;
import tecgraf.openbus.services.governance.v1_0.Integration;

public class ConsumerDeleteAction
extends OpenBusAction<ConsumerWrapper> {
    public ConsumerDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        ConsistencyValidationDialog.DeleteOptions removeFlags = new ConsistencyValidationDialog.DeleteOptions();
        ConsistencyValidationResult consistencyValidationResult = new ConsistencyValidationResult();
        List<ConsumerWrapper> consumers = this.getTablePanelComponent().getSelectedElements();
        BusExplorerTask<Void> deleteConsumerTask = ConsumerDeleteAction.DeleteConsumerTask(consumers, this.getTablePanelComponent()::removeSelectedElements, removeFlags, consistencyValidationResult);
        Runnable effectiveDeletion = () -> deleteConsumerTask.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
        if (ConsumerDeleteAction.ExecuteAllDependencyCheckTasks(this.parentWindow, consumers, consistencyValidationResult)) {
            if (consistencyValidationResult.isEmpty()) {
                effectiveDeletion.run();
            } else {
                new ConsistencyValidationDialog(this.parentWindow, this.getString("confirm.title"), this.getClass(), consistencyValidationResult, removeFlags, effectiveDeletion).showDialog();
            }
        }
    }

    public static boolean ExecuteAllDependencyCheckTasks(Window parentWindow, Collection<ConsumerWrapper> consumers, ConsistencyValidationResult consistencyValidationResult) {
        String title = Language.get(ConsistencyValidationDialog.class, "waiting.dependency.title");
        String waitingMessage = Language.get(ConsumerDeleteAction.class, "waiting.dependency.msg");
        BusExplorerTask<Void> extensionDependencyCheckTask = ConsumerDeleteAction.ExtensionDependencyCheckTask(consumers, consistencyValidationResult);
        BusExplorerTask<Void> governanceDependencyCheckTask = ConsumerDeleteAction.GovernanceDependencyCheckTask(consumers, consistencyValidationResult);
        extensionDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        governanceDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        return extensionDependencyCheckTask.getStatus() && governanceDependencyCheckTask.getStatus();
    }

    public static BusExplorerTask<Void> GovernanceDependencyCheckTask(final Collection<ConsumerWrapper> consumers, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                for (ConsumerWrapper consumer : consumers) {
                    BusQuery busQuery = new BusQuery(consumer.busquery());
                    for (RegisteredEntityDesc entity : busQuery.filterEntities()) {
                        consistencyValidationResult.getInconsistentEntities().add(new EntityWrapper(entity));
                        for (LoginInfo login : Application.login().admin.getLogins()) {
                            if (!login.entity.equals(entity.id)) continue;
                            consistencyValidationResult.getInconsistentLogins().add(new LoginWrapper(login));
                        }
                    }
                    this.setProgressStatus(100 * i / consumers.size());
                    ++i;
                }
            }
        };
    }

    public static BusExplorerTask<Void> ExtensionDependencyCheckTask(final Collection<ConsumerWrapper> consumers, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                for (ConsumerWrapper consumer : consumers) {
                    String consumerName = consumer.remote().name();
                    for (Integration integration : Application.login().extension.getIntegrationRegistry().integrations()) {
                        Consumer c = integration.consumer();
                        if (c == null || !c.name().equals(consumerName)) continue;
                        consistencyValidationResult.getInconsistentIntegrations().put(integration.id(), new IntegrationWrapper(integration));
                    }
                    this.setProgressStatus(100 * i / consumers.size());
                    ++i;
                }
            }
        };
    }

    public static BusExplorerTask<Void> DeleteConsumerTask(final Collection<ConsumerWrapper> consumers, final Runnable delegateAfterTaskUI, final ConsistencyValidationDialog.DeleteOptions removeFlags, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                if (removeFlags.isFullyGovernanceRemoval()) {
                    for (Integer id : consistencyValidationResult.getInconsistentIntegrations().keySet()) {
                        Application.login().extension.getIntegrationRegistry().remove(id.intValue());
                    }
                }
                for (ConsumerWrapper consumer : consumers) {
                    if (removeFlags.isFullyGovernanceRemoval()) {
                        BusQuery busQuery = new BusQuery(consumer.busquery());
                        for (RegisteredEntityDesc entityDesc : busQuery.filterEntities()) {
                            for (LoginInfo login : Application.login().admin.getLogins()) {
                                if (!entityDesc.id.equals(login.entity)) continue;
                                Application.login().admin.invalidateLogin(login);
                                Application.login().admin.removeCertificate(login.entity);
                            }
                            Application.login().admin.removeCertificate(entityDesc.id);
                            entityDesc.ref.remove();
                        }
                    }
                    Application.login().extension.getConsumerRegistry().remove(consumer.name());
                    this.setProgressStatus(100 * i / consumers.size());
                    ++i;
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus() && delegateAfterTaskUI != null) {
                    delegateAfterTaskUI.run();
                }
            }
        };
    }
}

