/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.providers;

import busexplorer.Application;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.providers.ProviderInputDialog;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JFrame;

public class ProviderEditAction
extends OpenBusAction<ProviderWrapper> {
    public ProviderEditAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.EDIT;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        BusExplorerTask<List<ContractWrapper>> task = new BusExplorerTask<List<ContractWrapper>>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setResult(ContractWrapper.convertToInfo(Application.login().extension.getContracts()));
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    ProviderInputDialog dialog = new ProviderInputDialog(ProviderEditAction.this.parentWindow, ProviderEditAction.this.getTablePanelComponent(), (List)this.getResult());
                    dialog.showDialog();
                    ProviderWrapper entity = (ProviderWrapper)ProviderEditAction.this.getTablePanelComponent().getSelectedElement();
                    dialog.setEditionMode(entity);
                }
            }
        };
        task.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0);
    }
}

