/*
 * Decompiled with CFR 0.152.
 */
package busexplorer;

import busexplorer.BusExplorerLogin;
import busexplorer.desktop.dialog.LoginDialog;
import busexplorer.desktop.dialog.MainDialog;
import busexplorer.exception.BusExplorerExceptionHandler;
import busexplorer.utils.Language;
import java.awt.Color;
import java.awt.Window;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Properties;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import tecgraf.javautils.core.lng.LNG;

public class Application {
    private static BusExplorerExceptionHandler handler = new BusExplorerExceptionHandler();
    private static BusExplorerLogin login;
    private static PropertyChangeSupport propertyChangeSupport;
    public static final String APPLICATION_LOGIN = "Application.login";

    public static void main(String[] args) {
        final Properties properties = new Properties();
        try {
            InputStream in = MainDialog.class.getResourceAsStream("/busexplorer/resources/client.properties");
            properties.load(in);
            in.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, Language.get(MainDialog.class, "error.properties.file"), Language.get(MainDialog.class, "error.properties.title"), 0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainDialog mainDialog = new MainDialog(properties);
                mainDialog.setVisible(true);
                propertyChangeSupport = new PropertyChangeSupport(this);
                propertyChangeSupport.addPropertyChangeListener(mainDialog);
                Application.showLoginDialog(mainDialog);
            }
        });
    }

    public static void showLoginDialog(MainDialog mainDialog) {
        BusExplorerLogin oldLogin = login;
        login = null;
        LoginDialog loginDialog = new LoginDialog((Window)mainDialog);
        loginDialog.setVisible(true);
        login = loginDialog.getLogin();
        propertyChangeSupport.firePropertyChange(APPLICATION_LOGIN, oldLogin, login);
    }

    public static BusExplorerExceptionHandler exceptionHandler() {
        return handler;
    }

    public static BusExplorerLogin login() {
        return login;
    }

    public static String[] version() {
        String versionString = Language.get(Application.class, "version");
        int delimiter = versionString.indexOf("-");
        String[] version = new String[]{versionString.substring(0, delimiter), versionString.substring(delimiter + 1)};
        return version;
    }

    static {
        LNG.load("busadminlib.resources.language.idiom", new Locale("pt", "BR"));
        LNG.load("busexplorer.resources.language.idiom", new Locale("pt", "BR"));
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        LookAndFeel javaRuntimeDefault = UIManager.getLookAndFeel();
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            }
            catch (Exception e1) {
                try {
                    UIManager.setLookAndFeel(javaRuntimeDefault);
                }
                catch (UnsupportedLookAndFeelException e2) {
                    e2.printStackTrace();
                }
            }
        }
        Color disabledTextColor = UIManager.getColor("TabbedPane.disabledText") != null ? UIManager.getColor("TabbedPane.disabledText") : UIManager.getColor("Label.disabledForeground");
        UIManager.put("TabbedPane.disabledText", new Color(disabledTextColor.getRGB()));
    }
}

