/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.contracts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import tecgraf.openbus.services.governance.v1_0.Contract;

public class ContractWrapper {
    private final Contract remote;
    private String name;
    private List<String> interfaces;

    public ContractWrapper(Contract remote) {
        this.remote = remote;
        this.name = remote.name();
        this.interfaces = new ArrayList<String>(Arrays.asList(remote.interfaces()));
    }

    public String name() {
        return this.name;
    }

    public List<String> interfaces() {
        return Collections.unmodifiableList(this.interfaces);
    }

    public void interfaces(List<String> updated) {
        for (String iface : updated) {
            if (this.interfaces.contains(iface)) continue;
            this.remote.addInterface(iface);
            this.interfaces.add(iface);
        }
        ListIterator<String> iterator = this.interfaces.listIterator();
        while (iterator.hasNext()) {
            String iface;
            iface = iterator.next();
            if (updated.contains(iface)) continue;
            this.remote.removeInterface(iface);
            iterator.remove();
        }
    }

    public Contract remote() {
        return this.remote;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContractWrapper)) {
            return false;
        }
        ContractWrapper other = (ContractWrapper)o;
        return this.name.equals(other.name);
    }

    public static List<ContractWrapper> convertToInfo(List<Contract> contracts) {
        ArrayList<ContractWrapper> list = new ArrayList<ContractWrapper>();
        for (Contract contract : contracts) {
            list.add(new ContractWrapper(contract));
        }
        return list;
    }
}

