/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RequestQueueListener;
import org.jacorb.poa.except.ResourceLimitReachedException;
import org.jacorb.poa.util.StringPair;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.slf4j.Logger;

public class RequestQueue
implements Configurable {
    private RequestQueueListener queueListener;
    private Configuration configuration = null;
    private Logger logger;
    private int queueMin;
    private int queueMax;
    private boolean queueWait;
    private boolean configured = false;
    private final LinkedList<ServerRequest> queue = new LinkedList();

    @Override
    public synchronized void configure(Configuration myConfiguration) throws ConfigurationException {
        if (this.configured) {
            return;
        }
        this.configuration = myConfiguration;
        this.logger = this.configuration.getLogger("org.jacorb.poa.queue");
        this.queueMax = this.configuration.getAttributeAsInteger("jacorb.poa.queue_max", 100);
        this.queueMin = this.configuration.getAttributeAsInteger("jacorb.poa.queue_min", 10);
        this.queueWait = this.configuration.getAttributeAsBoolean("jacorb.poa.queue_wait", false);
        this.configured = true;
        List<String> queueListeners = this.configuration.getAttributeList("jacorb.poa.queue_listeners");
        for (String className : queueListeners) {
            try {
                RequestQueueListener rql = (RequestQueueListener)ObjectUtil.classForName(className).newInstance();
                this.addRequestQueueListener(rql);
            }
            catch (Exception ex) {
                throw new ConfigurationException("could not instantiate queue listener", ex);
            }
        }
    }

    protected synchronized void add(ServerRequest request) throws ResourceLimitReachedException {
        this.checkIsConfigured();
        if (this.queueMax > 0 && this.queue.size() >= this.queueMax) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Request queue is full, consider increasing jacorb.poa.queue_max (currently: " + this.queueMax + ")");
            }
            if (this.queueWait) {
                while (this.queue.size() > this.queueMin) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            } else {
                throw new ResourceLimitReachedException();
            }
        }
        this.queue.add(request);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("rid: " + request.requestId() + " opname: " + request.operation() + " is queued (queue size: " + this.queue.size() + ")");
        }
        if (this.queueListener != null) {
            this.queueListener.requestAddedToQueue(request, this.queue.size());
        }
    }

    protected synchronized void addRequestQueueListener(RequestQueueListener listener) {
        this.checkIsConfigured();
        this.queueListener = EventMulticaster.add(this.queueListener, listener);
    }

    protected synchronized StringPair[] deliverContent() {
        this.checkIsConfigured();
        StringPair[] result = new StringPair[this.queue.size()];
        Iterator en = this.queue.iterator();
        for (int i = 0; i < result.length; ++i) {
            ServerRequest sr = (ServerRequest)en.next();
            result[i] = new StringPair(Integer.toString(sr.requestId()), new String(sr.objectId()));
        }
        return result;
    }

    synchronized ServerRequest getElementAndRemove(int rid) {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            Iterator en = this.queue.iterator();
            while (en.hasNext()) {
                ServerRequest result = (ServerRequest)en.next();
                if (result.requestId() != rid) continue;
                en.remove();
                this.notifyAll();
                if (this.queueListener != null) {
                    this.queueListener.requestRemovedFromQueue(result, this.queue.size());
                }
                return result;
            }
        }
        return null;
    }

    protected synchronized ServerRequest getFirst() {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            return this.queue.getFirst();
        }
        return null;
    }

    protected boolean isEmpty() {
        this.checkIsConfigured();
        return this.queue.isEmpty();
    }

    protected synchronized ServerRequest removeFirst() {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            ServerRequest result = this.queue.removeFirst();
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(result, this.queue.size());
            }
            return result;
        }
        return null;
    }

    protected synchronized ServerRequest removeLast() {
        this.checkIsConfigured();
        if (!this.queue.isEmpty()) {
            ServerRequest result = this.queue.removeLast();
            this.notifyAll();
            if (this.queueListener != null) {
                this.queueListener.requestRemovedFromQueue(result, this.queue.size());
            }
            return result;
        }
        return null;
    }

    protected synchronized void removeRequestQueueListener(RequestQueueListener listener) {
        this.checkIsConfigured();
        this.queueListener = EventMulticaster.remove(this.queueListener, listener);
    }

    protected int size() {
        return this.queue.size();
    }

    private void checkIsConfigured() {
        if (!this.configured) {
            throw new BAD_INV_ORDER("RequestQueue is not configured yet.");
        }
    }
}

