/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.sas;

import java.util.Hashtable;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.Delegate;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.portableInterceptor.ORBInitInfoImpl;
import org.jacorb.orb.portableInterceptor.ServerRequestInfoImpl;
import org.jacorb.sasPolicy.ATLASPolicy;
import org.jacorb.sasPolicy.ATLASPolicyValues;
import org.jacorb.sasPolicy.SASPolicy;
import org.jacorb.sasPolicy.SASPolicyValues;
import org.jacorb.security.sas.ISASContext;
import org.jacorb.security.sas.SASInitializer;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.Policy;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CSI.CompleteEstablishContext;
import org.omg.CSI.ContextError;
import org.omg.CSI.EstablishContext;
import org.omg.CSI.MessageInContext;
import org.omg.CSI.SASContextBody;
import org.omg.CSI.SASContextBodyHelper;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecFactoryPackage.UnknownEncoding;
import org.omg.IOP.Encoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ServerRequestInfo;
import org.omg.PortableInterceptor.ServerRequestInterceptor;
import org.slf4j.Logger;

public class SASTargetInterceptor
extends LocalObject
implements ServerRequestInterceptor,
Configurable {
    private static final String name = "SASTargetInterceptor";
    private Logger logger = null;
    protected ORB orb = null;
    protected Codec codec = null;
    protected int sasReplySlotID = -1;
    protected int clientUserNameSlotID = -1;
    protected int sasContextsCubby = -1;
    protected boolean useSsl = false;
    protected ISASContext sasContext = null;

    public SASTargetInterceptor(ORBInitInfo info) throws UnknownEncoding, ConfigurationException {
        this.sasReplySlotID = info.allocate_slot_id();
        this.sasContextsCubby = GIOPConnection.allocate_cubby_id();
        Encoding encoding = new Encoding(0, 1, 0);
        this.codec = info.codec_factory().create_codec(encoding);
        this.orb = ((ORBInitInfoImpl)info).getORB();
        this.configure(this.orb.getConfiguration());
    }

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        this.logger = configuration.getLogger("org.jacorb.security.sas.TSS.log.verbosity");
        this.useSsl = configuration.getAttribute("jacorb.security.sas.tss.requires_sas", "false").equals("true");
        String contextClass = null;
        try {
            contextClass = configuration.getAttribute("jacorb.security.sas.contextClass");
            Class<?> c = ObjectUtil.classForName(contextClass);
            this.sasContext = (ISASContext)c.newInstance();
        }
        catch (IllegalArgumentException e) {
            this.logger.error("Caught ", e);
            throw new ConfigurationException("Could not load SAS context class " + contextClass);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Caught ", e);
            throw new ConfigurationException("Could not load SAS context class " + contextClass);
        }
        catch (InstantiationException e) {
            this.logger.error("Caught ", e);
            throw new ConfigurationException("Could not load SAS context class " + contextClass);
        }
        catch (IllegalAccessException e) {
            this.logger.error("Caught ", e);
            throw new ConfigurationException("Could not load SAS context class " + contextClass);
        }
        this.sasContext.configure(configuration);
        this.sasContext.initTarget();
    }

    @Override
    public String name() {
        return name;
    }

    @Override
    public void destroy() {
    }

    @Override
    public void receive_request_service_contexts(ServerRequestInfo sri) throws ForwardRequest {
        ServerRequestInfoImpl ri = (ServerRequestInfoImpl)sri;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("receive_request_service_contexts for " + ri.operation());
        }
        Policy targetSasPolicy = null;
        try {
            targetSasPolicy = ri.get_server_policy(102);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (targetSasPolicy == null) {
            return;
        }
        if (this.sasContext == null || ri.isLocalInterceptor()) {
            return;
        }
        GIOPConnection connection = ri.getConnection();
        if (this.useSsl && !connection.isSSL()) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("SSL required for operation " + ri.operation());
            }
            throw new NO_PERMISSION("SSL Required!", 1245904899, CompletionStatus.COMPLETED_NO);
        }
        SASContextBody contextBody = null;
        long client_context_id = 0L;
        byte[] contextToken = null;
        try {
            ServiceContext ctx = ri.get_request_service_context(15);
            Any ctx_any = this.codec.decode_value(ctx.context_data, SASContextBodyHelper.type());
            contextBody = SASContextBodyHelper.extract(ctx_any);
        }
        catch (BAD_PARAM e) {
        }
        catch (Exception e) {
            if (this.logger.isWarnEnabled()) {
                this.logger.warn("Could not parse service context: ", e);
            }
            this.makeContextError(ri, client_context_id, 1, 1, new byte[0]);
            throw new NO_PERMISSION("Could not parse service context: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
        }
        if (contextBody == null) {
            return;
        }
        if (contextBody.discriminator() == 5) {
            MessageInContext msg = null;
            try {
                msg = contextBody.in_context_msg();
                client_context_id = msg.client_context_id;
                contextToken = this.getSASContext(connection, msg.client_context_id);
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not parse service MessageInContext " + ri.operation() + ": " + e);
                }
                this.makeContextError(ri, client_context_id, 1, 1, new byte[0]);
                throw new NO_PERMISSION("SAS Error parsing MessageInContext: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (contextToken == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Invalid context in MessageInContext " + ri.operation() + ": " + msg.client_context_id);
                }
                this.makeContextError(ri, client_context_id, 2, 1, new byte[0]);
                throw new NO_PERMISSION("SAS Invalid context in MessageInContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
        }
        String principalName = null;
        if (contextBody.discriminator() == 0) {
            EstablishContext msg = null;
            try {
                msg = contextBody.establish_msg();
                client_context_id = msg.client_context_id;
                contextToken = msg.client_authentication_token;
                if (!this.sasContext.validateContext(this.orb, this.codec, contextToken)) {
                    this.logger.info("Could not validate context EstablishContext " + ri.operation());
                    this.makeContextError(ri, client_context_id, 1, 1, contextToken);
                    throw new NO_PERMISSION("SAS Error validating context", 1245904899, CompletionStatus.COMPLETED_NO);
                }
                principalName = this.sasContext.getValidatedPrincipal();
            }
            catch (NO_PERMISSION e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Err " + ri.operation() + ": " + e);
                }
                this.makeContextError(ri, client_context_id, 1, 1, contextToken);
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not parse service EstablishContext " + ri.operation() + ": " + e);
                }
                this.makeContextError(ri, client_context_id, 1, 1, contextToken);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (contextToken == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not parse service EstablishContext " + ri.operation() + ": " + msg.client_context_id);
                }
                this.makeContextError(ri, client_context_id, 1, 1, contextToken);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
        }
        try {
            Any nameAny = this.orb.create_any();
            if (principalName == null) {
                principalName = this.getSASContextPrincipalName(connection, client_context_id);
            }
            nameAny.insert_string(principalName);
            ri.set_slot(SASInitializer.sasPrincipalNamePIC, nameAny);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error inserting service context into slots for " + ri.operation() + ": " + e);
            }
            this.makeContextError(ri, client_context_id, 1, 1, contextToken);
            throw new NO_PERMISSION("SAS Error insert service context into slots: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public void receive_request(ServerRequestInfo sri) throws ForwardRequest {
        IDLEntity msg;
        byte[] contextToken;
        long client_context_id;
        SASContextBody contextBody;
        SASPolicyValues sasValues;
        GIOPConnection connection;
        ServerRequestInfoImpl ri;
        block42: {
            ri = (ServerRequestInfoImpl)sri;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("receive_request for " + ri.operation());
            }
            if (this.sasContext == null || ri.isLocalInterceptor()) {
                return;
            }
            connection = ri.getConnection();
            sasValues = null;
            try {
                ObjectImpl oi = (ObjectImpl)ri.target();
                Delegate d = (Delegate)oi._get_delegate();
                SASPolicy policy = (SASPolicy)d.getPOA().getPolicy(102);
                if (policy != null) {
                    sasValues = policy.value();
                }
            }
            catch (BAD_PARAM e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No SAS Policy for " + ri.operation());
                }
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error fetching SAS policy for " + ri.operation() + ": " + e);
                }
                throw new NO_PERMISSION("Error fetching SAS policy: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (sasValues == null) {
                return;
            }
            if (sasValues.targetRequires == 0 && sasValues.targetSupports == 0) {
                return;
            }
            ATLASPolicyValues atlasValues = null;
            try {
                ObjectImpl oi = (ObjectImpl)ri.target();
                Delegate d = (Delegate)oi._get_delegate();
                ATLASPolicy policy = (ATLASPolicy)d.getPOA().getPolicy(103);
                if (policy != null) {
                    atlasValues = policy.value();
                }
            }
            catch (BAD_PARAM e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("No ATLAS Policy for " + ri.operation());
                }
            }
            catch (Exception e) {
                if (this.logger.isWarnEnabled()) {
                    this.logger.warn("Error fetching ATLAS policy for " + ri.operation() + ": " + e);
                }
                throw new NO_PERMISSION("Error fetching ATLAS policy: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            contextBody = null;
            client_context_id = 0L;
            contextToken = null;
            try {
                ServiceContext ctx = ri.get_request_service_context(15);
                Any ctx_any = this.codec.decode_value(ctx.context_data, SASContextBodyHelper.type());
                contextBody = SASContextBodyHelper.extract(ctx_any);
            }
            catch (BAD_PARAM e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Could not parse service context for operation " + ri.operation());
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block42;
                this.logger.warn("Could not parse service context for operation " + ri.operation() + ": " + e);
            }
        }
        if (contextBody == null && (sasValues.targetRequires & 0x40) != 0 && !ri.operation().equals("_non_existent") && !ri.operation().equals("_is_a")) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Did not parse service context for operation " + ri.operation());
            }
            throw new NO_PERMISSION("No SAS service context found", 1245904899, CompletionStatus.COMPLETED_NO);
        }
        if (contextBody == null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("No context found, but not required");
            }
            return;
        }
        if (contextBody.discriminator() == 5) {
            msg = null;
            try {
                msg = contextBody.in_context_msg();
                client_context_id = msg.client_context_id;
                contextToken = this.getSASContext(connection, msg.client_context_id);
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not parse service MessageInContext " + ri.operation() + ": " + e);
                }
                this.makeContextError(ri, client_context_id, 1, 1, contextToken);
                throw new NO_PERMISSION("SAS Error parsing MessageInContext: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (contextToken == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not find context in MessageInContext " + ri.operation() + ": " + msg.client_context_id);
                }
                this.makeContextError(ri, client_context_id, 2, 1, contextToken);
                throw new NO_PERMISSION("SAS Error invalid context in MessageInContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
        }
        if (contextBody.discriminator() == 0) {
            msg = null;
            String principalName = null;
            try {
                msg = contextBody.establish_msg();
                client_context_id = ((EstablishContext)msg).client_context_id;
                contextToken = ((EstablishContext)msg).client_authentication_token;
                principalName = this.sasContext.getValidatedPrincipal();
            }
            catch (NO_PERMISSION e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Err " + ri.operation() + ": " + e);
                }
                this.makeContextError(ri, client_context_id, 1, 1, contextToken);
                throw e;
            }
            catch (Exception e) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not parse service EstablishContext " + ri.operation() + ": " + e);
                }
                this.makeContextError(ri, client_context_id, 2, 1, contextToken);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (contextToken == null) {
                if (this.logger.isErrorEnabled()) {
                    this.logger.error("Could not parse service EstablishContext " + ri.operation() + ": " + ((EstablishContext)msg).client_context_id);
                }
                this.makeContextError(ri, client_context_id, 2, 1, contextToken);
                throw new NO_PERMISSION("SAS Error parsing EstablishContext", 1245904899, CompletionStatus.COMPLETED_NO);
            }
            if (sasValues.stateful) {
                this.cacheSASContext(connection, ((EstablishContext)msg).client_context_id, contextToken, principalName);
            }
        }
        try {
            this.makeCompleteEstablishContext(ri, client_context_id, sasValues);
        }
        catch (Exception e) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Error inserting service context into slots for " + ri.operation() + ": " + e);
            }
            this.makeContextError(ri, client_context_id, 1, 1, contextToken);
            throw new NO_PERMISSION("SAS Error insert service context into slots: " + e, 1245904899, CompletionStatus.COMPLETED_NO);
        }
    }

    @Override
    public void send_reply(ServerRequestInfo ri) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("send_reply for " + ri.operation());
        }
    }

    @Override
    public void send_exception(ServerRequestInfo ri) throws ForwardRequest {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("send_exception for " + ri.operation());
        }
    }

    @Override
    public void send_other(ServerRequestInfo ri) throws ForwardRequest {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("send_other for " + ri.operation());
        }
    }

    protected Any makeCompleteEstablishContext(ServerRequestInfo ri, long client_context_id, SASPolicyValues sasValues) {
        CompleteEstablishContext msg = new CompleteEstablishContext();
        msg.client_context_id = client_context_id;
        msg.context_stateful = sasValues.stateful;
        msg.final_context_token = new byte[0];
        SASContextBody contextBody = new SASContextBody();
        contextBody.complete_msg(msg);
        Any any = this.orb.create_any();
        SASContextBodyHelper.insert(any, contextBody);
        if (ri != null) {
            try {
                ri.add_reply_service_context(new ServiceContext(15, this.codec.encode_value(any)), true);
            }
            catch (Exception e) {
                this.logger.error("Error setting reply service context:" + e);
                throw new NO_PERMISSION("SAS Error setting reply service context: " + e, 1245904899, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return any;
    }

    protected Any makeContextError(ServerRequestInfo ri, long client_context_id, int major_status, int minor_status, byte[] error_token) {
        ContextError msg = new ContextError();
        msg.client_context_id = client_context_id;
        msg.error_token = error_token;
        msg.major_status = major_status;
        msg.minor_status = minor_status;
        SASContextBody contextBody = new SASContextBody();
        contextBody.error_msg(msg);
        Any any = this.orb.create_any();
        SASContextBodyHelper.insert(any, contextBody);
        if (ri != null) {
            try {
                ri.add_reply_service_context(new ServiceContext(15, this.codec.encode_value(any)), true);
            }
            catch (Exception e) {
                this.logger.error("Error setting reply service context:" + e);
                throw new NO_PERMISSION("SAS Error setting reply service context: " + e, 1245904899, CompletionStatus.COMPLETED_MAYBE);
            }
        }
        return any;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheSASContext(GIOPConnection connection, long client_context_id, byte[] client_authentication_token, String principalName) {
        GIOPConnection gIOPConnection = connection;
        synchronized (gIOPConnection) {
            Hashtable<Long, CachedContext> sasContexts = (Hashtable<Long, CachedContext>)connection.get_cubby(this.sasContextsCubby);
            if (sasContexts == null) {
                sasContexts = new Hashtable<Long, CachedContext>();
                connection.set_cubby(this.sasContextsCubby, sasContexts);
            }
            sasContexts.put(new Long(client_context_id), new CachedContext(client_authentication_token, principalName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void purgeSASContext(GIOPConnection connection, long client_context_id) {
        GIOPConnection gIOPConnection = connection;
        synchronized (gIOPConnection) {
            Hashtable sasContexts = (Hashtable)connection.get_cubby(this.sasContextsCubby);
            if (sasContexts == null) {
                sasContexts = new Hashtable();
                connection.set_cubby(this.sasContextsCubby, sasContexts);
            }
            sasContexts.remove(new Long(client_context_id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getSASContext(GIOPConnection connection, long client_context_id) {
        Long key = new Long(client_context_id);
        GIOPConnection gIOPConnection = connection;
        synchronized (gIOPConnection) {
            Hashtable sasContexts = (Hashtable)connection.get_cubby(this.sasContextsCubby);
            if (sasContexts == null) {
                sasContexts = new Hashtable();
                connection.set_cubby(this.sasContextsCubby, sasContexts);
            }
            if (!sasContexts.containsKey(key)) {
                return null;
            }
            return ((CachedContext)sasContexts.get((Object)key)).client_authentication_token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSASContextPrincipalName(GIOPConnection connection, long client_context_id) {
        Long key = new Long(client_context_id);
        GIOPConnection gIOPConnection = connection;
        synchronized (gIOPConnection) {
            Hashtable sasContexts = (Hashtable)connection.get_cubby(this.sasContextsCubby);
            if (sasContexts == null) {
                sasContexts = new Hashtable();
                connection.set_cubby(this.sasContextsCubby, sasContexts);
            }
            if (!sasContexts.containsKey(key)) {
                return null;
            }
            return ((CachedContext)sasContexts.get((Object)key)).principalName;
        }
    }

    class CachedContext {
        public byte[] client_authentication_token;
        public String principalName;

        CachedContext(byte[] client_authentication_token, String principalName) {
            this.client_authentication_token = client_authentication_token;
            this.principalName = principalName;
        }
    }
}

