/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CRL;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertificateFactory;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.X509CertSelector;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.jacorb.config.Configurable;
import org.jacorb.config.Configuration;
import org.jacorb.config.ConfigurationException;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;

public class SSLServerSocketFactory
extends SSLRandom
implements ServerSocketFactory,
Configurable {
    private javax.net.ServerSocketFactory factory = null;
    private boolean require_mutual_auth = false;
    private boolean request_mutual_auth = false;
    private boolean trusteesFromKS = false;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private int serverSupportedOptions = 0;
    private int serverRequiredOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private String keystore_type = null;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    private String keystore_provider = null;
    private String truststore_type = null;
    private String truststore_location = null;
    private String truststore_passphrase = null;
    private String truststore_provider = null;
    private boolean support_crl = false;
    private String crl_file = null;

    @Override
    public void configure(Configuration configuration) throws ConfigurationException {
        Configuration config;
        block9: {
            super.configure(configuration);
            config = configuration;
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.serverSupportedOptions = configuration.getAttributeAsInteger("jacorb.security.ssl.server.supported_options", 32, 16);
            this.serverRequiredOptions = configuration.getAttributeAsInteger("jacorb.security.ssl.server.required_options", 0, 16);
            if ((this.serverSupportedOptions & 0x40) != 0) {
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will create SSL sockets that request client authentication");
                }
                this.request_mutual_auth = true;
            }
            if ((this.serverRequiredOptions & 0x40) != 0) {
                this.require_mutual_auth = true;
                this.request_mutual_auth = false;
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("Will create SSL sockets that require client authentication");
                }
            }
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password");
            this.keystore_type = configuration.getAttribute("jacorb.security.keystore_type", "JKS");
            this.keyManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.server.key_manager_algorithm", "SunX509");
            this.trustManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.server.trust_manager_algorithm", "SunX509");
            this.keystore_provider = configuration.getAttribute("jacorb.security.keystore_provider", null);
            this.truststore_type = configuration.getAttribute("jacorb.security.truststore_type", null);
            this.truststore_location = configuration.getAttribute("jacorb.security.truststore", null);
            this.truststore_passphrase = configuration.getAttribute("jacorb.security.truststore_password", null);
            this.truststore_provider = configuration.getAttribute("jacorb.security.truststore_provider", null);
            this.crl_file = configuration.getAttribute("jacorb.security.crl_file", null);
            this.support_crl = configuration.getAttributeAsBoolean("jacorb.security.support_crl", false);
            try {
                this.trustManager = (TrustManager)configuration.getAttributeAsObject("jacorb.security.ssl.server.trust_manager");
            }
            catch (ConfigurationException ce) {
                if (!this.logger.isErrorEnabled()) break block9;
                this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.server.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.server.trust_manager", ""), ce);
            }
        }
        this.enabledProtocols = configuration.getAttributeAsStringsArray("jacorb.security.ssl.server.protocols");
        if (this.enabledProtocols != null && this.logger.isDebugEnabled()) {
            this.logger.debug("Setting user specified server enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.server.protocols", ""));
        }
        try {
            this.factory = this.createServerSocketFactory();
        }
        catch (Exception e) {
            this.logger.warn("Unable to create ServerSocketFactory : {}", (Object)e.getMessage(), (Object)e);
            throw new ConfigurationException("Unable to create ServerSocketFactory!", e);
        }
        this.cipher_suites = config.getAttributeAsStringsArray("jacorb.security.ssl.server.cipher_suites");
    }

    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s.setEnabledProtocols(this.enabledProtocols);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s.setEnabledProtocols(this.enabledProtocols);
        }
        return s;
    }

    @Override
    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        if (this.request_mutual_auth) {
            s.setWantClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s.setEnabledProtocols(this.enabledProtocols);
        }
        return s;
    }

    public boolean isSSL(ServerSocket s) {
        return s instanceof SSLServerSocket;
    }

    private javax.net.ServerSocketFactory createServerSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        KeyStore key_store = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray(), this.keystore_type, this.keystore_provider);
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
        if ("WINDOWS-MY".equalsIgnoreCase(this.keystore_type)) {
            kmf.init(key_store, null);
        } else {
            kmf.init(key_store, this.keystore_passphrase.toCharArray());
        }
        TrustManagerFactory tmf = null;
        KeyStore trust_store = null;
        if ((this.serverRequiredOptions & 0x40) != 0 || (this.serverSupportedOptions & 0x40) != 0) {
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
            if (this.trusteesFromKS) {
                trust_store = key_store;
            } else {
                if ("PKCS11".equalsIgnoreCase(this.truststore_type)) {
                    trust_store = KeyStore.getInstance(this.truststore_type, this.truststore_provider);
                    trust_store.load(null, this.truststore_passphrase.toCharArray());
                } else if ("WINDOWS-ROOT".equalsIgnoreCase(this.truststore_type)) {
                    trust_store = KeyStore.getInstance("WINDOWS-ROOT");
                    trust_store.load(null, null);
                } else if (this.truststore_location != null && this.truststore_passphrase != null) {
                    trust_store = KeyStoreUtil.getKeyStore(this.truststore_location, this.truststore_passphrase.toCharArray(), this.truststore_type);
                }
                this.logger.debug("SSLServerSocketFactory: loaded trust store: " + (trust_store != null ? trust_store.getProvider() : "default (null)"));
            }
            if (trust_store != null && this.support_crl) {
                PKIXBuilderParameters pkixParams = null;
                X509CertSelector x509CertSelector = new X509CertSelector();
                x509CertSelector.setCertificateValid(new Date());
                PKIXBuilderParameters xparams = new PKIXBuilderParameters(trust_store, (CertSelector)x509CertSelector);
                Collection<? extends CRL> crls = this.getCRLs();
                CollectionCertStoreParameters cparam = new CollectionCertStoreParameters(crls);
                CertStore cs = CertStore.getInstance("Collection", cparam);
                xparams.setRevocationEnabled(true);
                xparams.addCertStore(cs);
                pkixParams = xparams;
                CertPathTrustManagerParameters trustParams = new CertPathTrustManagerParameters(pkixParams);
                tmf.init(trustParams);
            } else {
                tmf.init(trust_store);
            }
        }
        if (this.trustManager == null) {
            trustManagers = tmf == null ? null : tmf.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{this.trustManager};
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified server TrustManger : " + this.trustManager.getClass().toString());
            }
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf.getKeyManagers(), trustManagers, this.getSecureRandom());
        return ctx.getServerSocketFactory();
    }

    private Collection<? extends CRL> getCRLs() throws IOException, GeneralSecurityException {
        this.logger.debug("SSLServerSocketFactory: Loading the CRLs from file: " + this.crl_file);
        File crlFile = new File(this.crl_file);
        Collection<? extends CRL> crls = null;
        InputStream is = null;
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            is = new FileInputStream(crlFile);
            crls = cf.generateCRLs(is);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("SSLServerSocketFactory: Found CLRs:");
                Iterator<? extends CRL> it = crls.iterator();
                while (it.hasNext()) {
                    this.logger.debug(it.next().toString());
                }
            }
        }
        catch (IOException ex) {
            this.logger.error("SSLServerSocketFactory: CLRs loading failed: ", ex);
            throw ex;
        }
        catch (GeneralSecurityException gse) {
            this.logger.error("SSLServerSocketFactory: CLRs security error: ", gse);
            throw gse;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception ex) {}
            }
        }
        return crls;
    }
}

