/*
 * Decompiled with CFR 0.152.
 */
package org.japura.gui.calendar.components;

import java.awt.Color;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.MatteBorder;
import org.japura.gui.PopupMenuBuilder;
import org.japura.gui.calendar.Calendar;
import org.japura.gui.calendar.CalendarComponent;
import org.japura.gui.calendar.CalendarComponentType;
import org.japura.gui.calendar.DayOfWeek;
import org.japura.gui.calendar.PropertiesProvider;
import org.japura.gui.calendar.components.CalendarSlot;

public class DayOfWeekSlot
extends CalendarSlot
implements MouseListener {
    private static final long serialVersionUID = 7413497097851129819L;
    private DayOfWeek dayOfWeek;

    public DayOfWeekSlot(Calendar calendar, String name, DayOfWeek dayOfWeek) {
        super(calendar, CalendarComponentType.DAY_WEEK_HEADER);
        this.dayOfWeek = dayOfWeek;
        this.setBorder(this.buildBorder());
        this.setText(name);
        this.setFont(this.getCalendar().getPropertiesProvider().getDayOfWeekFont());
        this.addMouseListener(this);
    }

    private Border buildBorder() {
        PropertiesProvider pp = this.getCalendar().getPropertiesProvider();
        Insets margin = pp.getDayOfWeekMargin();
        int t = margin.top;
        int l = margin.left;
        int b = margin.bottom;
        int r = margin.right;
        MatteBorder ini = BorderFactory.createMatteBorder(1, 0, 0, 0, pp.getTopDayOfWeekSeparatorColor());
        MatteBorder outi = BorderFactory.createMatteBorder(0, 0, 1, 0, pp.getBottomDayOfWeekSeparatorColor());
        Border in = BorderFactory.createEmptyBorder(t, l, b, r);
        CompoundBorder out = BorderFactory.createCompoundBorder(outi, ini);
        return BorderFactory.createCompoundBorder(out, in);
    }

    public DayOfWeek getDayOfWeek() {
        return this.dayOfWeek;
    }

    @Override
    public Color getForeground() {
        if (this.dayOfWeek == null) {
            return super.getForeground();
        }
        return this.getCalendar().getPropertiesProvider().getForeground(this);
    }

    @Override
    public Color getBackground() {
        if (this.dayOfWeek == null) {
            return super.getBackground();
        }
        return this.getCalendar().getPropertiesProvider().getBackground(this);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        JPopupMenu pm;
        Calendar calendar;
        PopupMenuBuilder<CalendarComponent> pmb;
        if (SwingUtilities.isRightMouseButton(e) && (pmb = (calendar = this.getCalendar()).getPopupMenuBuilder()) != null && (pm = pmb.buildPopupMenu(this)) != null) {
            pm.show(this, e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

