/*
 * Decompiled with CFR 0.152.
 */
package scs.core.builder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.omg.CORBA.ORB;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import scs.core.ComponentContext;
import scs.core.ComponentId;
import scs.core.builder.exception.InvalidSchemaException;
import scs.core.builder.exception.InvalidXMLException;
import scs.core.builder.exception.SchemaNotFoundException;
import scs.core.exception.InvalidComponentContextException;
import scs.core.exception.InvalidServantException;
import scs.core.exception.ReceptacleAlreadyExistsException;
import scs.core.exception.SCSException;

public final class XMLComponentBuilder {
    private static final String COMPONENT_ID_ELEMENT = "id";
    private static final String COMPONENT_ID_NAME = "name";
    private static final String COMPONENT_ID_VERSION = "version";
    private static final String COMPONENT_ID_PLATFORM_SPEC = "platformSpec";
    private static final String COMPONENT_CONTEXT_ELEMENT = "context";
    private static final String COMPONENT_CONTEXT_TYPE = "type";
    private static final String FACETS_ELEMENT = "facets";
    private static final String FACET_ELEMENT = "facet";
    private static final String FACET_NAME = "name";
    private static final String FACET_INTERFACE_NAME = "interfaceName";
    private static final String FACET_IMPL = "facetImpl";
    private static final String RECEPTACLES_ELEMENT = "receptacles";
    private static final String RECEPTACLE_ELEMENT = "receptacle";
    private static final String RECEPTACLE_NAME = "name";
    private static final String RECEPTACLE_INTERFACE_NAME = "interfaceName";
    private static final String RECEPTACLE_MULTIPLEX = "isMultiplex";
    private static final String VERSION_DELIMITER = "\\.";
    private ORB orb;
    private POA poa;
    private DocumentBuilder documentBuilder;
    private Validator schemaValidator;

    public XMLComponentBuilder(ORB orb, POA poa) throws SchemaNotFoundException, InvalidSchemaException, ParserConfigurationException {
        Schema schema;
        this.orb = orb;
        this.poa = poa;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        this.documentBuilder = documentBuilderFactory.newDocumentBuilder();
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        String schemaResourceName = "/ComponentDescription.xsd";
        URL schemaURL = this.getClass().getResource(schemaResourceName);
        if (schemaURL == null) {
            throw new SchemaNotFoundException(String.format("O schema %s n\u00e3o foi encontrado", schemaResourceName));
        }
        try {
            schema = factory.newSchema(schemaURL);
        }
        catch (SAXException e) {
            throw new InvalidSchemaException(e);
        }
        this.schemaValidator = schema.newValidator();
    }

    public ComponentContext build(File file) throws IOException, SCSException {
        Document doc;
        try {
            doc = this.documentBuilder.parse(file);
        }
        catch (SAXException e) {
            throw new InvalidXMLException(e);
        }
        return this.build(doc);
    }

    public ComponentContext build(InputStream input) throws IOException, SCSException {
        Document doc;
        try {
            doc = this.documentBuilder.parse(input);
        }
        catch (SAXException e) {
            throw new InvalidXMLException(e);
        }
        return this.build(doc);
    }

    private ComponentContext build(Document doc) throws IOException, SCSException {
        try {
            this.schemaValidator.validate(new DOMSource(doc));
        }
        catch (SAXException e) {
            throw new InvalidXMLException(e);
        }
        doc.getDocumentElement().normalize();
        Element componentElement = (Element)doc.getChildNodes().item(0);
        ComponentId id = XMLComponentBuilder.getComponentId(componentElement);
        ComponentContext context = this.getComponentContext(componentElement, id);
        XMLComponentBuilder.readAndPutFacets(componentElement, context);
        XMLComponentBuilder.readAndPutReceptacles(componentElement, context);
        return context;
    }

    private static Element getChildByName(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagName(name);
        if (nodes.getLength() == 0) {
            return null;
        }
        return (Element)nodes.item(0);
    }

    private static Element[] getChildrenByName(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagName(name);
        Element[] children = new Element[nodes.getLength()];
        for (int i = 0; i < children.length; ++i) {
            children[i] = (Element)nodes.item(i);
        }
        return children;
    }

    private static String getChildValueByName(Element parent, String name) {
        NodeList nodes = parent.getElementsByTagName(name);
        if (nodes.getLength() == 0) {
            return null;
        }
        Node node = nodes.item(0);
        return node.getFirstChild().getNodeValue();
    }

    private static ComponentId getComponentId(Element componentElement) {
        Element componentIdElement = XMLComponentBuilder.getChildByName(componentElement, COMPONENT_ID_ELEMENT);
        String name = XMLComponentBuilder.getChildValueByName(componentIdElement, "name");
        String version = XMLComponentBuilder.getChildValueByName(componentIdElement, COMPONENT_ID_VERSION);
        String[] versions = version.split(VERSION_DELIMITER);
        byte majorVersion = Byte.parseByte(versions[0]);
        byte minorVersion = Byte.parseByte(versions[1]);
        byte patchVersion = Byte.parseByte(versions[2]);
        String platformSpec = XMLComponentBuilder.getChildValueByName(componentIdElement, COMPONENT_ID_PLATFORM_SPEC);
        return new ComponentId(name, majorVersion, minorVersion, patchVersion, platformSpec);
    }

    private ComponentContext getComponentContext(Element componentElement, ComponentId id) throws SCSException {
        Constructor<?> componentContextConstructor;
        Class<?> componentContextClass;
        Element componentContextElement = XMLComponentBuilder.getChildByName(componentElement, COMPONENT_CONTEXT_ELEMENT);
        if (componentContextElement == null) {
            return new ComponentContext(this.orb, this.poa, id);
        }
        String type = XMLComponentBuilder.getChildValueByName(componentContextElement, COMPONENT_CONTEXT_TYPE);
        try {
            componentContextClass = Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new InvalidComponentContextException(String.format("A classe %s, do contexto do componente, n\u00e3o foi encontrada", type));
        }
        catch (ClassCastException e) {
            throw new InvalidComponentContextException(String.format("A classe informada como contexto do componente n\u00e3o \u00e9 do tipo %s", ComponentContext.class.getCanonicalName()));
        }
        try {
            componentContextConstructor = componentContextClass.getConstructor(ORB.class, POA.class, ComponentId.class);
        }
        catch (NoSuchMethodException e) {
            throw new InvalidComponentContextException(String.format("A classe informada como contexto do componente n\u00e3o possui construtor que receba um ORB, um POA e um identificador de componente", new Object[0]));
        }
        try {
            return (ComponentContext)componentContextConstructor.newInstance(this.orb, this.poa, id);
        }
        catch (InstantiationException e) {
            throw new SCSException(e);
        }
        catch (IllegalAccessException e) {
            throw new SCSException(e);
        }
        catch (InvocationTargetException e) {
            throw new SCSException(e);
        }
    }

    private static void readAndPutFacets(Element componentElement, ComponentContext context) throws SCSException {
        Element facetsElement = XMLComponentBuilder.getChildByName(componentElement, FACETS_ELEMENT);
        if (facetsElement == null) {
            return;
        }
        Element[] facetElementArray = XMLComponentBuilder.getChildrenByName(facetsElement, FACET_ELEMENT);
        for (int i = 0; i < facetElementArray.length; ++i) {
            Servant servant;
            Constructor<?> constructor;
            Class<?> servantClass;
            String name = XMLComponentBuilder.getChildValueByName(facetElementArray[i], "name");
            String interfaceName = XMLComponentBuilder.getChildValueByName(facetElementArray[i], "interfaceName");
            String facetImpl = XMLComponentBuilder.getChildValueByName(facetElementArray[i], FACET_IMPL);
            try {
                servantClass = Class.forName(facetImpl);
            }
            catch (ClassNotFoundException e) {
                throw new InvalidServantException(String.format("A classe %s, servant da faceta %s, n\u00e3o foi encontrada", facetImpl, name));
            }
            catch (ClassCastException e) {
                throw new InvalidServantException(String.format("A classe informada como servant da faceta %s n\u00e3o \u00e9 do tipo %s", name, Servant.class.getCanonicalName()));
            }
            try {
                constructor = servantClass.getConstructor(ComponentContext.class);
            }
            catch (NoSuchMethodException e) {
                throw new InvalidServantException(String.format("A classe informada como servant da faceta %s n\u00e3o possui um construtor que receba um contexto", name));
            }
            try {
                servant = (Servant)constructor.newInstance(context);
            }
            catch (InstantiationException e) {
                throw new SCSException(e);
            }
            catch (IllegalAccessException e) {
                throw new SCSException(e);
            }
            catch (InvocationTargetException e) {
                throw new SCSException(e);
            }
            context.addFacet(name, interfaceName, servant);
        }
    }

    private static void readAndPutReceptacles(Element componentElement, ComponentContext context) throws ReceptacleAlreadyExistsException {
        Element receptaclesElement = XMLComponentBuilder.getChildByName(componentElement, RECEPTACLES_ELEMENT);
        if (receptaclesElement == null) {
            return;
        }
        Element[] receptacleElementArray = XMLComponentBuilder.getChildrenByName(receptaclesElement, RECEPTACLE_ELEMENT);
        for (int i = 0; i < receptacleElementArray.length; ++i) {
            String name = XMLComponentBuilder.getChildValueByName(receptacleElementArray[i], "name");
            String interfaceName = XMLComponentBuilder.getChildValueByName(receptacleElementArray[i], "interfaceName");
            boolean isMultiplex = Boolean.parseBoolean(XMLComponentBuilder.getChildValueByName(receptacleElementArray[i], RECEPTACLE_MULTIPLEX));
            context.addReceptacle(name, interfaceName, isMultiplex);
        }
    }
}

