/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPublicKey;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import scs.core.IComponent;
import scs.core.IComponentHelper;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.AccessControl;
import tecgraf.openbus.core.v2_1.services.access_control.AccessControlHelper;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistryHelper;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistryHelper;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.security.Cryptography;

final class BusInfo {
    private final Object rawObject;
    private final X509Certificate busCert;
    private String id;
    private RSAPublicKey publicKey;
    private IComponent bus;
    private AccessControl accessControl;
    private LoginRegistry loginRegistry;
    private OfferRegistry offerRegistry;
    private final java.lang.Object lock = new java.lang.Object();

    BusInfo(Object obj, X509Certificate busCert) {
        this.rawObject = obj;
        this.busCert = busCert;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void basicBusInitialization() throws ServiceFailure {
        IComponent ic;
        java.lang.Object object = this.lock;
        synchronized (object) {
            ic = this.bus;
        }
        if (ic == null) {
            ic = IComponentHelper.narrow(this.rawObject);
            if (ic == null) {
                throw new OBJECT_NOT_EXIST("Refer\u00eancia obtida n\u00e3o corresponde a um " + IComponentHelper.id());
            }
            Object obj = ic.getFacet(AccessControlHelper.id());
            if (obj == null) {
                throw new OBJECT_NOT_EXIST("Refer\u00eancia obtida n\u00e3o atende ao servi\u00e7o " + AccessControlHelper.id());
            }
            AccessControl ac = AccessControlHelper.narrow(obj);
            String id = ac.busid();
            X509Certificate certificate = this.busCert;
            if (certificate == null) {
                try {
                    certificate = Cryptography.getInstance().readX509Certificate(ac.certificate());
                }
                catch (IOException | CryptographyException e) {
                    throw new ServiceFailure("Erro ao obter a chave p\u00fablica do barramento: " + e.getMessage());
                }
            }
            if ((obj = ic.getFacet(LoginRegistryHelper.id())) == null) {
                throw new OBJECT_NOT_EXIST("Refer\u00eancia obtida n\u00e3o atende ao servi\u00e7o " + LoginRegistryHelper.id());
            }
            LoginRegistry login = LoginRegistryHelper.narrow(obj);
            obj = ic.getFacet(OfferRegistryHelper.id());
            if (obj == null) {
                throw new OBJECT_NOT_EXIST("Refer\u00eancia obtida n\u00e3o atende ao servi\u00e7o " + OfferRegistryHelper.id());
            }
            OfferRegistry registry = OfferRegistryHelper.narrow(obj);
            java.lang.Object object2 = this.lock;
            synchronized (object2) {
                this.bus = ic;
                this.accessControl = ac;
                this.id = id;
                this.publicKey = (RSAPublicKey)certificate.getPublicKey();
                this.loginRegistry = login;
                this.offerRegistry = registry;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearBusInfos() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            this.id = null;
            this.publicKey = null;
            this.bus = null;
            this.accessControl = null;
            this.loginRegistry = null;
            this.offerRegistry = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getId() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            return this.id;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RSAPublicKey getPublicKey() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            return this.publicKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AccessControl getAccessControl() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            return this.accessControl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LoginRegistry getLoginRegistry() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            return this.loginRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OfferRegistry getOfferRegistry() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            return this.offerRegistry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IComponent getComponent() {
        java.lang.Object object = this.lock;
        synchronized (object) {
            return this.bus;
        }
    }
}

