/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.core;

import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.FormatMismatch;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.CodecPackage.TypeMismatch;
import org.omg.PortableInterceptor.Current;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import tecgraf.openbus.CallDispatchCallback;
import tecgraf.openbus.CallerChain;
import tecgraf.openbus.Connection;
import tecgraf.openbus.OpenBusContext;
import tecgraf.openbus.SharedAuthSecret;
import tecgraf.openbus.core.CallerChainImpl;
import tecgraf.openbus.core.ConnectionImpl;
import tecgraf.openbus.core.Credential;
import tecgraf.openbus.core.ORBMediator;
import tecgraf.openbus.core.ORBUtils;
import tecgraf.openbus.core.SharedAuthSecretImpl;
import tecgraf.openbus.core.v2_0.credential.SignedCallChain;
import tecgraf.openbus.core.v2_0.data_export.ExportedCallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChain;
import tecgraf.openbus.core.v2_0.services.access_control.CallChainHelper;
import tecgraf.openbus.core.v2_1.credential.SignedData;
import tecgraf.openbus.core.v2_1.data_export.ExportedCallChainHelper;
import tecgraf.openbus.core.v2_1.data_export.ExportedSharedAuth;
import tecgraf.openbus.core.v2_1.data_export.ExportedSharedAuthHelper;
import tecgraf.openbus.core.v2_1.data_export.VersionedData;
import tecgraf.openbus.core.v2_1.data_export.VersionedDataSeqHelper;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.access_control.InvalidToken;
import tecgraf.openbus.core.v2_1.services.access_control.LoginProcess;
import tecgraf.openbus.core.v2_1.services.access_control.LoginRegistry;
import tecgraf.openbus.core.v2_1.services.access_control.UnknownDomain;
import tecgraf.openbus.core.v2_1.services.access_control.WrongEncoding;
import tecgraf.openbus.core.v2_1.services.offer_registry.OfferRegistry;
import tecgraf.openbus.exception.CryptographyException;
import tecgraf.openbus.exception.InvalidEncodedStream;
import tecgraf.openbus.exception.InvalidPropertyValue;
import tecgraf.openbus.exception.OpenBusInternalException;
import tecgraf.openbus.interceptors.CallChainInfo;
import tecgraf.openbus.interceptors.CallChainInfoHelper;
import tecgraf.openbus.security.Cryptography;

final class OpenBusContextImpl
extends LocalObject
implements OpenBusContext {
    private static final Logger logger = Logger.getLogger(OpenBusContextImpl.class.getName());
    private static final int MAGIC_TAG_SIZE = 4;
    private static final byte[] MTAG_CALLCHAIN = new byte[]{66, 85, 83, 1};
    private static final byte[] MTAG_SHAREDAUTH = new byte[]{66, 85, 83, 2};
    private final int CURRENT_CONNECTION_SLOT_ID;
    private final int IGNORE_THREAD_SLOT_ID;
    private final int SKIP_INVLOGIN_SLOT_ID;
    private final Map<Integer, Connection> connectedById;
    private Connection defaultConn;
    private volatile CallDispatchCallback dispatchCallback;
    private ORB orb;
    private volatile POA poa;
    private final ReentrantReadWriteLock rwlock = new ReentrantReadWriteLock(true);
    private final ReentrantReadWriteLock.ReadLock readLock = this.rwlock.readLock();
    private final ReentrantReadWriteLock.WriteLock writeLock = this.rwlock.writeLock();

    public OpenBusContextImpl(int currentConnectionSlotId, int ignoreThreadSlotId, int invLoginSlotId) {
        this.connectedById = Collections.synchronizedMap(new HashMap());
        this.CURRENT_CONNECTION_SLOT_ID = currentConnectionSlotId;
        this.IGNORE_THREAD_SLOT_ID = ignoreThreadSlotId;
        this.SKIP_INVLOGIN_SLOT_ID = invLoginSlotId;
    }

    @Override
    public ORB ORB() {
        return this.orb;
    }

    @Override
    public POA POA() {
        return this.poa;
    }

    @Override
    public void POA(POA poa) {
        if (poa != null) {
            this.poa = poa;
            return;
        }
        try {
            this.poa = POAHelper.narrow(this.orb.resolve_initial_references("RootPOA"));
            this.poa.the_POAManager().activate();
        }
        catch (InvalidName e) {
            throw new OpenBusInternalException("O ORB perdeu a refer\u00eancia para o RootPOA.", e);
        }
        catch (AdapterInactive e) {
            throw new OpenBusInternalException("O RootPOA est\u00e1 inativo.", e);
        }
    }

    @Override
    public Connection connectByAddress(String host, int port) {
        Connection conn;
        try {
            conn = this.connectByAddress(host, port, new Properties());
        }
        catch (InvalidPropertyValue e) {
            throw new OpenBusInternalException("Este erro nunca deveria ocorrer pois n\u00e3o existem propriedades.", e);
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection connectByAddress(String host, int port, Properties props) throws InvalidPropertyValue {
        Object obj;
        if (host == null || host.isEmpty() || port < 0) {
            throw new IllegalArgumentException("Os parametros host e/ou port n\u00e3o s\u00e3o v\u00e1lidos.");
        }
        try {
            this.ignoreThread();
            String str = String.format("corbaloc::1.0@%s:%d/%s", host, port, "OpenBus_2_1");
            obj = this.orb.string_to_object(str);
        }
        finally {
            this.unignoreThread();
        }
        return this.connectByReference(obj, props);
    }

    @Override
    public Connection connectByReference(Object reference) {
        Connection conn;
        try {
            conn = this.connectByReference(reference, new Properties());
        }
        catch (InvalidPropertyValue e) {
            throw new OpenBusInternalException("Este erro nunca deveria ocorrer pois n\u00e3o existem propriedades.", e);
        }
        return conn;
    }

    @Override
    public Connection connectByReference(Object reference, Properties props) throws InvalidPropertyValue {
        if (reference == null) {
            throw new IllegalArgumentException("Refer\u00eancia inv\u00e1lida para o barramento.");
        }
        return new ConnectionImpl(reference, this, this.orb, this.poa, props);
    }

    @Override
    @Deprecated
    public Connection createConnection(String host, int port) {
        return this.connectByAddress(host, port);
    }

    @Override
    @Deprecated
    public Connection createConnection(String host, int port, Properties props) throws InvalidPropertyValue {
        return this.connectByAddress(host, port, props);
    }

    int getCurrentConnectionSlotId() {
        return this.CURRENT_CONNECTION_SLOT_ID;
    }

    @Override
    public Connection defaultConnection(Connection connection) {
        Connection old;
        this.writeLock.lock();
        try {
            old = this.defaultConn;
            this.defaultConn = connection;
        }
        finally {
            this.writeLock.unlock();
        }
        return old;
    }

    @Override
    public Connection defaultConnection() {
        this.readLock.lock();
        try {
            Connection connection = this.defaultConn;
            return connection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public Connection currentConnection(Connection connection) {
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            int id;
            Any currentId = current.get_slot(this.CURRENT_CONNECTION_SLOT_ID);
            if (currentId.type().kind().value() != 0) {
                id = currentId.extract_long();
                if (connection == null) {
                    current.set_slot(this.CURRENT_CONNECTION_SLOT_ID, this.orb.create_any());
                    return this.setConnectionById(id, null);
                }
            } else {
                if (connection == null) {
                    return null;
                }
                id = ORBUtils.getMediator(this.orb).getUniqueId();
                Any newId = this.orb.create_any();
                newId.insert_long(id);
                current.set_slot(this.CURRENT_CONNECTION_SLOT_ID, newId);
            }
            return this.setConnectionById(id, connection);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public Connection currentConnection() {
        Any any;
        Connection connection = null;
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            any = current.get_slot(this.CURRENT_CONNECTION_SLOT_ID);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot da thread corrente";
            logger.log(Level.SEVERE, message, e);
            throw new INTERNAL(message);
        }
        if (any.type().kind().value() != 0) {
            int id = any.extract_long();
            connection = this.connectedById.get(id);
        }
        if (connection == null) {
            connection = this.defaultConnection();
        }
        return connection;
    }

    @Override
    public CallerChain callerChain() {
        Current current = ORBUtils.getPICurrent(this.orb);
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        try {
            Any any = current.get_slot(mediator.getSignedChainSlotId());
            if (any.type().kind().value() != 0) {
                CallChainInfo info = CallChainInfoHelper.extract(any);
                return CallerChainImpl.info2CallerChain(info, mediator.getCodec());
            }
            return null;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public void joinChain() throws OpenBusInternalException {
        this.joinChain(null);
    }

    @Override
    public void joinChain(CallerChain chain) {
        CallerChain callerChain = chain = chain != null ? chain : this.callerChain();
        if (chain != null) {
            try {
                Current current = ORBUtils.getPICurrent(this.orb);
                ORBMediator mediator = ORBUtils.getMediator(this.orb);
                Credential.Chain internal = ((CallerChainImpl)chain).internal_chain();
                Any any = this.orb.create_any();
                CallChainInfo infos = new CallChainInfo(internal.signedChain, internal.isLegacy(), internal.bus, internal.signedLegacy);
                CallChainInfoHelper.insert(any, infos);
                current.set_slot(mediator.getJoinedChainSlotId(), any);
            }
            catch (InvalidSlot e) {
                String message = "Falha inesperada ao acessar slot";
                logger.log(Level.SEVERE, message, e);
                throw new OpenBusInternalException(message, e);
            }
        }
    }

    @Override
    public void exitChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = this.orb.create_any();
            current.set_slot(mediator.getJoinedChainSlotId(), any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain joinedChain() {
        try {
            Current current = ORBUtils.getPICurrent(this.orb);
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any any = current.get_slot(mediator.getJoinedChainSlotId());
            if (any.type().kind().value() != 0) {
                CallChainInfo info = CallChainInfoHelper.extract(any);
                return CallerChainImpl.info2CallerChain(info, mediator.getCodec());
            }
            return null;
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao obter o slot no PICurrent";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao recuperar a cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    CallerChain makeChainFor(String entity) throws ServiceFailure {
        ConnectionImpl conn = (ConnectionImpl)this.currentConnection();
        SignedData signed = conn.access().signChainFor(entity);
        try {
            ORBMediator mediator = ORBUtils.getMediator(this.orb);
            Any anyChain = mediator.getCodec().decode_value(signed.encoded, tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.type());
            tecgraf.openbus.core.v2_1.services.access_control.CallChain callChain = tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.extract(anyChain);
            SignedCallChain legacy = null;
            if (conn.legacy() && conn.legacySupport().converter() != null) {
                legacy = conn.legacySupport().converter().signChainFor(entity);
            }
            return new CallerChainImpl(callChain, signed, legacy);
        }
        catch (UserException e) {
            String message = "Falha inesperada ao criar uma nova cadeia.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CallerChain importChain(byte[] token, String domain) throws InvalidToken, UnknownDomain, WrongEncoding, ServiceFailure {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        ConnectionImpl conn = (ConnectionImpl)this.currentConnection();
        RSAPublicKey buskey = conn.busPublicKey();
        if (buskey == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        try {
            byte[] data = Cryptography.getInstance().encrypt(token, buskey);
            SignedData signed = conn.access().signChainByToken(data, domain);
            Any anyChain = codec.decode_value(signed.encoded, tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.type());
            tecgraf.openbus.core.v2_1.services.access_control.CallChain chain = tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.extract(anyChain);
            SignedCallChain legacy = null;
            if (conn.legacy() && conn.legacySupport().converter() != null) {
                CallerChain joined = this.joinedChain();
                try {
                    this.joinChain(new CallerChainImpl(chain, signed));
                    legacy = conn.legacySupport().converter().convertSignedChain();
                }
                finally {
                    this.joinChain(joined);
                }
            }
            return new CallerChainImpl(chain, signed, legacy);
        }
        catch (CryptographyException e) {
            throw new OpenBusInternalException("Erro de criptografia com uso de chave p\u00fablica.", e);
        }
        catch (FormatMismatch | TypeMismatch e) {
            String message = "Falha inesperada ao decodificar uma cadeia exportada.";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public byte[] encodeChain(CallerChain chain) {
        if (chain == null) {
            return null;
        }
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            byte[] encodedChain;
            Any anyChain;
            ArrayList<VersionedData> list = new ArrayList<VersionedData>();
            Credential.Chain internal = ((CallerChainImpl)chain).internal_chain();
            if (internal.signedChain != null) {
                anyChain = this.orb.create_any();
                ExportedCallChainHelper.insert(anyChain, internal.signedChain);
                encodedChain = codec.encode_value(anyChain);
                list.add(new VersionedData(1112888065, encodedChain));
            }
            if (internal.signedLegacy != null) {
                anyChain = this.orb.create_any();
                tecgraf.openbus.core.v2_0.data_export.ExportedCallChainHelper.insert(anyChain, new ExportedCallChain(chain.busId(), internal.signedLegacy));
                encodedChain = codec.encode_value(anyChain);
                list.add(new VersionedData(1112888064, encodedChain));
            }
            VersionedData[] exports = list.toArray(new VersionedData[list.size()]);
            return this.encodeExportedVersions(exports, MTAG_CALLCHAIN);
        }
        catch (InvalidTypeForEncoding e) {
            String message = "Falha inesperada ao codificar uma cadeia para exporta\u00e7\u00e3o";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public CallerChain decodeChain(byte[] encoded) throws InvalidEncodedStream {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            VersionedData[] exports;
            tecgraf.openbus.core.v2_1.services.access_control.CallChain chain = null;
            SignedData signed = null;
            SignedCallChain legacySigned = null;
            CallChain legacyChain = null;
            String legacyBus = null;
            for (VersionedData export : exports = this.decodeExportedVersions(encoded, MTAG_CALLCHAIN)) {
                Any exported;
                if (export.version == 1112888065) {
                    exported = codec.decode_value(export.encoded, ExportedCallChainHelper.type());
                    signed = ExportedCallChainHelper.extract(exported);
                    Any anyChain = codec.decode_value(signed.encoded, tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.type());
                    chain = tecgraf.openbus.core.v2_1.services.access_control.CallChainHelper.extract(anyChain);
                    continue;
                }
                if (export.version != 1112888064) continue;
                exported = codec.decode_value(export.encoded, tecgraf.openbus.core.v2_0.data_export.ExportedCallChainHelper.type());
                ExportedCallChain importing = tecgraf.openbus.core.v2_0.data_export.ExportedCallChainHelper.extract(exported);
                Any anyChain = codec.decode_value(importing.signedChain.encoded, CallChainHelper.type());
                legacyChain = CallChainHelper.extract(anyChain);
                legacySigned = importing.signedChain;
                legacyBus = importing.bus;
            }
            if (chain != null) {
                return new CallerChainImpl(chain, signed, legacySigned);
            }
            if (legacyChain != null) {
                return new CallerChainImpl(legacyBus, legacyChain, legacySigned);
            }
            throw new InvalidEncodedStream("Vers\u00e3o de cadeia incompat\u00edvel");
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar uma cadeia exportada.";
            logger.log(Level.SEVERE, message, e);
            throw new InvalidEncodedStream(message, e);
        }
    }

    @Override
    public byte[] encodeSharedAuth(SharedAuthSecret secret) {
        if (secret == null) {
            return null;
        }
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            byte[] encodedSecret;
            ArrayList<VersionedData> list = new ArrayList<VersionedData>();
            Any anySecret = this.orb.create_any();
            SharedAuthSecretImpl secretImpl = (SharedAuthSecretImpl)secret;
            if (secretImpl.attempt() != null) {
                ExportedSharedAuthHelper.insert(anySecret, new ExportedSharedAuth(secretImpl.busid(), secretImpl.attempt(), secretImpl.secret()));
                encodedSecret = codec.encode_value(anySecret);
                list.add(new VersionedData(1112888065, encodedSecret));
            }
            if (secretImpl.legacy() != null) {
                tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuthHelper.insert(anySecret, new tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuth(secretImpl.busid(), secretImpl.legacy(), secretImpl.secret()));
                encodedSecret = codec.encode_value(anySecret);
                list.add(new VersionedData(1112888064, encodedSecret));
            }
            VersionedData[] exports = list.toArray(new VersionedData[list.size()]);
            return this.encodeExportedVersions(exports, MTAG_SHAREDAUTH);
        }
        catch (InvalidTypeForEncoding e) {
            String message = "Falha inesperada ao codificar um segredo para exporta\u00e7\u00e3o";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    @Override
    public SharedAuthSecret decodeSharedAuth(byte[] encoded) throws InvalidEncodedStream {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        try {
            VersionedData[] exports;
            String bus = null;
            byte[] secret = null;
            LoginProcess attempt = null;
            tecgraf.openbus.core.v2_0.services.access_control.LoginProcess legacy = null;
            for (VersionedData export : exports = this.decodeExportedVersions(encoded, MTAG_SHAREDAUTH)) {
                IDLEntity sauth;
                Any exported;
                if (export.version == 1112888065) {
                    exported = codec.decode_value(export.encoded, ExportedSharedAuthHelper.type());
                    sauth = ExportedSharedAuthHelper.extract(exported);
                    bus = sauth.bus;
                    attempt = sauth.attempt;
                    secret = sauth.secret;
                    continue;
                }
                if (export.version != 1112888064) continue;
                exported = codec.decode_value(export.encoded, tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuthHelper.type());
                sauth = tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuthHelper.extract(exported);
                bus = ((tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuth)sauth).bus;
                legacy = ((tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuth)sauth).attempt;
                secret = ((tecgraf.openbus.core.v2_0.data_export.ExportedSharedAuth)sauth).secret;
            }
            if (attempt != null || legacy != null) {
                return new SharedAuthSecretImpl(bus, attempt, legacy, secret, this);
            }
            throw new InvalidEncodedStream("Vers\u00e3o de segredo incompat\u00edvel");
        }
        catch (UserException e) {
            String message = "Falha inesperada ao decodificar um segredo exportado.";
            logger.log(Level.SEVERE, message, e);
            throw new InvalidEncodedStream(message, e);
        }
    }

    private byte[] encodeExportedVersions(VersionedData[] exports, byte[] tag) throws InvalidTypeForEncoding {
        ORBMediator mediator = ORBUtils.getMediator(this.orb);
        Codec codec = mediator.getCodec();
        Any any = this.orb.create_any();
        VersionedDataSeqHelper.insert(any, exports);
        byte[] encodedExport = codec.encode_value(any);
        byte[] fullEnconding = new byte[encodedExport.length + 4];
        System.arraycopy(tag, 0, fullEnconding, 0, 4);
        System.arraycopy(encodedExport, 0, fullEnconding, 4, encodedExport.length);
        return fullEnconding;
    }

    private VersionedData[] decodeExportedVersions(byte[] encoded, byte[] magictag) throws InvalidEncodedStream, FormatMismatch, TypeMismatch {
        if (encoded.length > 4) {
            byte[] tag = new byte[4];
            byte[] encodedExport = new byte[encoded.length - 4];
            System.arraycopy(encoded, 0, tag, 0, 4);
            System.arraycopy(encoded, 4, encodedExport, 0, encodedExport.length);
            if (Arrays.equals(magictag, tag)) {
                ORBMediator mediator = ORBUtils.getMediator(this.orb);
                Codec codec = mediator.getCodec();
                Any anyexports = codec.decode_value(encodedExport, VersionedDataSeqHelper.type());
                return VersionedDataSeqHelper.extract(anyexports);
            }
        }
        String errormsg = "Stream de bytes n\u00e3o corresponde ao tipo de dado esperado.";
        throw new InvalidEncodedStream(errormsg);
    }

    Connection getConnectionById(int id) {
        return this.connectedById.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Connection setConnectionById(int id, Connection conn) {
        Map<Integer, Connection> map = this.connectedById;
        synchronized (map) {
            Connection old = this.connectedById.remove(id);
            if (conn != null) {
                this.connectedById.put(id, conn);
            }
            return old;
        }
    }

    void ORB(ORB orb) {
        this.orb = orb;
    }

    void ignoreThread() {
        Any any = this.orb.create_any();
        any.insert_boolean(true);
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    void unignoreThread() {
        Any any = this.orb.create_any();
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.IGNORE_THREAD_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de intercepta\u00e7\u00e3o ignorada";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    int getIgnoreThreadSlotId() {
        return this.IGNORE_THREAD_SLOT_ID;
    }

    void ignoreInvLogin() {
        Any any = this.orb.create_any();
        any.insert_boolean(true);
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.SKIP_INVLOGIN_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de callback";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    void unignoreInvLogin() {
        Any any = this.orb.create_any();
        Current current = ORBUtils.getPICurrent(this.orb);
        try {
            current.set_slot(this.SKIP_INVLOGIN_SLOT_ID, any);
        }
        catch (InvalidSlot e) {
            String message = "Falha inesperada ao acessar o slot de InvalidLogin";
            logger.log(Level.SEVERE, message, e);
            throw new OpenBusInternalException(message, e);
        }
    }

    int getSkipInvalidLoginSlotId() {
        return this.SKIP_INVLOGIN_SLOT_ID;
    }

    @Override
    public void onCallDispatch(CallDispatchCallback callback) {
        this.dispatchCallback = callback;
    }

    @Override
    public CallDispatchCallback onCallDispatch() {
        return this.dispatchCallback;
    }

    LoginRegistry getLoginRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.currentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.logins();
    }

    OfferRegistry getOfferRegistry() {
        ConnectionImpl conn = (ConnectionImpl)this.currentConnection();
        if (conn == null || conn.login() == null) {
            throw new NO_PERMISSION(1112888319, CompletionStatus.COMPLETED_NO);
        }
        return conn.offers();
    }
}

