/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.extension;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.omg.CORBA.Object;
import tecgraf.javautils.core.lng.LNG;
import tecgraf.openbus.OfferObserver;
import tecgraf.openbus.OfferRegistry;
import tecgraf.openbus.RemoteOffer;
import tecgraf.openbus.core.v2_1.services.ServiceFailure;
import tecgraf.openbus.core.v2_1.services.ServiceFailureHelper;
import tecgraf.openbus.extension.BusExtensionFacade;
import tecgraf.openbus.services.governance.v1_0.Consumer;
import tecgraf.openbus.services.governance.v1_0.ConsumerRegistry;
import tecgraf.openbus.services.governance.v1_0.ConsumerRegistryHelper;
import tecgraf.openbus.services.governance.v1_0.Contract;
import tecgraf.openbus.services.governance.v1_0.ContractRegistry;
import tecgraf.openbus.services.governance.v1_0.ContractRegistryHelper;
import tecgraf.openbus.services.governance.v1_0.Integration;
import tecgraf.openbus.services.governance.v1_0.IntegrationRegistry;
import tecgraf.openbus.services.governance.v1_0.IntegrationRegistryHelper;
import tecgraf.openbus.services.governance.v1_0.Provider;
import tecgraf.openbus.services.governance.v1_0.ProviderRegistry;
import tecgraf.openbus.services.governance.v1_0.ProviderRegistryHelper;

public class BusExtensionImpl
implements BusExtensionFacade {
    public static final String SEARCH_CRITERIA_KEY = "openbus.component.name";
    public static final String SEARCH_CRITERIA_VALUE = "GovernanceExtensionService";
    private OfferRegistry offers;
    private Cache<String, Object> cachedReferences = CacheBuilder.newBuilder().maximumSize(10L).build();

    public BusExtensionImpl(OfferRegistry offers) {
        this.offers = offers;
    }

    private Object facet(String id) throws ServiceFailure {
        try {
            return this.cachedReferences.get(id, () -> {
                ArrayListMultimap<String, String> props = ArrayListMultimap.create();
                props.put((java.lang.Object)SEARCH_CRITERIA_KEY, (java.lang.Object)SEARCH_CRITERIA_VALUE);
                List<RemoteOffer> available = this.offers.findServices(props);
                available.removeIf(remoteOffer -> {
                    try {
                        remoteOffer.service().getComponentId();
                    }
                    catch (Exception e) {
                        return true;
                    }
                    return false;
                });
                if (available.size() == 0) {
                    throw new ServiceFailure(LNG.get("ServiceFailure.not.found", SEARCH_CRITERIA_VALUE, this.offers.connection().busId(), SEARCH_CRITERIA_KEY));
                }
                RemoteOffer remote = available.get(0);
                remote.subscribeObserver(new OfferObserver(){

                    @Override
                    public void propertiesChanged(RemoteOffer offer) {
                    }

                    @Override
                    public void removed(RemoteOffer offer) {
                        BusExtensionImpl.this.cachedReferences.invalidateAll();
                    }
                });
                return remote.service().getFacet(id);
            });
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            this.cachedReferences.invalidate(id);
            if (e.getCause() instanceof ServiceFailure) {
                throw (ServiceFailure)e.getCause();
            }
            throw new ServiceFailure(ServiceFailureHelper.id(), e.getMessage());
        }
    }

    @Override
    public boolean isExtensionCapable() {
        try {
            this.getConsumerRegistry();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public ContractRegistry getContractRegistry() throws ServiceFailure {
        return ContractRegistryHelper.narrow(this.facet(ContractRegistryHelper.id()));
    }

    @Override
    public ProviderRegistry getProviderRegistry() throws ServiceFailure {
        return ProviderRegistryHelper.narrow(this.facet(ProviderRegistryHelper.id()));
    }

    @Override
    public ConsumerRegistry getConsumerRegistry() throws ServiceFailure {
        return ConsumerRegistryHelper.narrow(this.facet(ConsumerRegistryHelper.id()));
    }

    @Override
    public IntegrationRegistry getIntegrationRegistry() throws ServiceFailure {
        return IntegrationRegistryHelper.narrow(this.facet(IntegrationRegistryHelper.id()));
    }

    @Override
    public List<Contract> getContracts() throws ServiceFailure {
        return Arrays.asList(this.getContractRegistry().contracts());
    }

    @Override
    public List<Provider> getProviders() throws ServiceFailure {
        return Arrays.asList(this.getProviderRegistry().providers());
    }

    @Override
    public List<Consumer> getConsumers() throws ServiceFailure {
        return Arrays.asList(this.getConsumerRegistry().consumers());
    }

    @Override
    public List<Integration> getIntegrations() throws ServiceFailure {
        return Arrays.asList(this.getIntegrationRegistry().integrations());
    }
}

