/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.desktop.dialog;

import busexplorer.Application;
import busexplorer.ApplicationIcons;
import busexplorer.BusExplorerLogin;
import busexplorer.desktop.dialog.AuditSettingsPanel;
import busexplorer.desktop.dialog.BasicSettingsPanel;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.RefreshDelegate;
import busexplorer.panel.RefreshablePanel;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.authorizations.AuthorizationAddAction;
import busexplorer.panel.authorizations.AuthorizationDeleteAction;
import busexplorer.panel.authorizations.AuthorizationRefreshAction;
import busexplorer.panel.authorizations.AuthorizationTableProvider;
import busexplorer.panel.categories.CategoryAddAction;
import busexplorer.panel.categories.CategoryDeleteAction;
import busexplorer.panel.categories.CategoryEditAction;
import busexplorer.panel.categories.CategoryRefreshAction;
import busexplorer.panel.categories.CategoryTableProvider;
import busexplorer.panel.certificates.CertificateAddAction;
import busexplorer.panel.certificates.CertificateDeleteAction;
import busexplorer.panel.certificates.CertificateEditAction;
import busexplorer.panel.certificates.CertificateRefreshAction;
import busexplorer.panel.certificates.CertificateTableProvider;
import busexplorer.panel.configuration.admins.AdminAddAction;
import busexplorer.panel.configuration.admins.AdminDeleteAction;
import busexplorer.panel.configuration.admins.AdminEditAction;
import busexplorer.panel.configuration.admins.AdminRefreshAction;
import busexplorer.panel.configuration.admins.AdminTableProvider;
import busexplorer.panel.configuration.validators.ValidatorDeleteAction;
import busexplorer.panel.configuration.validators.ValidatorRefreshAction;
import busexplorer.panel.configuration.validators.ValidatorRestartAction;
import busexplorer.panel.configuration.validators.ValidatorTableProvider;
import busexplorer.panel.consumers.ConsumerAddAction;
import busexplorer.panel.consumers.ConsumerDeleteAction;
import busexplorer.panel.consumers.ConsumerEditAction;
import busexplorer.panel.consumers.ConsumerRefreshAction;
import busexplorer.panel.consumers.ConsumerTableProvider;
import busexplorer.panel.contracts.ContractAddAction;
import busexplorer.panel.contracts.ContractDeleteAction;
import busexplorer.panel.contracts.ContractEditAction;
import busexplorer.panel.contracts.ContractRefreshAction;
import busexplorer.panel.contracts.ContractTableProvider;
import busexplorer.panel.entities.EntityAddAction;
import busexplorer.panel.entities.EntityDeleteAction;
import busexplorer.panel.entities.EntityEditAction;
import busexplorer.panel.entities.EntityRefreshAction;
import busexplorer.panel.entities.EntityTableProvider;
import busexplorer.panel.healing.ConsistencyReportPanel;
import busexplorer.panel.integrations.IntegrationAddAction;
import busexplorer.panel.integrations.IntegrationDeleteAction;
import busexplorer.panel.integrations.IntegrationEditAction;
import busexplorer.panel.integrations.IntegrationExportToXLSAction;
import busexplorer.panel.integrations.IntegrationRefreshAction;
import busexplorer.panel.integrations.IntegrationTableProvider;
import busexplorer.panel.interfaces.InterfaceAddAction;
import busexplorer.panel.interfaces.InterfaceDeleteAction;
import busexplorer.panel.interfaces.InterfaceRefreshAction;
import busexplorer.panel.interfaces.InterfaceTableProvider;
import busexplorer.panel.logins.LoginDeleteAction;
import busexplorer.panel.logins.LoginRefreshAction;
import busexplorer.panel.logins.LoginTableProvider;
import busexplorer.panel.offers.OfferDeleteAction;
import busexplorer.panel.offers.OfferPropertiesAction;
import busexplorer.panel.offers.OfferRefreshAction;
import busexplorer.panel.offers.OfferStatusAction;
import busexplorer.panel.offers.OfferTableProvider;
import busexplorer.panel.providers.ProviderAddAction;
import busexplorer.panel.providers.ProviderDeleteAction;
import busexplorer.panel.providers.ProviderEditAction;
import busexplorer.panel.providers.ProviderRefreshAction;
import busexplorer.panel.providers.ProviderTableProvider;
import busexplorer.utils.BusAddress;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Consumer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import tecgraf.javautils.gui.GBC;
import tecgraf.javautils.gui.table.ObjectTableModel;
import tecgraf.javautils.gui.table.ObjectTableProvider;

public class MainDialog
extends JFrame
implements PropertyChangeListener {
    public static final String TABBED_PANE_DISABLED_TEXT = "TabbedPane.disabledText";
    public static final String TABBED_PANE_FOREGROUND = "TabbedPane.foreground";
    public static final String COMPATIBILITY_FOREGROUND = "Label.disabledForeground";
    private ArrayList<Consumer<Boolean>> notifiers = new ArrayList();
    private JTabbedPane featuresPane;
    private JButton disconnect;
    private JLabel status;
    private Properties properties;

    public MainDialog(Properties properties) {
        this.properties = properties;
        this.setIconImages(Arrays.asList(ApplicationIcons.BUSEXPLORER_LIST));
        this.buildDialog();
    }

    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public void dispose() {
        if (Application.login() != null) {
            Application.login().logout();
        }
        super.dispose();
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propertyName = e.getPropertyName();
        BusExplorerLogin busExplorerLogin = (BusExplorerLogin)e.getNewValue();
        if ("Application.login".equals(propertyName)) {
            BusAddress address = busExplorerLogin.address;
            String bus = address.getDescription() != null ? address.getDescription() : address.toString();
            this.setDialogTitle(bus);
            busExplorerLogin.onRelogin((connection, oldLogin) -> {
                this.status.setText(Language.get(this.getClass(), "connected.as", busExplorerLogin.info.entity, busExplorerLogin.domain, busExplorerLogin.info.id));
                this.notifiers.forEach((Consumer<Consumer<Boolean>>)((Consumer<Consumer>)booleanConsumer -> booleanConsumer.accept(busExplorerLogin.hasAdminRights())));
            });
            this.status.setText(Language.get(this.getClass(), "connected.as", busExplorerLogin.info.entity, busExplorerLogin.domain, busExplorerLogin.info.id));
            this.status.setEnabled(true);
            this.disconnect.setEnabled(true);
            this.notifiers.forEach((Consumer<Consumer<Boolean>>)((Consumer<Consumer>)booleanConsumer -> booleanConsumer.accept(busExplorerLogin.hasAdminRights())));
        }
    }

    private void buildDialog() {
        this.setMinimumSize(new Dimension(980, 700));
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout(0, 0));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                MainDialog.this.dispose();
                System.exit(0);
            }
        });
        this.buildFeaturesComponent();
        this.buildBottomPanel();
        this.pack();
        this.setDialogTitle("");
    }

    private void buildBottomPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        this.disconnect = new JButton(Language.get(this.getClass(), "disconnect"));
        this.disconnect.setEnabled(false);
        this.disconnect.setIcon(ApplicationIcons.ICON_LOGOUT_16);
        this.disconnect.setMnemonic(Language.get(this.getClass(), "disconnect.mnemonic").charAt(0));
        this.disconnect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.Service){

                    @Override
                    protected void doPerformTask() throws Exception {
                        Application.login().logout();
                        MainDialog.this.setDialogTitle("");
                        MainDialog.this.status.setText(Language.get(MainDialog.class, "title.disconnected"));
                        MainDialog.this.status.setEnabled(false);
                        MainDialog.this.disconnect.setEnabled(false);
                    }

                    protected void afterTaskUI() {
                        Application.showLoginDialog(MainDialog.this);
                    }
                };
                if (InputDialog.showConfirmDialog(MainDialog.this, Language.get(MainDialog.class, "disconnect.confirm.msg"), Language.get(MainDialog.class, "disconnect.confirm.title")) == 0) {
                    task.execute(MainDialog.this, Language.get(MainDialog.class, "logout.waiting.title"), Language.get(MainDialog.class, "logout.waiting.msg"));
                }
            }
        });
        panel.add((Component)this.disconnect, new GBC(0, 0).insets(5));
        this.status = new JLabel();
        this.status.setEnabled(false);
        this.status.setText(Language.get(MainDialog.class, "title.disconnected"));
        this.status.setHorizontalAlignment(4);
        panel.add((Component)this.status, new GBC(1, 0).insets(5).east().both());
        this.add((Component)panel, "South");
    }

    private void buildFeaturesComponent() {
        this.featuresPane = new JTabbedPane(1);
        this.featuresPane.setTabLayoutPolicy(1);
        LinkedHashMap<String, JComponent> conceptsPanels = new LinkedHashMap<String, JComponent>();
        conceptsPanels.put("offer", this.initPanelOffer());
        conceptsPanels.put("login", this.initPanelLogin());
        conceptsPanels.put("conf", this.initPanelConfiguration());
        conceptsPanels.put("editor", this.initPanelEditor());
        for (String concept : ((HashMap)conceptsPanels).keySet()) {
            String tabTitle = Language.get(MainDialog.class, concept + ".title");
            String tabTooltip = Language.get(MainDialog.class, concept + ".tooltip");
            this.featuresPane.addTab(tabTitle, null, (Component)((HashMap)conceptsPanels).get(concept), tabTooltip);
        }
        this.featuresPane.addChangeListener(changeEvent -> {
            Component selected = this.featuresPane.getSelectedComponent();
            if (selected instanceof RefreshDelegate) {
                ((RefreshDelegate)((Object)selected)).refresh(null);
            }
        });
        this.notifiers.add(isAdmin -> {
            MainDialog.disableTab(this.featuresPane, (JComponent)conceptsPanels.get("login"), isAdmin);
            MainDialog.disableTab(this.featuresPane, (JComponent)conceptsPanels.get("conf"), Application.login().admin.isReconfigurationCapable());
            this.featuresPane.setSelectedIndex(0);
            Component component = this.featuresPane.getSelectedComponent();
            ((RefreshDelegate)((Object)component)).refresh(null);
        });
        this.add((Component)this.featuresPane, "Center");
    }

    private static void disableTab(JTabbedPane pane, JComponent component, Boolean enabled) {
        int index = pane.indexOfComponent(component);
        pane.setEnabledAt(index, enabled);
        if (!enabled.booleanValue()) {
            pane.setForegroundAt(index, UIManager.getColor(TABBED_PANE_DISABLED_TEXT));
        } else {
            pane.setForegroundAt(index, UIManager.getColor(TABBED_PANE_FOREGROUND));
        }
    }

    private JComponent initPanelEditor() {
        JTabbedPane editorPane = new JTabbedPane(2);
        LinkedHashMap<String, JComponent> conceptsPanels = new LinkedHashMap<String, JComponent>();
        conceptsPanels.put("category", this.initPanelCategory());
        conceptsPanels.put("entity", this.initPanelEntity());
        conceptsPanels.put("certificate", this.initPanelCertificate());
        conceptsPanels.put("interface", this.initPanelInterface());
        conceptsPanels.put("authorization", this.initPanelAuthorization());
        conceptsPanels.put("integration", this.initExtensionEditor());
        conceptsPanels.put("pending", this.initPendingChecks());
        for (String concept : ((HashMap)conceptsPanels).keySet()) {
            String tabTitle = Language.get(MainDialog.class, concept + ".title");
            String tabTooltip = Language.get(MainDialog.class, concept + ".tooltip");
            editorPane.addTab(tabTitle, null, (Component)((HashMap)conceptsPanels).get(concept), tabTooltip);
        }
        editorPane.addChangeListener(changeEvent -> {
            Component selected = editorPane.getSelectedComponent();
            if (selected instanceof RefreshDelegate) {
                ((RefreshDelegate)((Object)selected)).refresh(null);
            }
        });
        this.notifiers.add(isAdmin -> {
            editorPane.setSelectedIndex(0);
            ((RefreshablePanel)editorPane.getSelectedComponent()).refresh(null);
            MainDialog.disableTab(editorPane, (JComponent)conceptsPanels.get("certificate"), isAdmin);
            MainDialog.disableTab(editorPane, (JComponent)conceptsPanels.get("integration"), Application.login().extension.isExtensionCapable());
        });
        return editorPane;
    }

    private JComponent initExtensionEditor() {
        JTabbedPane editorPane = new JTabbedPane(2);
        LinkedHashMap<String, RefreshablePanel> conceptsPanels = new LinkedHashMap<String, RefreshablePanel>();
        conceptsPanels.put("extension.overview", this.initPanelIntegrationOverview());
        conceptsPanels.put("extension.consumer", this.initPanelIntegrationConsumer());
        conceptsPanels.put("extension.provider", this.initPanelIntegrationProvider());
        conceptsPanels.put("extension.contract", this.initPanelIntegrationContract());
        for (String concept : ((HashMap)conceptsPanels).keySet()) {
            String tabTitle = Language.get(MainDialog.class, concept + ".title");
            String tabTooltip = Language.get(MainDialog.class, concept + ".tooltip");
            editorPane.addTab(tabTitle, null, (Component)((HashMap)conceptsPanels).get(concept), tabTooltip);
        }
        editorPane.addChangeListener(changeEvent -> {
            Component selected = editorPane.getSelectedComponent();
            if (selected instanceof RefreshDelegate) {
                ((RefreshDelegate)((Object)selected)).refresh(null);
            }
        });
        this.notifiers.add(isAdmin -> {
            if (Application.login().extension.isExtensionCapable()) {
                editorPane.setSelectedIndex(0);
                ((RefreshablePanel)editorPane.getSelectedComponent()).refresh(null);
            }
        });
        return editorPane;
    }

    private JComponent initPendingChecks() {
        return new ConsistencyReportPanel(this);
    }

    private RefreshablePanel initPanelIntegrationContract() {
        ObjectTableModel model = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new ContractTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new ContractRefreshAction(this));
        actionsVector.add(new ContractAddAction(this));
        actionsVector.add(new ContractEditAction(this));
        actionsVector.add(new ContractDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelIntegrationProvider() {
        ObjectTableModel model = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new ProviderTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new ProviderRefreshAction(this));
        actionsVector.add(new ProviderAddAction(this));
        actionsVector.add(new ProviderEditAction(this));
        actionsVector.add(new ProviderDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelIntegrationConsumer() {
        ObjectTableModel model = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new ConsumerTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new ConsumerRefreshAction(this));
        actionsVector.add(new ConsumerAddAction(this));
        actionsVector.add(new ConsumerEditAction(this));
        actionsVector.add(new ConsumerDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelIntegrationOverview() {
        ObjectTableModel model = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new IntegrationTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(5);
        actionsVector.add(new IntegrationExportToXLSAction(this));
        actionsVector.add(new IntegrationRefreshAction(this));
        actionsVector.add(new IntegrationAddAction(this));
        actionsVector.add(new IntegrationEditAction(this));
        actionsVector.add(new IntegrationDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelCategory() {
        ObjectTableModel model = new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new CategoryTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new CategoryRefreshAction(this));
        actionsVector.add(new CategoryAddAction(this));
        actionsVector.add(new CategoryEditAction(this));
        actionsVector.add(new CategoryDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelEntity() {
        ObjectTableModel model = new ObjectTableModel(new ArrayList(), (ObjectTableProvider)new EntityTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new EntityRefreshAction(this));
        actionsVector.add(new EntityAddAction(this));
        actionsVector.add(new EntityEditAction(this));
        actionsVector.add(new EntityDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelCertificate() {
        ObjectTableModel model = new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new CertificateTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new CertificateRefreshAction(this));
        actionsVector.add(new CertificateAddAction(this));
        actionsVector.add(new CertificateEditAction(this));
        actionsVector.add(new CertificateDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelInterface() {
        ObjectTableModel model = new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new InterfaceTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new InterfaceRefreshAction(this));
        actionsVector.add(new InterfaceAddAction(this));
        actionsVector.add(new InterfaceDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelAuthorization() {
        ObjectTableModel model = new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new AuthorizationTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(3);
        actionsVector.add(new AuthorizationRefreshAction(this));
        actionsVector.add(new AuthorizationAddAction(this));
        actionsVector.add(new AuthorizationDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelOffer() {
        ObjectTableModel model = new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new OfferTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(2);
        actionsVector.add(new OfferRefreshAction(this));
        actionsVector.add(new OfferDeleteAction(this));
        actionsVector.add(new OfferStatusAction(this));
        final OfferPropertiesAction propertiesAction = new OfferPropertiesAction(this);
        actionsVector.add(propertiesAction);
        TablePanelComponent panelOffer = new TablePanelComponent(model, actionsVector, true);
        panelOffer.addTableMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    propertiesAction.actionPerformed(null);
                }
            }
        });
        return panelOffer;
    }

    private RefreshablePanel initPanelLogin() {
        ObjectTableModel model = new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new LoginTableProvider());
        Vector<OpenBusAction> actionsVector = new Vector<OpenBusAction>(2);
        actionsVector.add(new LoginRefreshAction(this));
        actionsVector.add(new LoginDeleteAction(this));
        return new TablePanelComponent(model, actionsVector, true);
    }

    private RefreshablePanel initPanelConfiguration() {
        Vector<OpenBusAction> adminActionsVector = new Vector<OpenBusAction>(4);
        adminActionsVector.add(new AdminRefreshAction(this));
        adminActionsVector.add(new AdminAddAction(this));
        adminActionsVector.add(new AdminEditAction(this));
        adminActionsVector.add(new AdminDeleteAction(this));
        final TablePanelComponent adminsPanel = new TablePanelComponent(new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new AdminTableProvider()), adminActionsVector, false);
        Vector<OpenBusAction> validatorActionsVector = new Vector<OpenBusAction>(2);
        validatorActionsVector.add(new ValidatorRefreshAction(this));
        validatorActionsVector.add(new ValidatorRestartAction(this));
        validatorActionsVector.add(new ValidatorDeleteAction(this));
        final TablePanelComponent validatorsPanel = new TablePanelComponent(new ObjectTableModel(new LinkedList(), (ObjectTableProvider)new ValidatorTableProvider()), validatorActionsVector, false);
        final BasicSettingsPanel busSettings = BasicSettingsPanel.create(this);
        final AuditSettingsPanel auditSettings = AuditSettingsPanel.create(this);
        JPanel restoreDefaultsPanel = new JPanel((LayoutManager)new MigLayout("align center, insets 5"));
        JButton defaultsButton = new JButton(Language.get(MainDialog.class, "conf.restoredefaults"));
        defaultsButton.setIcon(ApplicationIcons.ICON_RESTORE_16);
        defaultsButton.setMnemonic(Language.get(MainDialog.class, "conf.restoredefaults.mnemonic").charAt(0));
        defaultsButton.setToolTipText(Language.get(MainDialog.class, "conf.restoredefaults.tooltip"));
        JButton refreshButton = new JButton(Language.get(MainDialog.class, "conf.refresh"));
        refreshButton.setMnemonic(Language.get(MainDialog.class, "conf.refresh.mnemonic").charAt(0));
        refreshButton.setToolTipText(Language.get(MainDialog.class, "conf.refresh.tooltip"));
        refreshButton.setIcon(ApplicationIcons.ICON_REFRESH_16);
        restoreDefaultsPanel.add(refreshButton);
        restoreDefaultsPanel.add(defaultsButton);
        final RefreshablePanel customPanel = new RefreshablePanel((LayoutManager)new MigLayout("flowx, fill, insets 0", "[]5[]")){

            @Override
            public void refresh(ActionEvent event) {
                busSettings.getRetrieveTask().execute(MainDialog.this, Language.get(MainDialog.class, "conf.waiting.title"), Language.get(MainDialog.class, "conf.waiting.msg"));
                auditSettings.getRetrieveTask().execute(MainDialog.this, Language.get(MainDialog.class, "conf.audit.waiting.title"), Language.get(MainDialog.class, "conf.audit.waiting.msg"));
                adminsPanel.refresh(event);
                validatorsPanel.refresh(event);
            }
        };
        refreshButton.addActionListener(e -> customPanel.refresh(null));
        defaultsButton.addActionListener(actionEvent -> {
            BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.BusCore){

                @Override
                protected void doPerformTask() throws Exception {
                    Application.login().admin.reloadConfigsFile();
                }

                protected void afterTaskUI() {
                    if (this.getStatus()) {
                        customPanel.refresh(null);
                    }
                }
            };
            task.execute(this, Language.get(MainDialog.class, "conf.waiting.title"), Language.get(MainDialog.class, "conf.waiting.msg"));
        });
        Border loweredBorder = BorderFactory.createEtchedBorder(1);
        busSettings.panel().setBorder(BorderFactory.createTitledBorder(loweredBorder, Language.get(MainDialog.class, "conf.settings.label")));
        auditSettings.panel().setBorder(BorderFactory.createTitledBorder(loweredBorder, Language.get(MainDialog.class, "conf.audit.label")));
        adminsPanel.setBorder(BorderFactory.createTitledBorder(loweredBorder, Language.get(MainDialog.class, "conf.admins.label")));
        validatorsPanel.setBorder(BorderFactory.createTitledBorder(loweredBorder, Language.get(MainDialog.class, "conf.validators.label")));
        JPanel leftPanel = new JPanel((LayoutManager)new MigLayout("fill, insets 0, flowy"));
        leftPanel.add((Component)busSettings.panel(), "north");
        leftPanel.add((Component)auditSettings.panel(), "grow");
        JPanel rightPanel = new JPanel((LayoutManager)new MigLayout("fill, insets 0, flowy"));
        rightPanel.add(adminsPanel, "grow");
        rightPanel.add(validatorsPanel, "growx");
        rightPanel.add((Component)restoreDefaultsPanel, "growx");
        customPanel.add((Component)leftPanel, "grow");
        customPanel.add((Component)rightPanel, "grow");
        this.notifiers.add(isAdmin -> {
            if (Application.login().admin.isReconfigurationCapable()) {
                defaultsButton.setEnabled((boolean)isAdmin);
            }
            busSettings.activate(Application.login().admin.isReconfigurationCapable() && isAdmin != false);
            auditSettings.activate(Application.login().audit.isAuditCapable() && isAdmin != false);
        });
        return customPanel;
    }

    private void setDialogTitle(String message) {
        String title = Language.get(Application.class, "title");
        if (!message.isEmpty()) {
            title = title + " - " + message;
        }
        this.setTitle(title);
    }
}

