/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.authorizations;

import busexplorer.Application;
import busexplorer.desktop.dialog.ConsistencyValidationDialog;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.authorizations.AuthorizationWrapper;
import busexplorer.panel.contracts.ContractDeleteAction;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.offers.OfferWrapper;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.BusQuery;
import busexplorer.utils.ConsistencyValidationResult;
import busexplorer.utils.Language;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import tecgraf.openbus.core.v2_1.services.access_control.LoginInfo;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceOfferDesc;
import tecgraf.openbus.core.v2_1.services.offer_registry.ServiceProperty;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntity;
import tecgraf.openbus.core.v2_1.services.offer_registry.admin.v1_0.RegisteredEntityDesc;
import tecgraf.openbus.services.governance.v1_0.Contract;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class AuthorizationDeleteAction
extends OpenBusAction<AuthorizationWrapper> {
    public AuthorizationDeleteAction(JFrame parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        ConsistencyValidationDialog.DeleteOptions removeFlags = new ConsistencyValidationDialog.DeleteOptions();
        ConsistencyValidationResult consistencyValidationResult = new ConsistencyValidationResult();
        List<AuthorizationWrapper> authorizations = this.getTablePanelComponent().getSelectedElements();
        BusExplorerTask<Void> deleteAuthorizationTask = AuthorizationDeleteAction.DeleteAuthorizationTask(authorizations, this.getTablePanelComponent()::removeSelectedElements, removeFlags, consistencyValidationResult);
        Runnable effectiveDeletion = () -> deleteAuthorizationTask.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
        if (AuthorizationDeleteAction.ExecuteAllDependencyCheckTasks(this.parentWindow, authorizations, consistencyValidationResult)) {
            if (consistencyValidationResult.isEmpty()) {
                effectiveDeletion.run();
            } else {
                new ConsistencyValidationDialog(this.parentWindow, this.getString("confirm.title"), this.getClass(), consistencyValidationResult, removeFlags, effectiveDeletion).showDialog();
            }
        }
    }

    public static boolean ExecuteAllDependencyCheckTasks(Window parentWindow, Collection<AuthorizationWrapper> authorizations, ConsistencyValidationResult consistencyValidationResult) {
        String title = Language.get(ConsistencyValidationDialog.class, "waiting.dependency.title");
        String waitingMessage = Language.get(AuthorizationDeleteAction.class, "waiting.dependency.msg");
        BusExplorerTask<Void> governanceDependencyCheckTask = AuthorizationDeleteAction.GovernanceDependencyCheckTask(authorizations, consistencyValidationResult);
        BusExplorerTask<Void> extensionDependencyCheckTask = AuthorizationDeleteAction.ExtensionDependencyCheckTask(authorizations, consistencyValidationResult);
        governanceDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        extensionDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        return extensionDependencyCheckTask.getStatus() && governanceDependencyCheckTask.getStatus() && ContractDeleteAction.ExecuteAllDependencyCheckTasks(parentWindow, consistencyValidationResult.getInconsistentContracts().values(), consistencyValidationResult);
    }

    public static BusExplorerTask<Void> GovernanceDependencyCheckTask(final Collection<AuthorizationWrapper> authorizations, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                List offers = Application.login().admin.getOffers();
                for (ServiceOfferDesc offer : offers) {
                    block1: for (AuthorizationWrapper auth : authorizations) {
                        for (ServiceProperty property : offer.properties) {
                            if (!property.name.equals("openbus.component.interface") || !property.value.equals(auth.getInterface())) continue;
                            consistencyValidationResult.getInconsistentOffers().add(new OfferWrapper(offer));
                            continue block1;
                        }
                    }
                    this.setProgressStatus(100 * i / offers.size());
                    ++i;
                }
            }
        };
    }

    public static BusExplorerTask<Void> ExtensionDependencyCheckTask(final Collection<AuthorizationWrapper> authorizations, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                if (Application.login().extension.isExtensionCapable()) {
                    LinkedHashMap contractsMaybeBroken = new LinkedHashMap();
                    int innerStatusSum = 0;
                    for (Provider provider : Application.login().extension.getProviders()) {
                        innerStatusSum += provider.contracts().length;
                    }
                    for (Provider provider : Application.login().extension.getProviders()) {
                        ProviderWrapper provider2 = new ProviderWrapper(provider);
                        for (RegisteredEntityDesc entityProvider : new BusQuery(provider2.busquery()).filterEntities()) {
                            for (AuthorizationWrapper authorization : authorizations) {
                                if (!entityProvider.id.equals(authorization.getEntityId())) continue;
                                for (String contractName : provider2.contracts()) {
                                    ContractWrapper contract = new ContractWrapper(Application.login().extension.getContractRegistry().get(contractName));
                                    String iface = authorization.getInterface();
                                    if (!contract.interfaces().contains(iface)) continue;
                                    if (contractsMaybeBroken.get(contract.name()) == null) {
                                        contractsMaybeBroken.put(contract.name(), new ArrayList());
                                    }
                                    ((List)contractsMaybeBroken.get(contract.name())).add(iface);
                                }
                            }
                        }
                        this.setProgressStatus(70 * i / innerStatusSum);
                        ++i;
                    }
                    i = 0;
                    for (Map.Entry entry : contractsMaybeBroken.entrySet()) {
                        Contract contract = Application.login().extension.getContractRegistry().get((String)entry.getKey());
                        ContractWrapper wrapper = new ContractWrapper(contract);
                        if (wrapper.interfaces().size() == ((List)entry.getValue()).size()) {
                            consistencyValidationResult.getInconsistentContracts().put(wrapper.name(), wrapper);
                        }
                        this.setProgressStatus(70 + 30 * i / contractsMaybeBroken.entrySet().size());
                        ++i;
                    }
                }
            }
        };
    }

    public static BusExplorerTask<Void> DeleteAuthorizationTask(final Collection<AuthorizationWrapper> authorizations, final Runnable delegateAfterTaskUI, final ConsistencyValidationDialog.DeleteOptions removeFlags, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.BusCore){
            private final String removeDependenciesTitle;
            private final String removeDependenciesMessage;
            {
                super(context);
                this.removeDependenciesTitle = Language.get(AuthorizationDeleteAction.class, "waiting.removing.dependencies.title");
                this.removeDependenciesMessage = Language.get(AuthorizationDeleteAction.class, "waiting.removing.dependencies.msg");
            }

            @Override
            protected void doPerformTask() throws Exception {
                int i = 0;
                if (Application.login().extension.isExtensionCapable()) {
                    if (removeFlags.isFullyGovernanceRemoval() && !consistencyValidationResult.getInconsistentContracts().isEmpty()) {
                        ContractDeleteAction.DeleteContractTask(consistencyValidationResult.getInconsistentContracts().values(), null, removeFlags, consistencyValidationResult).execute(this.parentWindow, this.removeDependenciesTitle, this.removeDependenciesMessage, 2, 0, true, false);
                    }
                    for (Object authorization : authorizations) {
                        block1: for (Contract contract : Application.login().extension.getContracts()) {
                            String[] interfaceContractList;
                            for (String inContract : interfaceContractList = contract.interfaces()) {
                                if (!inContract.equals(((AuthorizationWrapper)authorization).getInterface())) continue;
                                contract.removeInterface(inContract);
                                continue block1;
                            }
                        }
                        this.setProgressStatus(25 * i / authorizations.size());
                        ++i;
                    }
                }
                i = 0;
                if (removeFlags.isFullyGovernanceRemoval()) {
                    Set<OfferWrapper> inconsistentOffers = consistencyValidationResult.getInconsistentOffers();
                    for (OfferWrapper offer : inconsistentOffers) {
                        LoginInfo login = offer.getDescriptor().ref.owner();
                        Application.login().admin.invalidateLogin(login);
                        for (AuthorizationWrapper authorization : authorizations) {
                            Application.login().admin.revokeAuthorization(login.entity, authorization.getInterface());
                        }
                        this.setProgressStatus(25 + 35 * i / inconsistentOffers.size());
                        ++i;
                    }
                }
                i = 0;
                for (Object authorization : authorizations) {
                    RegisteredEntity ref = ((AuthorizationWrapper)authorization).getEntityDescriptor().ref;
                    String interfaceName = ((AuthorizationWrapper)authorization).getInterface();
                    ref.revokeInterface(interfaceName);
                    this.setProgressStatus(60 + 40 * i / authorizations.size());
                    ++i;
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus() && delegateAfterTaskUI != null) {
                    delegateAfterTaskUI.run();
                }
            }
        };
    }
}

