/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.contracts;

import busexplorer.Application;
import busexplorer.desktop.dialog.ConsistencyValidationDialog;
import busexplorer.desktop.dialog.InputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.ActionType;
import busexplorer.panel.OpenBusAction;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.panel.integrations.IntegrationWrapper;
import busexplorer.panel.providers.ProviderDeleteAction;
import busexplorer.panel.providers.ProviderWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.ConsistencyValidationResult;
import busexplorer.utils.Language;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import tecgraf.openbus.services.governance.v1_0.Contract;
import tecgraf.openbus.services.governance.v1_0.Integration;
import tecgraf.openbus.services.governance.v1_0.Provider;

public class ContractDeleteAction
extends OpenBusAction<ContractWrapper> {
    public ContractDeleteAction(Window parentWindow) {
        super(parentWindow);
    }

    @Override
    public ActionType getActionType() {
        return ActionType.REMOVE;
    }

    @Override
    public boolean abilityConditions() {
        return Application.login() != null && Application.login().hasAdminRights();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (InputDialog.showConfirmDialog(this.parentWindow, this.getString("confirm.msg"), this.getString("confirm.title")) != 0) {
            return;
        }
        ConsistencyValidationDialog.DeleteOptions removeFlags = new ConsistencyValidationDialog.DeleteOptions();
        ConsistencyValidationResult consistencyValidationResult = new ConsistencyValidationResult();
        List<ContractWrapper> contracts = this.getTablePanelComponent().getSelectedElements();
        BusExplorerTask<Void> deleteContractTask = ContractDeleteAction.DeleteContractTask(contracts, this.getTablePanelComponent()::removeSelectedElements, removeFlags, consistencyValidationResult);
        Runnable effectiveDeletion = () -> deleteContractTask.execute(this.parentWindow, this.getString("waiting.title"), this.getString("waiting.msg"), 2, 0, true, false);
        if (ContractDeleteAction.ExecuteAllDependencyCheckTasks(this.parentWindow, contracts, consistencyValidationResult)) {
            if (consistencyValidationResult.isEmpty()) {
                effectiveDeletion.run();
            } else {
                new ConsistencyValidationDialog(this.parentWindow, this.getString("confirm.title"), this.getClass(), consistencyValidationResult, removeFlags, effectiveDeletion).showDialog();
            }
        }
    }

    public static boolean ExecuteAllDependencyCheckTasks(Window parentWindow, Collection<ContractWrapper> contracts, ConsistencyValidationResult consistencyValidationResult) {
        String title = Language.get(ConsistencyValidationDialog.class, "waiting.dependency.title");
        String waitingMessage = Language.get(ContractDeleteAction.class, "waiting.dependency.msg");
        BusExplorerTask<Void> extensionDependencyCheckTask = ContractDeleteAction.ExtensionDependencyCheckTask(contracts, consistencyValidationResult);
        extensionDependencyCheckTask.execute(parentWindow, title, waitingMessage, 2, 0, true, false);
        return extensionDependencyCheckTask.getStatus() && ProviderDeleteAction.ExecuteAllDependencyCheckTasks(parentWindow, consistencyValidationResult.getInconsistentProviders().values(), consistencyValidationResult);
    }

    public static BusExplorerTask<Void> ExtensionDependencyCheckTask(final Collection<ContractWrapper> contracts, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                this.setProgressDialogEnabled(true);
                int i = 0;
                for (ContractWrapper contractToRemove : contracts) {
                    String contractBeingRemovedName = contractToRemove.name();
                    for (Integration integration : Application.login().extension.getIntegrationRegistry().integrations()) {
                        for (Contract contract : integration.contracts()) {
                            int integrationId = integration.id();
                            if (!contract.name().equals(contractBeingRemovedName) || consistencyValidationResult.getInconsistentIntegrations().containsKey(integrationId)) continue;
                            consistencyValidationResult.getInconsistentIntegrations().put(integrationId, new IntegrationWrapper(integration));
                        }
                    }
                    for (Integration integration : Application.login().extension.getProviderRegistry().providers()) {
                        String providerName = integration.name();
                        for (Contract contract : integration.contracts()) {
                            if (!contract.name().equals(contractBeingRemovedName) || consistencyValidationResult.getInconsistentProviders().containsKey(providerName)) continue;
                            consistencyValidationResult.getInconsistentProviders().put(providerName, new ProviderWrapper((Provider)integration));
                        }
                    }
                    this.setProgressStatus(100 * i / contracts.size());
                    ++i;
                }
            }
        };
    }

    public static BusExplorerTask<Void> DeleteContractTask(final Collection<ContractWrapper> contracts, final Runnable delegateAfterTaskUI, final ConsistencyValidationDialog.DeleteOptions removeFlags, final ConsistencyValidationResult consistencyValidationResult) {
        return new BusExplorerTask<Void>(ExceptionContext.Service){
            private final String removeDependenciesTitle;
            private final String removeDependenciesMessage;
            {
                super(context);
                this.removeDependenciesTitle = Language.get(ContractDeleteAction.class, "waiting.removing.dependencies.title");
                this.removeDependenciesMessage = Language.get(ContractDeleteAction.class, "waiting.removing.dependencies.msg");
            }

            @Override
            protected void doPerformTask() throws Exception {
                if (removeFlags.isFullyGovernanceRemoval()) {
                    ProviderDeleteAction.DeleteProviderTask(consistencyValidationResult.getInconsistentProviders().values(), null, removeFlags, consistencyValidationResult).execute(this.parentWindow, this.removeDependenciesTitle, this.removeDependenciesMessage, 2, 0, true, false);
                }
                int i = 0;
                for (ContractWrapper contract : contracts) {
                    Application.login().extension.getContractRegistry().remove(contract.name());
                    this.setProgressStatus(100 * i / contracts.size());
                    ++i;
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus() && delegateAfterTaskUI != null) {
                    delegateAfterTaskUI.run();
                }
            }
        };
    }
}

