/*
 * Decompiled with CFR 0.152.
 */
package busexplorer.panel.contracts;

import busexplorer.Application;
import busexplorer.desktop.dialog.BusExplorerAbstractInputDialog;
import busexplorer.exception.handling.ExceptionContext;
import busexplorer.panel.TablePanelComponent;
import busexplorer.panel.contracts.ContractWrapper;
import busexplorer.utils.BusExplorerTask;
import busexplorer.utils.Language;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.Collections;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.miginfocom.swing.MigLayout;
import tecgraf.openbus.services.governance.v1_0.Contract;

public class ContractInputDialog
extends BusExplorerAbstractInputDialog {
    private JLabel nameLabel;
    private JTextField nameTextField;
    private JLabel interfacesLabel;
    private JList<String> interfacesList;
    private final List<String> interfaces;
    private TablePanelComponent<ContractWrapper> panel;
    private ContractWrapper editingContract = null;

    public ContractInputDialog(Window parentWindow, TablePanelComponent<ContractWrapper> panel, List<String> interfaces) {
        super(parentWindow);
        this.panel = panel;
        this.interfaces = interfaces;
        Collections.sort(this.interfaces);
    }

    @Override
    protected boolean accept() {
        if (!this.hasValidFields()) {
            return false;
        }
        BusExplorerTask<Void> task = new BusExplorerTask<Void>(ExceptionContext.Service){

            @Override
            protected void doPerformTask() throws Exception {
                if (ContractInputDialog.this.editingContract == null) {
                    Contract contract = Application.login().extension.getContractRegistry().add(ContractInputDialog.this.nameTextField.getText());
                    ContractInputDialog.this.interfacesList.getSelectedValuesList().forEach(iface -> contract.addInterface(iface));
                    ContractInputDialog.this.editingContract = new ContractWrapper(contract);
                } else {
                    ContractInputDialog.this.editingContract.interfaces(ContractInputDialog.this.interfacesList.getSelectedValuesList());
                }
            }

            protected void afterTaskUI() {
                if (this.getStatus()) {
                    ContractInputDialog.this.panel.refresh(null);
                    ContractInputDialog.this.panel.selectElement(ContractInputDialog.this.editingContract, true);
                }
            }
        };
        task.execute(this, Language.get(this.getClass(), "waiting.title"), Language.get(this.getClass(), "waiting.msg"));
        return task.getStatus();
    }

    @Override
    public JPanel buildFields() {
        this.setMinimumSize(new Dimension(550, 350));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("fill, flowy"));
        this.nameLabel = new JLabel(Language.get(this.getClass(), "name.label"));
        panel.add((Component)this.nameLabel, "grow");
        this.nameTextField = new JTextField();
        this.nameTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (ContractInputDialog.this.nameTextField.getText().trim().isEmpty()) {
                    ContractInputDialog.this.setErrorMessage(Language.get(ContractInputDialog.class, "error.validation.name"));
                } else {
                    ContractInputDialog.this.clearErrorMessage();
                }
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
            }
        });
        panel.add((Component)this.nameTextField, "grow");
        this.interfacesLabel = new JLabel(Language.get(this.getClass(), "interfaces.label"));
        panel.add((Component)this.interfacesLabel, "grow");
        this.interfacesList = new JList<Object>(this.interfaces.toArray());
        this.interfacesList.setSelectionMode(2);
        this.interfacesList.addListSelectionListener(listener -> {
            if (listener.getFirstIndex() != -1 && listener.getLastIndex() != -1) {
                this.clearErrorMessage();
            }
        });
        JScrollPane scroll = new JScrollPane(this.interfacesList);
        panel.add((Component)scroll, "grow, push");
        return panel;
    }

    @Override
    public boolean hasValidFields() {
        if (this.nameTextField.getText().trim().isEmpty()) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.name"));
            return false;
        }
        if (this.interfacesList.getSelectedValuesList().size() == 0) {
            this.setErrorMessage(Language.get(this.getClass(), "error.validation.interfaces"));
            return false;
        }
        this.clearErrorMessage();
        return true;
    }

    public void setEditionMode(ContractWrapper info) {
        this.editingContract = info;
        this.nameTextField.setText(info.name());
        this.nameTextField.setEditable(false);
        List<String> updated = info.interfaces();
        if (updated.size() > 0) {
            this.interfacesList.setSelectedValue(updated.get(0), true);
            int[] indices = new int[updated.size()];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = this.interfaces.indexOf(updated.get(i));
            }
            this.interfacesList.setSelectedIndices(indices);
        }
    }
}

